/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.pathqueryresult;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.api.profile.InterMineBag;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.CollectionDescriptor;
import org.intermine.metadata.ConstraintOp;
import org.intermine.metadata.Model;
import org.intermine.metadata.TypeUtil;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryCollectionReference;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.OuterJoinStatus;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.util.CollectionUtil;
import org.intermine.util.DynamicUtil;
import org.intermine.web.logic.WebUtil;
import org.intermine.web.logic.config.FieldConfig;
import org.intermine.web.logic.config.FieldConfigHelper;
import org.intermine.web.logic.config.WebConfig;

public final class PathQueryResultHelper {
    private static final Logger LOG = Logger.getLogger(PathQueryResultHelper.class);

    private PathQueryResultHelper() {
    }

    public static List<String> getDefaultViewForClass(String type, Model model, WebConfig webConfig, String startingPath) {
        String prefix = startingPath;
        ArrayList<String> view = new ArrayList<String>();
        ClassDescriptor cld = model.getClassDescriptorByName(type);
        List<FieldConfig> fieldConfigs = FieldConfigHelper.getClassFieldConfigs(webConfig, cld);
        if (StringUtils.isEmpty((String)prefix)) {
            prefix = type;
        }
        for (FieldConfig fieldConfig : fieldConfigs) {
            String relPath = fieldConfig.getFieldExpr();
            if (!fieldConfig.getShowInResults()) continue;
            try {
                Path path = new Path(model, prefix + "." + relPath);
                Path checkIsOnlyAttribute = new Path(model, type + "." + relPath);
                if (!checkIsOnlyAttribute.isOnlyAttribute()) continue;
                view.add(path.getNoConstraintsString());
            }
            catch (PathException e) {
                LOG.error((Object)("Invalid path configured in webconfig for class: " + type));
            }
        }
        if (view.size() == 0) {
            for (AttributeDescriptor att : cld.getAllAttributeDescriptors()) {
                if ("id".equals(att.getName())) continue;
                view.add(prefix + "." + att.getName());
            }
        }
        return view;
    }

    public static List<String> getDefaultViewForClass(String type, Model model, WebConfig webConfig) {
        ClassDescriptor cld = model.getClassDescriptorByName(type);
        if (cld == null) {
            throw new IllegalArgumentException(type + " is not in the data model");
        }
        try {
            return PathQueryResultHelper.getConfiguredView(cld, webConfig);
        }
        catch (UnconfiguredException e) {
            return PathQueryResultHelper.getAttributeView(cld);
        }
    }

    private static List<String> getAttributeView(ClassDescriptor cld) {
        ArrayList<String> view = new ArrayList<String>();
        String basePath = cld.getUnqualifiedName() + ".";
        for (AttributeDescriptor att : cld.getAllAttributeDescriptors()) {
            if ("id".equals(att.getName())) continue;
            view.add(basePath + att.getName());
        }
        return view;
    }

    private static List<String> getConfiguredView(ClassDescriptor cld, WebConfig webConfig) throws UnconfiguredException {
        LinkedHashSet<String> view = new LinkedHashSet<String>();
        Model m = cld.getModel();
        for (FieldConfig fieldConfig : PathQueryResultHelper.resultConfigs(webConfig, cld)) {
            try {
                Path p = new Path(m, cld.getUnqualifiedName() + "." + fieldConfig.getFieldExpr());
                if (p.isRootPath() || p.endIsReference()) {
                    view.addAll(PathQueryResultHelper.getSubview(webConfig, m, p));
                    continue;
                }
                if (!p.endIsAttribute()) continue;
                view.add(p.getNoConstraintsString());
            }
            catch (PathException e) {
                LOG.error((Object)("Invalid path configured in webconfig for class: " + cld));
            }
        }
        if (view.isEmpty()) {
            throw new UnconfiguredException();
        }
        return new ArrayList<String>(view);
    }

    private static List<String> getSubview(WebConfig webConfig, Model m, Path path) throws PathException {
        ArrayList<String> subview = new ArrayList<String>();
        String basePath = path.toStringNoConstraints() + ".";
        List<FieldConfig> subconfs = FieldConfigHelper.getClassFieldConfigs(webConfig, path.getEndClassDescriptor());
        for (FieldConfig fc : subconfs) {
            String pathString = basePath + fc.getFieldExpr();
            Path pathToAdd = new Path(m, pathString);
            if (!pathToAdd.endIsAttribute() || fc.getDisplayer() != null || !fc.getShowInSummary()) continue;
            subview.add(pathToAdd.getNoConstraintsString());
        }
        return subview;
    }

    private static Collection<FieldConfig> resultConfigs(WebConfig webConfig, ClassDescriptor cld) {
        List<FieldConfig> fieldConfigs = FieldConfigHelper.getClassFieldConfigs(webConfig, cld);
        Iterator<FieldConfig> it = fieldConfigs.iterator();
        while (it.hasNext()) {
            FieldConfig f = it.next();
            if (f.getShowInResults()) continue;
            it.remove();
        }
        return fieldConfigs;
    }

    public static PathQuery makePathQueryForBag(InterMineBag imBag, WebConfig webConfig, Model model) {
        PathQuery query = new PathQuery(model);
        query.addViews(PathQueryResultHelper.getDefaultViewForClass(imBag.getType(), model, webConfig));
        query.addConstraint((PathConstraint)Constraints.in((String)imBag.getType(), (String)imBag.getName()));
        return query;
    }

    public static PathQuery makePathQueryForCollection(WebConfig webConfig, ObjectStore os, InterMineObject object, String referencedClassName, String field) {
        Path path;
        String className = TypeUtil.unqualifiedName((String)DynamicUtil.getSimpleClassName(object.getClass()));
        try {
            path = new Path(os.getModel(), className + "." + field);
        }
        catch (PathException e) {
            throw new IllegalArgumentException("Could not build path for \"" + className + "." + field + "\".");
        }
        List<Class<?>> types = new ArrayList();
        if (path.endIsCollection()) {
            CollectionDescriptor end = (CollectionDescriptor)path.getEndFieldDescriptor();
            if (end.getReferencedClassName().equals(referencedClassName)) {
                types = PathQueryResultHelper.queryForTypesInCollection(object, field, os);
            }
            if (types.isEmpty()) {
                types.add(os.getModel().getClassDescriptorByName(referencedClassName).getType());
            }
        } else if (path.endIsReference()) {
            types.add(path.getLastClassDescriptor().getType());
        }
        return PathQueryResultHelper.makePathQueryForCollectionForClass(webConfig, os.getModel(), object, field, types);
    }

    public static List<Class<?>> queryForTypesInCollection(InterMineObject object, String field, ObjectStore os) {
        ClassDescriptor startCld;
        CollectionDescriptor col;
        ClassDescriptor colCld;
        ArrayList typesInCollection = new ArrayList();
        Model model = os.getModel();
        if (model.getAllSubs(colCld = (col = (startCld = model.getClassDescriptorByName(DynamicUtil.getSimpleClassName((FastPathObject)object))).getCollectionDescriptorByName(field, true)).getReferencedClassDescriptor()).isEmpty()) {
            typesInCollection.add(colCld.getType());
        } else {
            Query query = new Query();
            QueryClass qc = new QueryClass(colCld.getType());
            query.addFrom((FromElement)qc);
            query.addToSelect((QuerySelectable)new QueryField(qc, "class"));
            query.setDistinct(true);
            query.setConstraint((Constraint)new ContainsConstraint((QueryReference)new QueryCollectionReference(object, field), ConstraintOp.CONTAINS, qc));
            for (Object o : os.executeSingleton(query)) {
                typesInCollection.add((Class)o);
            }
            if (typesInCollection.isEmpty()) {
                typesInCollection.add(colCld.getType());
            }
        }
        return typesInCollection;
    }

    private static PathQuery makePathQueryForCollectionForClass(WebConfig webConfig, Model model, InterMineObject object, String field, List<Class<?>> sr) {
        Class commonClass = CollectionUtil.findCommonSuperclass(sr);
        String typeOfCollection = TypeUtil.unqualifiedName((String)DynamicUtil.getSimpleClassName((Class)commonClass));
        String startClass = TypeUtil.unqualifiedName((String)DynamicUtil.getSimpleClassName(object.getClass()));
        String collectionPath = startClass + "." + field;
        PathQuery pathQuery = PathQueryResultHelper.getQueryWithDefaultView(typeOfCollection, model, webConfig, collectionPath);
        pathQuery.addConstraint((PathConstraint)Constraints.eq((String)(startClass + ".id"), (String)object.getId().toString()));
        return pathQuery;
    }

    protected static PathQuery getQueryWithDefaultView(String objType, Model model, WebConfig webConfig, String fieldType) {
        String prefix = fieldType;
        PathQuery query = new PathQuery(model);
        ClassDescriptor cld = model.getClassDescriptorByName(objType);
        List<FieldConfig> fieldConfigs = FieldConfigHelper.getClassFieldConfigs(webConfig, cld);
        if (!StringUtils.isBlank((String)prefix)) {
            try {
                Path fieldPath = new Path(model, fieldType);
                String fieldEndType = TypeUtil.unqualifiedName((String)fieldPath.getEndType().getName());
                if (!fieldEndType.equals(objType)) {
                    query.addConstraint((PathConstraint)Constraints.type((String)fieldType, (String)objType));
                }
            }
            catch (PathException e) {
                LOG.error((Object)("Invalid path configured in webconfig for class: " + objType));
            }
        }
        for (FieldConfig fieldConfig : fieldConfigs) {
            if (!fieldConfig.getShowInResults()) continue;
            String path = prefix + "." + fieldConfig.getFieldExpr();
            int from = prefix.length() + 1;
            while (path.indexOf(46, from) != -1) {
                int dotPos = path.indexOf(46, from);
                int nextDot = path.indexOf(46, dotPos + 1);
                String outerJoin = nextDot == -1 ? path.substring(0, dotPos) : path.substring(0, nextDot);
                query.setOuterJoinStatus(outerJoin, OuterJoinStatus.OUTER);
                from = dotPos + 1;
            }
            query.addView(path);
        }
        if (query.getView().size() == 0) {
            for (AttributeDescriptor att : cld.getAllAttributeDescriptors()) {
                if ("id".equals(att.getName())) continue;
                query.addView(prefix + "." + att.getName());
            }
        }
        return query;
    }

    public static List<String> getAliasedColumnHeaders(PathQuery pq, WebConfig webConfig) {
        List views = pq.getView();
        ArrayList<String> aliasedViews = new ArrayList<String>();
        for (String view : views) {
            Path viewPath;
            try {
                viewPath = pq.makePath(view);
            }
            catch (PathException e) {
                throw new RuntimeException(e);
            }
            aliasedViews.add(WebUtil.formatPath(viewPath, webConfig));
        }
        return aliasedViews;
    }

    private static class UnconfiguredException
    extends Exception {
        private UnconfiguredException() {
        }
    }
}

