/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.intermine.api.bag.BagManager;
import org.intermine.api.bag.BagQueryConfig;
import org.intermine.api.config.ClassKeyHelper;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.MainHelper;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.ConstraintOp;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.metadata.StringUtil;
import org.intermine.objectstore.ObjectStoreSummary;
import org.intermine.objectstore.query.BagConstraint;
import org.intermine.objectstore.query.SimpleConstraint;
import org.intermine.pathquery.ConstraintValueParser;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathConstraintAttribute;
import org.intermine.pathquery.PathConstraintBag;
import org.intermine.pathquery.PathConstraintLookup;
import org.intermine.pathquery.PathConstraintLoop;
import org.intermine.pathquery.PathConstraintMultiValue;
import org.intermine.pathquery.PathConstraintNull;
import org.intermine.pathquery.PathConstraintRange;
import org.intermine.pathquery.PathConstraintSubclass;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.template.SwitchOffAbility;
import org.intermine.web.autocompletion.AutoCompleter;
import org.intermine.web.logic.query.DisplayConstraintHelpMessages;
import org.intermine.web.logic.querybuilder.DisplayPath;

public class DisplayConstraint {
    private static final Logger LOG = Logger.getLogger(DisplayConstraint.class);
    private Path path;
    private List<DisplayConstraintOption> validOps;
    private AutoCompleter ac;
    private ObjectStoreSummary oss;
    private String endCls;
    private String fieldName;
    private BagQueryConfig bagQueryConfig;
    private Map<String, List<FieldDescriptor>> classKeys;
    private BagManager bagManager;
    private Profile profile;
    private String constraintLabel;
    private List<DisplayConstraintOption> fixedOps;
    private PathConstraint con;
    private PathQuery query;
    private String code;
    private boolean editableInTemplate;
    private SwitchOffAbility switchOffAbility;
    private boolean isBagSelected;
    private String selectedBagValue;
    private ConstraintOp selectedBagOp;
    private List<Object> templateSummary;
    private boolean showExtraConstraint = false;

    protected DisplayConstraint(Path path, Profile profile, PathQuery query, AutoCompleter ac, ObjectStoreSummary oss, BagQueryConfig bagQueryConfig, Map<String, List<FieldDescriptor>> classKeys, BagManager bagManager) {
        this.init(path, profile, query, ac, oss, bagQueryConfig, classKeys, bagManager);
    }

    private void init(Path path, Profile profile, PathQuery query, AutoCompleter ac, ObjectStoreSummary oss, BagQueryConfig bagQueryConfig, Map<String, List<FieldDescriptor>> classKeys, BagManager bagManager) {
        this.path = path;
        this.ac = ac;
        this.oss = oss;
        this.endCls = this.getEndClass(path);
        this.fieldName = this.getFieldName(path);
        this.bagQueryConfig = bagQueryConfig;
        this.classKeys = classKeys;
        this.profile = profile;
        this.query = query;
        this.bagManager = bagManager;
        this.isBagSelected = false;
        if (this.isExtraConstraint()) {
            this.showExtraConstraint = true;
        }
    }

    private String getEndClass(Path path) {
        if (path.isRootPath()) {
            return path.getStartClassDescriptor().getType().getSimpleName();
        }
        return path.getLastClassDescriptor().getType().getSimpleName();
    }

    private String getFieldName(Path path) {
        if (!path.isRootPath()) {
            return path.getLastElement();
        }
        return null;
    }

    private String constraintStringValue(PathConstraint con) {
        if (con instanceof PathConstraintAttribute) {
            return ((PathConstraintAttribute)con).getValue();
        }
        if (con instanceof PathConstraintRange) {
            return this.getMultiValuesAsString();
        }
        if (con instanceof PathConstraintBag) {
            return ((PathConstraintBag)con).getBag();
        }
        if (con instanceof PathConstraintLookup) {
            return ((PathConstraintLookup)con).getValue();
        }
        if (con instanceof PathConstraintSubclass) {
            return ((PathConstraintSubclass)con).getType();
        }
        if (con instanceof PathConstraintLoop) {
            return ((PathConstraintLoop)con).getLoopPath();
        }
        if (con instanceof PathConstraintNull) {
            return ((PathConstraintNull)con).getOp().toString();
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isEditableInTemplate() {
        return this.editableInTemplate;
    }

    public DisplayPath getPath() {
        return new DisplayPath(this.path);
    }

    public String getSelectedValue() {
        if (this.isBagSelected) {
            return this.selectedBagValue;
        }
        if (this.con != null) {
            return this.constraintStringValue(this.con);
        }
        return null;
    }

    public String getOriginalValue() {
        if (this.con != null) {
            return this.constraintStringValue(this.con);
        }
        return null;
    }

    public Collection<String> getMultiValues() {
        if (this.isMultiValueSelected() || this.isRangeSelected()) {
            return ((PathConstraintMultiValue)this.con).getValues();
        }
        return null;
    }

    public String getMultiValuesAsString() {
        String multiValuesAsString = "";
        if (this.getMultiValues() != null) {
            for (String value : this.getMultiValues()) {
                multiValuesAsString = multiValuesAsString + value + ",";
            }
            multiValuesAsString = multiValuesAsString.substring(0, multiValuesAsString.lastIndexOf(","));
        }
        return multiValuesAsString;
    }

    public boolean isBagSelected() {
        if (this.isBagSelected) {
            return this.isBagSelected;
        }
        return this.con != null && this.con instanceof PathConstraintBag;
    }

    public void setBagSelected(boolean isBagSelected) {
        this.isBagSelected = isBagSelected;
    }

    public boolean isNullSelected() {
        return this.con != null && this.con instanceof PathConstraintNull;
    }

    public boolean isBoolean() {
        String type = this.getPath().getType();
        return "boolean".equals(type) || "Boolean".equals(type);
    }

    public boolean isValueSelected() {
        if (this.con != null) {
            return !this.isBagSelected() && !this.isNullSelected() && !this.isLoopSelected() && !this.isRangeSelected();
        }
        return false;
    }

    public boolean isLoopSelected() {
        return this.con != null && this.con instanceof PathConstraintLoop;
    }

    public boolean isRangeSelected() {
        return this.con != null && this.con instanceof PathConstraintRange;
    }

    public boolean isMultiValueSelected() {
        return this.con != null && this.con instanceof PathConstraintMultiValue;
    }

    public String getTitle() {
        return this.endCls + (this.fieldName == null ? "" : " " + this.fieldName);
    }

    public String getEndClassName() {
        return this.endCls;
    }

    public String getDescription() {
        return this.constraintLabel;
    }

    public String getHelpMessage() {
        return DisplayConstraintHelpMessages.getHelpMessage(this);
    }

    public DisplayConstraintOption getSelectedOp() {
        ConstraintOp selectedOp;
        if (this.isBagSelected) {
            return new DisplayConstraintOption(this.selectedBagOp.toString(), this.selectedBagOp.getIndex());
        }
        if (this.con != null && (selectedOp = this.con.getOp()) != null) {
            return new DisplayConstraintOption(selectedOp.toString(), selectedOp.getIndex());
        }
        return null;
    }

    public void setSelectedBagOp(ConstraintOp selectedBagOp) {
        this.selectedBagOp = selectedBagOp;
    }

    public void setSelectedBagValue(String selectedBagValue) {
        this.selectedBagValue = selectedBagValue;
    }

    public String getSelectedExtraValue() {
        if (this.con instanceof PathConstraintLookup) {
            return ((PathConstraintLookup)this.con).getExtraValue();
        }
        return null;
    }

    public List<DisplayConstraintOption> getValidOps() {
        if (this.validOps != null) {
            return this.validOps;
        }
        this.validOps = new ArrayList<DisplayConstraintOption>();
        if (this.con instanceof PathConstraintBag) {
            for (ConstraintOp op : PathConstraintBag.VALID_OPS) {
                this.validOps.add(new DisplayConstraintOption(op.toString(), op.getIndex()));
            }
        } else {
            if (this.con instanceof PathConstraintSubclass) {
                return this.validOps;
            }
            if (this.con instanceof PathConstraintLoop) {
                List<DisplayConstraintOption> loopQueryOps = this.getLoopQueryOps();
                for (DisplayConstraintOption dco : loopQueryOps) {
                    this.validOps.add(dco);
                }
            } else if (this.con instanceof PathConstraintRange) {
                this.validOps.addAll(this.getRangeQueryOps());
            } else if (this.path.endIsAttribute()) {
                List allOps = SimpleConstraint.validOps((Class)this.path.getEndType());
                boolean existPossibleValues = this.getPossibleValues() != null && this.getPossibleValues().size() > 0;
                for (ConstraintOp op : allOps) {
                    if (!existPossibleValues && (op.getIndex().equals(ConstraintOp.MATCHES.getIndex()) || op.getIndex().equals(ConstraintOp.DOES_NOT_MATCH.getIndex()))) continue;
                    this.validOps.add(new DisplayConstraintOption(op.toString(), op.getIndex()));
                }
                if (existPossibleValues) {
                    for (ConstraintOp op : PathConstraintMultiValue.VALID_OPS) {
                        this.validOps.add(new DisplayConstraintOption(op.toString(), op.getIndex()));
                    }
                }
            } else if (this.isLookup()) {
                ConstraintOp lookup = ConstraintOp.LOOKUP;
                this.validOps.add(new DisplayConstraintOption(lookup.toString(), lookup.getIndex()));
            }
        }
        return this.validOps;
    }

    public List<DisplayConstraintOption> getLoopQueryOps() {
        return Arrays.asList(new DisplayConstraintOption(ConstraintOp.EQUALS.toString(), ConstraintOp.EQUALS.getIndex()), new DisplayConstraintOption(ConstraintOp.NOT_EQUALS.toString(), ConstraintOp.NOT_EQUALS.getIndex()));
    }

    public List<DisplayConstraintOption> getRangeQueryOps() {
        ArrayList<DisplayConstraintOption> rangeQueryOps = new ArrayList<DisplayConstraintOption>();
        for (ConstraintOp op : PathConstraintRange.VALID_OPS) {
            rangeQueryOps.add(new DisplayConstraintOption(op.toString(), op.getIndex()));
        }
        return rangeQueryOps;
    }

    public boolean isLookup() {
        return !this.path.endIsAttribute() && ClassKeyHelper.hasKeyFields(this.classKeys, (String)this.endCls);
    }

    public DisplayConstraintOption getLookupOp() {
        ConstraintOp lookup = ConstraintOp.LOOKUP;
        return new DisplayConstraintOption(lookup.toString(), lookup.getIndex());
    }

    public AutoCompleter getAutoCompleter() {
        if (this.ac != null && this.ac.hasAutocompleter(this.endCls, this.fieldName)) {
            return this.ac;
        }
        return null;
    }

    public List<Object> getPossibleValues() {
        Class type;
        String className = "";
        className = this.path.isRootPath() ? this.path.getStartClassDescriptor().getType().getCanonicalName() : this.path.getLastClassDescriptor().getType().getCanonicalName();
        if (this.templateSummary != null && !this.templateSummary.isEmpty()) {
            return this.templateSummary;
        }
        List fieldValues = this.oss.getFieldValues(className, this.fieldName);
        if (fieldValues != null && fieldValues.size() == 1 && fieldValues.get(0) == null) {
            return null;
        }
        if (this.path.endIsAttribute() && Date.class.equals((Object)(type = this.path.getEndType()))) {
            ArrayList<Object> fieldValueFormatted = new ArrayList<Object>();
            if (fieldValues != null) {
                for (Object obj : fieldValues) {
                    fieldValueFormatted.add(ConstraintValueParser.format((String)((String)obj)));
                }
            }
            return fieldValueFormatted;
        }
        return fieldValues;
    }

    public List<DisplayConstraintOption> getFixedOps() {
        if (this.fixedOps != null) {
            return this.fixedOps;
        }
        if (this.getPossibleValues() != null) {
            this.fixedOps = new ArrayList<DisplayConstraintOption>();
            for (ConstraintOp op : SimpleConstraint.fixedEnumOps((Class)this.path.getEndType())) {
                this.fixedOps.add(new DisplayConstraintOption(op.toString(), op.getIndex()));
            }
        }
        return this.fixedOps;
    }

    public boolean isExtraConstraint() {
        if (this.isLookup() && this.bagQueryConfig != null) {
            String extraValueFieldName = this.bagQueryConfig.getConnectField();
            ClassDescriptor cld = this.path.isRootPath() ? this.path.getStartClassDescriptor() : this.path.getLastClassDescriptor();
            ReferenceDescriptor fd = cld.getReferenceDescriptorByName(extraValueFieldName, true);
            return fd != null;
        }
        return false;
    }

    public boolean isShowExtraConstraint() {
        return this.showExtraConstraint;
    }

    public void setShowExtraConstraint(boolean showExtraConstraint) {
        this.showExtraConstraint = showExtraConstraint;
    }

    public String getExtraValueFieldClass() {
        if (this.isExtraConstraint()) {
            return this.bagQueryConfig.getExtraConstraintClassName();
        }
        return null;
    }

    public String getExtraConnectFieldPath() {
        if (this.isExtraConstraint()) {
            return this.path.toStringNoConstraints() + "." + this.bagQueryConfig.getConnectField();
        }
        return null;
    }

    public List<Object> getExtraConstraintValues() {
        if (this.isExtraConstraint()) {
            String extraValueFieldName = this.bagQueryConfig.getConstrainField();
            return this.oss.getFieldValues(this.bagQueryConfig.getExtraConstraintClassName(), extraValueFieldName);
        }
        return null;
    }

    public String getExtraConstraintClassName() {
        if (this.isExtraConstraint()) {
            String[] splitClassName = this.bagQueryConfig.getExtraConstraintClassName().split("[.]");
            return splitClassName[splitClassName.length - 1];
        }
        return null;
    }

    public String getKeyFields() {
        if (ClassKeyHelper.hasKeyFields(this.classKeys, (String)this.endCls)) {
            return StringUtil.prettyList((Collection)ClassKeyHelper.getKeyFieldNames(this.classKeys, (String)this.endCls), (boolean)true);
        }
        return null;
    }

    public List<String> getBags() {
        Map bags;
        if (ClassKeyHelper.hasKeyFields(this.classKeys, (String)this.endCls) && !(bags = this.bagManager.getCompatibleCurrentBags(this.profile, this.endCls)).isEmpty()) {
            ArrayList<String> bagList = new ArrayList<String>(bags.keySet());
            Collections.sort(bagList);
            return bagList;
        }
        return null;
    }

    public List<DisplayConstraintOption> getBagOps() {
        ArrayList<DisplayConstraintOption> bagOps = new ArrayList<DisplayConstraintOption>();
        for (ConstraintOp op : BagConstraint.VALID_OPS) {
            bagOps.add(new DisplayConstraintOption(op.toString(), op.getIndex()));
        }
        return bagOps;
    }

    public String getBagType() {
        if (this.getBags() != null) {
            return this.endCls;
        }
        return null;
    }

    public String getSelectedConstraint() {
        if (this.isBagSelected()) {
            return "bag";
        }
        if (this.isNullSelected()) {
            return "empty";
        }
        if (this.isLoopSelected()) {
            return "loopQuery";
        }
        if (this.isRangeSelected()) {
            return "range";
        }
        return "attribute";
    }

    public Set<String> getCandidateLoops() throws PathException {
        if (this.path.endIsAttribute()) {
            return Collections.emptySet();
        }
        if (this.con instanceof PathConstraintLoop) {
            LinkedHashSet<String> retval = new LinkedHashSet<String>();
            retval.add(((PathConstraintLoop)this.con).getLoopPath());
            retval.addAll(this.query.getCandidateLoops(this.path.getNoConstraintsString()));
            return retval;
        }
        return this.query.getCandidateLoops(this.path.getNoConstraintsString());
    }

    public boolean isValidRange() {
        return MainHelper.getValidRangeTargets().contains(this.path.getEndType());
    }

    public boolean isLocked() {
        return this.switchOffAbility == null || this.switchOffAbility == SwitchOffAbility.LOCKED;
    }

    public boolean isEnabled() {
        return this.switchOffAbility == SwitchOffAbility.ON;
    }

    public boolean isDisabled() {
        return this.switchOffAbility == SwitchOffAbility.OFF;
    }

    public String getSwitchable() {
        if (SwitchOffAbility.ON.equals((Object)this.switchOffAbility)) {
            return SwitchOffAbility.ON.toString().toLowerCase();
        }
        if (SwitchOffAbility.OFF.equals((Object)this.switchOffAbility)) {
            return SwitchOffAbility.OFF.toString().toLowerCase();
        }
        return SwitchOffAbility.LOCKED.toString().toLowerCase();
    }

    public void setSwitchOffAbility(SwitchOffAbility switchOffAbility) {
        this.switchOffAbility = switchOffAbility;
    }

    public boolean isInputFieldDisplayed() {
        if (this.con != null) {
            int selectedOperator = this.getSelectedOp().getProperty();
            if (selectedOperator == ConstraintOp.MATCHES.getIndex() || selectedOperator == ConstraintOp.DOES_NOT_MATCH.getIndex() || selectedOperator == ConstraintOp.LOOKUP.getIndex() || selectedOperator == ConstraintOp.CONTAINS.getIndex() || selectedOperator == ConstraintOp.DOES_NOT_CONTAIN.getIndex()) {
                return true;
            }
            if (selectedOperator == ConstraintOp.ONE_OF.getIndex() || selectedOperator == ConstraintOp.NONE_OF.getIndex()) {
                return this.con instanceof PathConstraintBag;
            }
            return this.getPossibleValues() == null || this.getPossibleValues().size() <= 0;
        }
        return this.getPossibleValues() == null || this.getPossibleValues().size() <= 0;
    }

    public boolean isPossibleValuesDisplayed() {
        if (this.con != null) {
            if (this.getSelectedOp() == null) {
                return false;
            }
            int selectedOperator = this.getSelectedOp().getProperty();
            if (selectedOperator == ConstraintOp.MATCHES.getIndex() || selectedOperator == ConstraintOp.DOES_NOT_MATCH.getIndex() || selectedOperator == ConstraintOp.CONTAINS.getIndex() || selectedOperator == ConstraintOp.DOES_NOT_CONTAIN.getIndex() || selectedOperator == ConstraintOp.LOOKUP.getIndex() || selectedOperator == ConstraintOp.ONE_OF.getIndex() || selectedOperator == ConstraintOp.NONE_OF.getIndex()) {
                return false;
            }
            return this.getPossibleValues() != null && this.getPossibleValues().size() > 0;
        }
        return this.getPossibleValues() != null && this.getPossibleValues().size() > 0;
    }

    public boolean isMultiValuesDisplayed() {
        if (this.con != null) {
            int selectedOperator = this.getSelectedOp().getProperty();
            return selectedOperator == ConstraintOp.ONE_OF.getIndex() || selectedOperator == ConstraintOp.NONE_OF.getIndex();
        }
        return false;
    }

    protected void setEditableInTemplate(boolean editableInTemplate) {
        this.editableInTemplate = editableInTemplate;
    }

    protected void setLabel(String label) {
        this.constraintLabel = label;
    }

    protected void setOriginalConstraint(PathConstraint con) {
        this.con = con;
    }

    protected void setCode(String code) {
        this.code = code;
    }

    protected void setTemplatesummary(List<Object> templateSummary) {
        this.templateSummary = templateSummary;
    }

    public class DisplayConstraintOption {
        private String label;
        private Integer property;

        public DisplayConstraintOption(String label, Integer property) {
            this.label = label;
            this.property = property;
        }

        public String getLabel() {
            return this.label;
        }

        public Integer getProperty() {
            return this.property;
        }
    }
}

