/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.query;

import java.util.List;
import java.util.Map;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.template.ApiTemplate;
import org.intermine.api.template.TemplateManager;
import org.intermine.api.template.TemplateSummariser;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.template.SwitchOffAbility;
import org.intermine.template.TemplateQuery;
import org.intermine.web.autocompletion.AutoCompleter;
import org.intermine.web.logic.query.DisplayConstraint;

public class DisplayConstraintFactory {
    private InterMineAPI im;
    private AutoCompleter ac;

    public DisplayConstraintFactory(InterMineAPI im, AutoCompleter ac) {
        this.im = im;
        this.ac = ac;
    }

    public DisplayConstraint get(Path path, Profile profile, PathQuery query) {
        return new DisplayConstraint(path, profile, query, this.ac, this.im.getObjectStoreSummary(), this.im.getBagQueryConfig(), (Map<String, List<FieldDescriptor>>)this.im.getClassKeys(), this.im.getBagManager());
    }

    public DisplayConstraint get(PathConstraint con, Profile profile, PathQuery query) throws PathException {
        Path path = query.makePath(con.getPath());
        DisplayConstraint dc = this.get(path, profile, query);
        String label = null;
        List templateSummary = null;
        boolean editableInTemplate = false;
        SwitchOffAbility switchOffAbility = null;
        if (query instanceof TemplateQuery) {
            TemplateQuery template = (TemplateQuery)query;
            editableInTemplate = template.isEditable(con);
            label = template.getConstraintDescription(con);
            switchOffAbility = template.getSwitchOffAbility(con);
            TemplateManager templateManager = this.im.getTemplateManager();
            ApiTemplate originalTemplate = templateManager.getUserOrGlobalTemplate(profile, template.getName());
            TemplateSummariser templateSummariser = this.im.getTemplateSummariser();
            if (templateSummariser.isSummarised(originalTemplate)) {
                templateSummary = templateSummariser.getPossibleValues(originalTemplate, con.getPath());
            }
        }
        dc.setSwitchOffAbility(switchOffAbility);
        dc.setLabel(label);
        dc.setOriginalConstraint(con);
        dc.setCode((String)query.getConstraints().get(con));
        dc.setEditableInTemplate(editableInTemplate);
        dc.setTemplatesummary(templateSummary);
        return dc;
    }
}

