/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.query;

import org.intermine.web.logic.query.DisplayConstraint;

public final class DisplayConstraintHelpMessages {
    private DisplayConstraintHelpMessages() {
    }

    public static String getHelpMessage(DisplayConstraint con) {
        StringBuffer sb = new StringBuffer();
        if (con.isLookup()) {
            sb.append("Search multiple fields including: " + con.getKeyFields() + " You can enter multiple values separated by comma, use * as a wildcard.");
            if (con.getExtraConstraintValues() != null) {
                sb.append(" You can choose to limit the " + con.getPath().getType() + " to a particular " + con.getExtraConstraintClassName() + ".");
            }
            sb.append(DisplayConstraintHelpMessages.getBagMessage(con));
        } else if (con.isNullSelected()) {
            sb.append("Select a value.");
        } else if (con.getBags() != null) {
            sb.append("Select a value.");
            sb.append(DisplayConstraintHelpMessages.getBagMessage(con));
        } else if (con.getPossibleValues() != null && !con.getPossibleValues().isEmpty()) {
            sb.append("Choose a value from the dropdown.  To choose multiple values set the operation to ONE OF or NONE OF.");
            if (con.getPath().isAttribute() && "String".equals(con.getPath().getType())) {
                sb.append(" To type text set the operation to LIKE or NOT LIKE");
                sb.append(", you can use * as a wildcard");
            }
            sb.append(".");
            sb.append(DisplayConstraintHelpMessages.getBagMessage(con));
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    private static String getBagMessage(DisplayConstraint con) {
        if (con.getBags() != null) {
            return " Or use the checkbox and constrain the " + con.getBagType() + " to be in a saved list.";
        }
        return "";
    }
}

