/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.query;

import java.util.List;
import java.util.Map;
import org.intermine.api.bag.BagManager;
import org.intermine.api.config.ClassKeyHelper;
import org.intermine.api.profile.Profile;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.pathquery.Node;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;

public class MetadataNode
extends Node {
    String button;
    boolean selected = false;
    List<String> structure;
    boolean hasSubclasses = false;
    String origType = null;
    boolean isReverseReference = false;
    PathQuery query;
    Map<String, List<FieldDescriptor>> classKeys;
    BagManager bagManager;
    Profile profile;
    private Boolean isNullNode = false;

    public MetadataNode(String type, List<String> structure, PathQuery query, Map<String, List<FieldDescriptor>> classKeys, BagManager bagManager, Profile profile) {
        super(type);
        this.button = " ";
        this.structure = structure;
        this.hasSubclasses = false;
        this.query = query;
        this.classKeys = classKeys;
        this.bagManager = bagManager;
        this.profile = profile;
    }

    public MetadataNode(MetadataNode parent, String fieldName, String button, List<String> structure, PathQuery query, Map<String, List<FieldDescriptor>> classKeys, BagManager bagManager, Profile profile, Boolean isNull) {
        super((Node)parent, fieldName, false);
        this.button = button;
        this.structure = structure;
        this.query = query;
        this.classKeys = classKeys;
        this.bagManager = bagManager;
        this.profile = profile;
        this.isNullNode = isNull;
    }

    public void setModel(Model model) {
        Node parentParent;
        super.setModel(model);
        ClassDescriptor cld = model.getClassDescriptorByName(this.getType());
        this.hasSubclasses = cld == null ? false : !cld.getSubDescriptors().isEmpty();
        Node parent = this.getParent();
        if (parent != null && (parentParent = parent.getParent()) != null) {
            ClassDescriptor ppCld = model.getClassDescriptorByName(parentParent.getType());
            FieldDescriptor pFd = ppCld.getFieldDescriptorByName(parent.getFieldName());
            if (pFd instanceof AttributeDescriptor) {
                throw new Error("Cannot have an attribute as a parent node");
            }
            ReferenceDescriptor pRd = (ReferenceDescriptor)pFd;
            String reverseFieldName = pRd.getReverseReferenceFieldName();
            if (this.getFieldName().equals(reverseFieldName)) {
                this.isReverseReference = true;
            }
        }
    }

    public void setType(String type) {
        if (this.origType == null) {
            this.origType = this.getType();
        }
        super.setType(type);
    }

    public String getButton() {
        return this.button;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public List<String> getStructure() {
        return this.structure;
    }

    public String getOrigType() {
        return this.origType;
    }

    public boolean getHasSubclasses() {
        return this.hasSubclasses;
    }

    public boolean isReverseReference() {
        return this.isReverseReference;
    }

    public boolean getHasPossibleLoops() throws PathException {
        if (this.isAttribute()) {
            return false;
        }
        return !this.query.getCandidateLoops(this.getPathString()).isEmpty();
    }

    public boolean getHasClassKeys() {
        if (this.isAttribute()) {
            return false;
        }
        return ClassKeyHelper.hasKeyFields(this.classKeys, (String)this.getType());
    }

    public boolean getHasAvailableBags() {
        if (this.isAttribute()) {
            return false;
        }
        return !this.bagManager.getBagsOfType(this.profile, this.getType()).isEmpty();
    }

    public boolean getCanCreateConstraint() throws PathException {
        return true;
    }

    public boolean getIsNull() {
        return this.isNullNode;
    }

    public String toString() {
        return super.toString() + ", structure: " + this.structure;
    }
}

