/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.querybuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.intermine.api.bag.BagManager;
import org.intermine.api.profile.Profile;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.objectstore.ObjectStoreSummary;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.config.FieldConfig;
import org.intermine.web.logic.config.FieldConfigHelper;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.query.MetadataNode;

public final class ModelBrowserHelper {
    private ModelBrowserHelper() {
    }

    public static Collection<MetadataNode> makeSelectedNodes(String stringPath, String prefix, Model model, boolean isSuperUser, PathQuery query, WebConfig webConfig, Map<String, List<FieldDescriptor>> classKeys, BagManager bagManager, Profile profile, ObjectStoreSummary oss) throws PathException {
        Collection<MetadataNode> nodes = ModelBrowserHelper.makeNodes(stringPath, model, isSuperUser, query, webConfig, classKeys, bagManager, profile, oss);
        List view = query.getView();
        for (MetadataNode node : nodes) {
            Path path;
            String fullPath;
            String pathName = node.getPathString();
            int firstDot = pathName.indexOf(46);
            if (firstDot == -1) {
                fullPath = prefix;
            } else {
                String pathNameWithoutClass = pathName.substring(firstDot + 1);
                fullPath = prefix + "." + pathNameWithoutClass;
            }
            if (view.contains(fullPath)) {
                node.setSelected(true);
                continue;
            }
            try {
                path = query.makePath(pathName);
            }
            catch (PathException e) {
                throw new Error("There must be a bug", e);
            }
            if (path.getEndFieldDescriptor() != null && !path.endIsReference() && !path.endIsCollection() || !view.contains(path)) continue;
            ClassDescriptor cld = path.getEndClassDescriptor();
            for (FieldConfig fc : FieldConfigHelper.getClassFieldConfigs(webConfig, cld)) {
                String pathFromField = pathName + "." + fc.getFieldExpr();
                if (view.contains(pathFromField)) {
                    node.setSelected(true);
                    continue;
                }
                node.setSelected(false);
            }
        }
        return nodes;
    }

    public static Collection<MetadataNode> makeNodes(String path, Model model, boolean isSuperUser, PathQuery query, WebConfig webConfig, Map<String, List<FieldDescriptor>> classKeys, BagManager bagManager, Profile profile, ObjectStoreSummary oss) throws PathException {
        NodeBuilder builder = new NodeBuilder(isSuperUser, query, classKeys, bagManager, profile, oss, webConfig);
        builder.buildTree(path);
        return builder.nodes.values();
    }

    protected static final class NodeBuilder {
        final Map<String, MetadataNode> nodes;
        final boolean isSuperUser;
        final Model model;
        final Map<String, String> subclasses;
        final PathQuery query;
        final Map<String, List<FieldDescriptor>> classKeys;
        final BagManager bagManager;
        final Profile profile;
        final ObjectStoreSummary oss;
        final WebConfig webConfig;

        protected NodeBuilder(boolean isSuperUser, PathQuery query, Map<String, List<FieldDescriptor>> classKeys, BagManager bagManager, Profile profile, ObjectStoreSummary oss, WebConfig webConfig) throws PathException {
            this.isSuperUser = isSuperUser;
            this.query = query;
            this.model = query.getModel();
            this.classKeys = classKeys;
            this.bagManager = bagManager;
            this.profile = profile;
            this.oss = oss;
            this.webConfig = webConfig;
            this.nodes = new LinkedHashMap<String, MetadataNode>();
            this.subclasses = !query.isEmpty() ? query.getSubclasses() : Collections.emptyMap();
        }

        protected void buildTree(String path) {
            String subPath;
            String className;
            if (path.indexOf(".") == -1) {
                className = path;
                subPath = "";
            } else {
                className = path.substring(0, path.indexOf("."));
                subPath = path.substring(path.indexOf(".") + 1);
            }
            List<String> empty = Collections.emptyList();
            this.nodes.put(className, new MetadataNode(className, empty, this.query, this.classKeys, this.bagManager, this.profile));
            this.makeLeaves(this.model.getClassDescriptorByName(className), subPath, className);
        }

        private void makeLeaves(ClassDescriptor cld, String subPath, String className) {
            this.makeLeaves(cld, subPath, className, new ArrayList<String>(), null);
        }

        private void makeLeaves(ClassDescriptor cld, String path, String currentPath, List<String> structure, String reverseFieldName) {
            Set nullAttrs = this.oss.getNullAttributes(cld.getName());
            Set nullRefsCols = this.oss.getNullReferencesAndCollections(cld.getName());
            List<FieldDescriptor> filteredNodes = this.makeFilteredNodes(cld, reverseFieldName);
            Iterator<FieldDescriptor> nodeIter = filteredNodes.iterator();
            while (nodeIter.hasNext()) {
                FieldDescriptor fd = nodeIter.next();
                boolean hasMore = nodeIter.hasNext();
                this.addNodeAndChildren(cld, path, currentPath, structure, nullAttrs, nullRefsCols, nodeIter, fd, hasMore);
            }
        }

        private void addNodeAndChildren(ClassDescriptor cld, String path, String currentPath, List<String> structure, Set<String> nullAttrs, Set<String> nullRefsCols, Iterator<FieldDescriptor> nodeIter, FieldDescriptor fd, boolean hasMore) {
            String tail;
            String head;
            String fieldName = fd.getName();
            if (path.indexOf(".") != -1) {
                head = path.substring(0, path.indexOf("."));
                tail = path.substring(path.indexOf(".") + 1);
            } else {
                head = path;
                tail = "";
            }
            String button = fieldName.equals(head) ? "-" : (fd.isReference() || fd.isCollection() ? "+" : " ");
            ArrayList<String> newStructure = new ArrayList<String>(structure);
            if (hasMore) {
                newStructure.add("tee");
            } else {
                newStructure.add("ell");
            }
            MetadataNode parent = this.nodes.get(currentPath);
            MetadataNode node = new MetadataNode(parent, fieldName, button, newStructure, this.query, this.classKeys, this.bagManager, this.profile, nullAttrs.contains(fieldName) || nullRefsCols.contains(fieldName));
            node.setModel(cld.getModel());
            String subclass = this.subclasses.get(node.getPathString());
            if (subclass != null) {
                node.setType(subclass);
            }
            this.nodes.put(node.getPathString(), node);
            if (fieldName.equals(head)) {
                newStructure = new ArrayList<String>(structure);
                if (nodeIter.hasNext()) {
                    newStructure.add("straight");
                } else {
                    newStructure.add("blank");
                }
                ClassDescriptor refCld = subclass == null ? ((ReferenceDescriptor)fd).getReferencedClassDescriptor() : cld.getModel().getClassDescriptorByName(subclass);
                String reverse = null;
                if (fd instanceof ReferenceDescriptor) {
                    reverse = ((ReferenceDescriptor)fd).getReverseReferenceFieldName();
                }
                this.makeLeaves(refCld, tail, currentPath + "." + head, newStructure, reverse);
            }
        }

        private List<FieldDescriptor> makeFilteredNodes(ClassDescriptor cld, String reverseFieldName) {
            ArrayList<FieldDescriptor> sortedNodes = new ArrayList<FieldDescriptor>();
            FieldNameComparator cmp = new FieldNameComparator();
            TreeSet<FieldDescriptor> attributeNodes = new TreeSet<FieldDescriptor>(cmp);
            TreeSet<FieldDescriptor> referenceAndCollectionNodes = new TreeSet<FieldDescriptor>(cmp);
            for (FieldDescriptor fd : cld.getAllFieldDescriptors()) {
                FieldConfig fc = FieldConfigHelper.getFieldConfig(this.webConfig, cld, fd);
                if (fc != null && !fc.getShowInQB()) continue;
                if (!fd.isReference() && !fd.isCollection()) {
                    attributeNodes.add(fd);
                    continue;
                }
                if (fd.getName().equals(reverseFieldName)) {
                    sortedNodes.add(fd);
                    continue;
                }
                referenceAndCollectionNodes.add(fd);
            }
            sortedNodes.addAll(attributeNodes);
            sortedNodes.addAll(referenceAndCollectionNodes);
            ArrayList<FieldDescriptor> filteredNodes = new ArrayList<FieldDescriptor>();
            for (FieldDescriptor fd : sortedNodes) {
                String fieldName = fd.getName();
                if ("id".equals(fieldName) && !this.isSuperUser) continue;
                filteredNodes.add(fd);
            }
            return filteredNodes;
        }

        private final class FieldNameComparator
        implements Comparator<FieldDescriptor> {
            private FieldNameComparator() {
            }

            @Override
            public int compare(FieldDescriptor a, FieldDescriptor b) {
                String fieldName1 = a.getName().toLowerCase();
                String fieldName2 = b.getName().toLowerCase();
                return fieldName1.compareTo(fieldName2);
            }
        }
    }
}

