/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.querybuilder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathConstraintLoop;
import org.intermine.pathquery.PathConstraintSubclass;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.template.SwitchOffAbility;
import org.intermine.template.TemplateQuery;
import org.intermine.web.logic.querybuilder.SummaryConstraint;
import org.intermine.web.logic.querybuilder.SummaryPath;

public final class QueryBuilderSummaryHelper {
    private QueryBuilderSummaryHelper() {
    }

    public static List<SummaryPath> getDisplaySummary(PathQuery query) throws PathException {
        TreeSet<SummaryPath> summaryPaths = new TreeSet<SummaryPath>();
        HashSet<String> constrainedPaths = new HashSet<String>();
        for (PathConstraint con : query.getConstraints().keySet()) {
            if (con instanceof PathConstraintSubclass) continue;
            if (con instanceof PathConstraintLoop) {
                constrainedPaths.add(con.getPath());
                constrainedPaths.add(((PathConstraintLoop)con).getLoopPath());
                continue;
            }
            constrainedPaths.add(con.getPath());
        }
        List<String> lockedPaths = QueryBuilderSummaryHelper.findLockedPaths(query);
        List<String> forcedInnerJoins = QueryBuilderSummaryHelper.findForcedInnerJoins(query);
        HashSet<String> paths = new HashSet<String>();
        paths.addAll(constrainedPaths);
        paths.addAll(query.getView());
        paths.addAll(query.getOuterJoinGroups().keySet());
        for (String stringPath : paths) {
            Path path = query.makePath(stringPath);
            boolean isLocked = lockedPaths.contains(path.toStringNoConstraints());
            boolean isForcedInner = forcedInnerJoins.contains(path.toStringNoConstraints());
            SummaryPath summaryPath = new SummaryPath(path, isLocked, isForcedInner);
            for (PathConstraint con : query.getConstraintsForPath(path.toStringNoConstraints())) {
                boolean editable = false;
                String description = null;
                String switchable = SwitchOffAbility.LOCKED.toString().toLowerCase();
                if (query instanceof TemplateQuery) {
                    TemplateQuery template = (TemplateQuery)query;
                    editable = template.getEditableConstraints().contains(con);
                    description = (String)template.getConstraintDescriptions().get(con);
                    SwitchOffAbility constraintSwitchOffAbility = (SwitchOffAbility)template.getConstraintSwitchOffAbility().get(con);
                    if (SwitchOffAbility.ON.equals((Object)constraintSwitchOffAbility)) {
                        switchable = SwitchOffAbility.ON.toString().toLowerCase();
                    } else if (SwitchOffAbility.OFF.equals((Object)constraintSwitchOffAbility)) {
                        switchable = SwitchOffAbility.OFF.toString().toLowerCase();
                    }
                }
                if (!(con instanceof PathConstraintSubclass)) {
                    String code = (String)query.getConstraints().get(con);
                    summaryPath.addSummaryConstraint(new SummaryConstraint(con, code, editable, description, switchable));
                    continue;
                }
                summaryPath.setSubclass(((PathConstraintSubclass)con).getType());
            }
            summaryPaths.add(summaryPath);
        }
        return new ArrayList<SummaryPath>(summaryPaths);
    }

    protected static List<String> findLockedPaths(PathQuery pathQuery) throws PathException {
        ArrayList<String> paths = new ArrayList<String>();
        for (PathConstraint con : pathQuery.getConstraints().keySet()) {
            if (!(con instanceof PathConstraintLoop)) continue;
            List<String> constraintPaths = QueryBuilderSummaryHelper.findParentPaths(con.getPath(), pathQuery);
            List<String> loopPaths = QueryBuilderSummaryHelper.findParentPaths(((PathConstraintLoop)con).getLoopPath(), pathQuery);
            loopPaths.removeAll(constraintPaths);
            paths.addAll(loopPaths);
        }
        return paths;
    }

    protected static List<String> findParentPaths(String pathString, PathQuery pathQuery) throws PathException {
        Path path = pathQuery.makePath(pathString);
        ArrayList<String> retval = new ArrayList<String>();
        retval.add(path.getNoConstraintsString());
        while (!path.isRootPath()) {
            path = path.getPrefix();
            retval.add(path.getNoConstraintsString());
        }
        return retval;
    }

    protected static List<String> findForcedInnerJoins(PathQuery pathQuery) throws PathException {
        ArrayList<String> paths = new ArrayList<String>();
        for (PathConstraint con : pathQuery.getConstraints().keySet()) {
            if (!(con instanceof PathConstraintLoop)) continue;
            List<String> constraintPaths = QueryBuilderSummaryHelper.findParentPaths(con.getPath(), pathQuery);
            List<String> loopPaths = QueryBuilderSummaryHelper.findParentPaths(((PathConstraintLoop)con).getLoopPath(), pathQuery);
            ArrayList<String> intersection = new ArrayList<String>(loopPaths);
            intersection.retainAll(constraintPaths);
            loopPaths.addAll(constraintPaths);
            loopPaths.removeAll(intersection);
            paths.addAll(loopPaths);
        }
        return paths;
    }
}

