/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.querybuilder;

import java.util.ArrayList;
import java.util.List;
import org.intermine.pathquery.Path;
import org.intermine.web.logic.querybuilder.DisplayPath;
import org.intermine.web.logic.querybuilder.SummaryConstraint;

public class SummaryPath
extends DisplayPath
implements Comparable<SummaryPath> {
    private List<SummaryConstraint> constraints = new ArrayList<SummaryConstraint>();
    private boolean isLocked = false;
    private boolean isForcedInnerJoin = false;
    private String subclass = null;

    public SummaryPath(Path path, boolean isLocked, boolean isForcedInner) {
        super(path);
        this.isLocked = isLocked;
        this.isForcedInnerJoin = isForcedInner;
    }

    protected void addSummaryConstraint(SummaryConstraint con) {
        this.constraints.add(con);
    }

    public List<SummaryConstraint> getConstraints() {
        return this.constraints;
    }

    public String getSubclass() {
        return this.subclass;
    }

    public void setSubclass(String subclass) {
        this.subclass = subclass;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public boolean isForcedInnerJoin() {
        return this.isForcedInnerJoin;
    }

    @Override
    public int compareTo(SummaryPath other) {
        String thisPath = this.replaceAttributeDots(this.path);
        String otherPath = this.replaceAttributeDots(other.path);
        return thisPath.compareToIgnoreCase(otherPath);
    }

    private String replaceAttributeDots(Path p) {
        String strPath = p.toStringNoConstraints();
        if (p.endIsAttribute()) {
            int lastIndex = strPath.lastIndexOf(46);
            strPath = strPath.substring(0, lastIndex) + "+" + strPath.substring(lastIndex + 1);
        }
        return strPath;
    }
}

