/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.results;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.proxy.LazyCollection;
import org.intermine.objectstore.query.Results;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.results.InlineResultsTable;

public class DisplayField {
    FieldDescriptor fd;
    int size = -1;
    InlineResultsTable table = null;
    Collection<?> collection = null;
    WebConfig webConfig = null;
    protected static final Logger LOG = Logger.getLogger(DisplayField.class);
    private final Map<String, List<FieldDescriptor>> classKeys;
    private List<Class<?>> listOfTypes = null;
    private Properties webProperties;
    private String parentClass = null;

    public DisplayField(Collection<?> collection, FieldDescriptor fd, WebConfig webConfig, Properties webProperties, Map<String, List<FieldDescriptor>> classKeys, List<Class<?>> listOfTypes) throws Exception {
        this.listOfTypes = listOfTypes;
        this.collection = collection;
        this.fd = fd;
        this.webConfig = webConfig;
        this.webProperties = webProperties;
        this.classKeys = classKeys;
    }

    public DisplayField(Collection<?> collection, FieldDescriptor fd, WebConfig webConfig, Properties webProperties, Map<String, List<FieldDescriptor>> classKeys, List<Class<?>> listOfTypes, String objectType) throws Exception {
        this(collection, fd, webConfig, webProperties, classKeys, listOfTypes);
        this.parentClass = objectType;
    }

    public InlineResultsTable getTable() {
        if (this.table == null && this.collection.size() > 0) {
            Integer tableSize = 1;
            if (this.webProperties != null) {
                String maxInlineTableSizeString = (String)this.webProperties.get("inline.table.size");
                try {
                    tableSize = Integer.parseInt(maxInlineTableSizeString);
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Failed to parse inline.table.size property: " + maxInlineTableSizeString));
                }
            }
            try {
                if (this.collection instanceof Results) {
                    ((Results)this.collection).get(tableSize.intValue());
                } else if (this.collection.size() < tableSize) {
                    tableSize = this.collection.size();
                }
            }
            catch (IndexOutOfBoundsException e) {
                tableSize = this.collection.size();
            }
            this.table = new InlineResultsTable(this.collection, this.fd.getClassDescriptor().getModel(), this.webConfig, this.classKeys, tableSize, false, this.listOfTypes, this.parentClass, this.fd);
        }
        return this.table;
    }

    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    public int getSize() {
        if (this.size == -1) {
            if (this.collection instanceof LazyCollection) {
                try {
                    LazyCollection lazyCollection = (LazyCollection)this.collection;
                    try {
                        lazyCollection.iterator().next();
                        this.size = lazyCollection.getInfo().getRows();
                    }
                    catch (IndexOutOfBoundsException err) {
                        this.size = 0;
                    }
                    catch (NoSuchElementException err) {
                        this.size = 0;
                    }
                }
                catch (ObjectStoreException e) {
                    throw new RuntimeException("unable to find the size of a collection", e);
                }
            } else {
                this.size = this.collection.size();
            }
        }
        return this.size;
    }
}

