/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.results;

import java.util.HashSet;
import java.util.Set;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.model.InterMineObject;
import org.intermine.web.logic.config.InlineListObject;

public class InlineList {
    private Set<InlineListObject> listOfObjects = null;
    private FieldDescriptor fieldDescriptor = null;
    private Boolean showLinksToObjects = false;
    private String path = null;
    private Integer lineLength = null;

    public InlineList(Set<Object> listOfListObjects, String columnToDisplayBy, Boolean showLinksToObjects, String path, Integer lineLength) {
        this.showLinksToObjects = showLinksToObjects;
        this.path = path;
        this.lineLength = lineLength;
        this.listOfObjects = new HashSet<InlineListObject>();
        for (Object listObject : listOfListObjects) {
            if (listObject == null) continue;
            InterMineObject interMineListObject = (InterMineObject)listObject;
            Object value = null;
            Object id = null;
            try {
                value = interMineListObject.getFieldValue(columnToDisplayBy);
                id = interMineListObject.getFieldValue("id");
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            InlineListObject inlineListObject = new InlineListObject(interMineListObject, value, id);
            this.listOfObjects.add(inlineListObject);
        }
    }

    public Set<InlineListObject> getItems() {
        return this.listOfObjects;
    }

    public Integer getLength() {
        Integer length = 0;
        Set<InlineListObject> items = this.getItems();
        if (items != null) {
            for (InlineListObject ilObj : this.getItems()) {
                Object value = ilObj.getValue();
                String valueString = value.toString();
                length = length + (valueString.length() + 2);
            }
            length = length - 2;
        }
        return length;
    }

    public int getSize() {
        return this.listOfObjects.size();
    }

    public Boolean getShowLinksToObjects() {
        return this.showLinksToObjects;
    }

    public Integer getLineLength() {
        return this.lineLength != null ? this.lineLength : 0;
    }

    public String getPath() {
        return this.path;
    }

    public void setDescriptor(FieldDescriptor fd) {
        this.fieldDescriptor = fd;
    }

    public FieldDescriptor getDescriptor() {
        return this.fieldDescriptor;
    }

    public String getPrefix() {
        String[] parts = this.path.split("\\.");
        return parts[0];
    }

    public String toString() {
        return String.format("<inline-list path=%s, showLinksToObjects=%s, fieldDescriptor=%s>", this.path, this.showLinksToObjects, this.fieldDescriptor);
    }
}

