/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.results;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.intermine.api.config.ClassKeyHelper;
import org.intermine.api.util.PathUtil;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.proxy.LazyCollection;
import org.intermine.objectstore.proxy.ProxyReference;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.util.DynamicUtil;
import org.intermine.web.logic.config.FieldConfig;
import org.intermine.web.logic.config.FieldConfigHelper;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.results.InlineResultsTableRow;
import org.intermine.web.logic.results.InlineTableResultElement;

public class InlineResultsTable {
    protected Collection<?> results;
    protected List<?> resultsAsList;
    protected List<Object> rowObjects = new ArrayList<Object>();
    protected List<?> columnFullNames = null;
    protected Model model;
    protected int size = -1;
    protected WebConfig webConfig;
    private final Map<String, List<FieldDescriptor>> classKeys;
    private List<Class<?>> listOfTypes = null;
    private List<FieldConfig> listOfTableFieldConfigs = null;
    private LinkedList<Object> listOfTableRows = null;
    protected static final Logger LOG = Logger.getLogger(InlineResultsTable.class);
    private FieldDescriptor fieldDescriptor = null;

    public List<?> getResultsAsList() {
        return this.resultsAsList;
    }

    public InlineResultsTable(Collection<?> results, Model model, WebConfig webConfig, Map<String, List<FieldDescriptor>> classKeys, int size, boolean ignoreDisplayers, List<Class<?>> listOfTypes) {
        long startTime = System.currentTimeMillis();
        this.listOfTypes = listOfTypes;
        this.results = results;
        this.classKeys = classKeys;
        this.resultsAsList = results instanceof List ? (List<Object>)results : (results instanceof LazyCollection ? ((LazyCollection)results).asList() : new ArrayList(results));
        this.webConfig = webConfig;
        this.model = model;
        this.size = size;
        Iterator<?> resultsIter = this.getSize() == -1 ? this.resultsAsList.iterator() : this.resultsAsList.subList(0, this.getSize()).iterator();
        while (resultsIter.hasNext()) {
            Object o = resultsIter.next();
            if (o instanceof ProxyReference) {
                o = ((ProxyReference)o).getObject();
            }
            this.rowObjects.add(o);
        }
        long took = System.currentTimeMillis() - startTime;
        LOG.info((Object)("TIME - InlineResultsTable constructor took: " + took + "ms."));
    }

    public InlineResultsTable(Collection<?> results, Model model, WebConfig webConfig, Map<String, List<FieldDescriptor>> classKeys, int size, boolean ignoreDisplayers, List<Class<?>> listOfTypes, String parentType, FieldDescriptor fd) {
        this(results, model, webConfig, classKeys, size, ignoreDisplayers, listOfTypes);
        this.fieldDescriptor = fd;
    }

    public String getParentType() {
        return this.fieldDescriptor.getClassDescriptor().getUnqualifiedName();
    }

    public FieldDescriptor getFieldDescriptor() {
        return this.fieldDescriptor;
    }

    public List<Class<?>> getListOfTypes() {
        if (this.listOfTypes == null) {
            InterMineObject o = (InterMineObject)this.rowObjects.iterator().next();
            if (o instanceof ProxyReference) {
                o = ((ProxyReference)o).getObject();
            }
            this.listOfTypes = new ArrayList();
            this.listOfTypes.add(DynamicUtil.getSimpleClass((FastPathObject)o));
        }
        return this.listOfTypes;
    }

    public Boolean getHasMoreThanOneType() {
        return this.getListOfTypes().size() > 1;
    }

    public List<FieldConfig> getTableFieldConfigs() {
        if (this.listOfTableFieldConfigs == null) {
            this.listOfTableFieldConfigs = new ArrayList<FieldConfig>();
            for (Class<?> clazz : this.getListOfTypes()) {
                for (FieldConfig fc : this.getClassFieldConfigs(this.model.getClassDescriptorByName(clazz.getName()))) {
                    if (!fc.getShowInInlineCollection() || this.listOfTableFieldConfigs.contains(fc)) continue;
                    this.listOfTableFieldConfigs.add(fc);
                }
            }
        }
        return this.listOfTableFieldConfigs;
    }

    protected List<FieldConfig> getClassFieldConfigs(ClassDescriptor cd) {
        return FieldConfigHelper.getClassFieldConfigs(this.webConfig, cd);
    }

    private int getSize() {
        return this.size;
    }

    private Boolean isThisFieldConfigInThisObject(Class<?> clazz, FieldConfig fc) {
        return this.getClassFieldConfigs(this.model.getClassDescriptorByName(clazz.getName())).contains(fc);
    }

    protected Object returnNewTableRow() {
        return new InlineResultsTableRow();
    }

    protected void setClassNameOnTableRow(String className, Object tableRowObject) {
        InlineResultsTableRow tableRow = (InlineResultsTableRow)tableRowObject;
        tableRow.setClassName(className);
    }

    protected void addResultElementToTableRow(Object resultElement, Object tableRowObject) {
        InlineResultsTableRow tableRow = (InlineResultsTableRow)tableRowObject;
        tableRow.add(resultElement);
    }

    protected void saveObjectIdOnTableRow(Integer id, Object tableRowObject) {
    }

    public List<Object> getResultElementRows() {
        if (this.listOfTableRows == null) {
            this.listOfTableRows = new LinkedList();
            int columnsSize = this.getColumnsSize();
            for (int i = 0; i < this.rowObjects.size(); ++i) {
                Object o = this.rowObjects.get(i);
                String column = null;
                Path path = null;
                InlineTableResultElement re = null;
                String className = null;
                Boolean foundMainIdentifier = false;
                Object columnList = this.returnNewTableRow();
                for (int j = 0; j < columnsSize; ++j) {
                    try {
                        FieldConfig fc = this.getTableFieldConfigs().get(j);
                        column = fc.getFieldExpr();
                        Class clazz = DynamicUtil.getSimpleClass((FastPathObject)((FastPathObject)o));
                        if (this.isThisFieldConfigInThisObject(clazz, fc).booleanValue()) {
                            String displayer;
                            className = DynamicUtil.getSimpleClass((FastPathObject)((FastPathObject)o)).getSimpleName();
                            this.setClassNameOnTableRow(className, columnList);
                            path = new Path(this.model, className + '.' + column);
                            String endTypeName = path.getLastClassDescriptor().getName();
                            String lastFieldName = path.getEndFieldDescriptor().getName();
                            Boolean isKeyField = ClassKeyHelper.isKeyField(this.classKeys, (String)endTypeName, (String)lastFieldName);
                            FastPathObject imObj = null;
                            try {
                                imObj = (FastPathObject)PathUtil.resolvePath((Path)path.getPrefix(), (Object)o);
                            }
                            catch (PathException e) {
                                e.printStackTrace();
                            }
                            if (!foundMainIdentifier.booleanValue()) {
                                Class objectType = DynamicUtil.getSimpleClass((FastPathObject)imObj);
                                if (InterMineObject.class.isAssignableFrom(objectType)) {
                                    this.saveObjectIdOnTableRow(((InterMineObject)imObj).getId(), columnList);
                                }
                                foundMainIdentifier = true;
                            }
                            if ((displayer = fc.getDisplayer()) != null && displayer.length() > 0) {
                                re = new InlineTableResultElement(imObj, path, fc, isKeyField);
                            } else {
                                String finalPath = path.getLastClassDescriptor().getUnqualifiedName() + "." + path.getLastElement();
                                re = new InlineTableResultElement(imObj, new Path(path.getModel(), finalPath), fc, isKeyField);
                            }
                            this.addResultElementToTableRow((Object)re, columnList);
                            continue;
                        }
                        this.addResultElementToTableRow("", columnList);
                        continue;
                    }
                    catch (PathException e) {
                        LOG.error((Object)e);
                    }
                }
                this.listOfTableRows.add(columnList);
            }
        }
        return this.listOfTableRows;
    }

    public Integer getColumnsSize() {
        return this.getTableFieldConfigs().size();
    }
}

