/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.results;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.results.Column;
import org.intermine.api.results.ResultElement;
import org.intermine.api.results.WebResults;
import org.intermine.api.results.WebTable;
import org.intermine.api.results.flatouterjoins.MultiRow;
import org.intermine.api.results.flatouterjoins.MultiRowFirstValue;
import org.intermine.api.results.flatouterjoins.MultiRowValue;
import org.intermine.metadata.ConstraintOp;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.TypeUtil;
import org.intermine.metadata.Util;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.query.BagConstraint;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.PathExpressionField;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryCloner;
import org.intermine.objectstore.query.QueryCollectionPathExpression;
import org.intermine.objectstore.query.QueryCollectionReference;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryHelper;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QueryObjectPathExpression;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.objectstore.query.SingletonResults;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.results.PageOutOfRangeException;
import org.intermine.web.logic.session.SessionMethods;

@Deprecated
public class PagedTable {
    private static final int FIRST_SELECTED_FIELDS_COUNT = 25;
    private final WebTable webTable;
    private List<String> columnNames = null;
    private int startRow = 0;
    private int pageSize = 25;
    private List<Column> columns;
    private String tableid;
    private List<MultiRow<ResultsRow<MultiRowValue<ResultElement>>>> rows = null;
    private Map<Integer, String> selectionIds = new LinkedHashMap<Integer, String>();
    private int allSelected = -1;
    private String selectedClass;
    private int selectedColumn;

    public PagedTable(WebTable webTable) {
        this.webTable = webTable;
    }

    public PagedTable(WebTable webTable, int pageSize) {
        this.webTable = webTable;
        this.pageSize = pageSize;
    }

    public int getAllSelected() {
        return this.allSelected;
    }

    public List<Column> getColumns() {
        return Collections.unmodifiableList(this.getColumnsInternal());
    }

    private List<Column> getColumnsInternal() {
        if (this.columns == null) {
            this.columns = this.webTable.getColumns();
        }
        return this.columns;
    }

    public List<String> getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = new ArrayList<String>();
            Iterator<Column> iter = this.getColumns().iterator();
            while (iter.hasNext()) {
                String columnName = iter.next().getName();
                this.columnNames.add(columnName);
            }
        }
        return this.columnNames;
    }

    public int getVisibleColumnCount() {
        int count = 0;
        for (Column obj : this.getColumnsInternal()) {
            if (!obj.isVisible()) continue;
            ++count;
        }
        return count;
    }

    public void moveColumnLeft(int index) {
        if (index > 0 && index <= this.getColumnsInternal().size() - 1) {
            this.getColumnsInternal().add(index - 1, this.getColumnsInternal().remove(index));
        }
    }

    public void moveColumnRight(int index) {
        if (index >= 0 && index < this.getColumnsInternal().size() - 1) {
            this.getColumnsInternal().add(index + 1, this.getColumnsInternal().remove(index));
        }
    }

    public void swapColumns(int i1, int i2) {
        int index2 = i2;
        int index1 = i1;
        if (index2 < index1) {
            int tmp = index2;
            index2 = index1;
            index1 = tmp;
        }
        this.getColumnsInternal().add(index1, this.getColumnsInternal().remove(index2));
        this.getColumnsInternal().add(index2, this.getColumnsInternal().remove(index1 + 1));
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        this.startRow = this.startRow / pageSize * pageSize;
        this.updateRows();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getPage() {
        return this.startRow / this.pageSize;
    }

    public void setPageAndPageSize(int page, int size) {
        this.pageSize = size;
        this.startRow = size * page;
        this.updateRows();
    }

    public int getEndRow() {
        return this.startRow + this.getRows().size() - 1;
    }

    public void firstPage() {
        this.startRow = 0;
        this.updateRows();
    }

    public boolean isFirstPage() {
        return this.startRow == 0;
    }

    public void lastPage() {
        this.startRow = (this.getExactSize() - 1) / this.pageSize * this.pageSize;
        this.updateRows();
    }

    public boolean isLastPage() {
        return !this.isSizeEstimate() && this.getEndRow() == this.getEstimatedSize() - 1;
    }

    public void previousPage() {
        if (this.startRow >= this.pageSize) {
            this.startRow -= this.pageSize;
        }
        this.updateRows();
    }

    public void nextPage() {
        this.startRow += this.pageSize;
        this.updateRows();
    }

    public List<MultiRow<ResultsRow<MultiRowValue<ResultElement>>>> getRows() {
        if (this.rows == null) {
            this.updateRows();
        }
        return this.rows;
    }

    public WebTable getAllRows() {
        return this.webTable;
    }

    public int getEstimatedSize() {
        return this.webTable.getEstimatedSize();
    }

    public boolean isSizeEstimate() {
        return this.webTable.isSizeEstimate();
    }

    public int getExactSize() {
        return this.webTable.size();
    }

    public PathQuery getPathQuery() {
        return this.webTable.getPathQuery();
    }

    public void selectId(Integer objectId, int columnIndex) {
        if (this.allSelected == -1) {
            ResultElement resultElement = this.findIdInVisible(objectId);
            if (resultElement != null) {
                if (resultElement.getField() == null) {
                    this.selectionIds.put(objectId, null);
                } else {
                    this.selectionIds.put(objectId, resultElement.getField().toString());
                }
                this.setSelectedColumn(columnIndex);
                this.setSelectedClass(TypeUtil.unqualifiedName((String)this.columns.get(columnIndex).getType().getName()));
            }
        } else {
            this.selectionIds.remove(objectId);
        }
    }

    public void deSelectId(Integer objectId) {
        if (this.allSelected == -1) {
            this.selectionIds.remove(objectId);
            if (this.selectionIds.size() <= 0) {
                this.setSelectedClass(null);
                this.setSelectedColumn(-1);
            }
        } else {
            ResultElement resultElement = this.findIdInVisible(objectId);
            if (resultElement != null) {
                if (resultElement.getField() == null) {
                    this.selectionIds.put(objectId, null);
                } else {
                    this.selectionIds.put(objectId, resultElement.getField().toString());
                }
            }
            if (this.isEmptySelection()) {
                this.clearSelectIds();
            }
        }
    }

    private ResultElement findIdInVisible(Integer id) {
        for (MultiRow<ResultsRow<MultiRowValue<ResultElement>>> mr : this.getRows()) {
            for (ResultsRow rv : mr) {
                for (MultiRowValue mrv : rv) {
                    ResultElement resultElement;
                    if (!(mrv instanceof MultiRowFirstValue) || (resultElement = (ResultElement)mrv.getValue()) == null || !resultElement.getId().equals(id) || !resultElement.isKeyField()) continue;
                    return resultElement;
                }
            }
        }
        return null;
    }

    public List<String> getFirstSelectedFields(ObjectStore os, Map<String, List<FieldDescriptor>> classKeysMap) {
        LinkedHashSet<String> retList = new LinkedHashSet<String>();
        Iterator<SelectionEntry> selectedEntryIter = this.selectedEntryIterator();
        boolean seenNullField = false;
        while (selectedEntryIter.hasNext()) {
            if (retList.size() < 25) {
                SelectionEntry entry = selectedEntryIter.next();
                String fieldValue = entry.fieldValue;
                if (fieldValue == null) {
                    try {
                        Integer id = entry.id;
                        InterMineObject object = os.getObjectById(id);
                        if (object == null) {
                            throw new RuntimeException("internal error - unknown object id: " + id);
                        }
                        String classKeyFieldValue = this.findClassKeyValue(classKeysMap, object);
                        if (classKeyFieldValue == null) {
                            seenNullField = true;
                            continue;
                        }
                        retList.add(classKeyFieldValue);
                    }
                    catch (ObjectStoreException e) {
                        seenNullField = true;
                    }
                    continue;
                }
                retList.add(fieldValue);
                continue;
            }
            retList.add("...");
            return new ArrayList<String>(retList);
        }
        if (seenNullField) {
            retList.add("...");
        }
        return new ArrayList<String>(retList);
    }

    public String findClassKeyValue(Map<String, List<FieldDescriptor>> classKeysMap, InterMineObject object) {
        try {
            String objectClassName = Util.getFriendlyName(object.getClass());
            List<FieldDescriptor> classKeyFds = classKeysMap.get(objectClassName);
            for (FieldDescriptor fd : classKeyFds) {
                Object value = object.getFieldValue(fd.getName());
                if (value == null) continue;
                return value.toString();
            }
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public String[] getCurrentSelectedIdStrings() {
        return this.getCurrentSelectedIdStringsList().toArray(new String[0]);
    }

    public List<String> getCurrentSelectedIdStringsList() {
        ArrayList<String> selected = new ArrayList<String>();
        if (this.allSelected == -1) {
            if (!this.selectionIds.isEmpty()) {
                for (MultiRow<ResultsRow<MultiRowValue<ResultElement>>> mr : this.getRows()) {
                    for (ResultsRow resultsRow : mr) {
                        for (MultiRowValue multiRowValue : resultsRow) {
                            ResultElement resElt;
                            if (!(multiRowValue instanceof MultiRowFirstValue) || (resElt = (ResultElement)multiRowValue.getValue()) == null || !this.selectionIds.containsKey(resElt.getId())) continue;
                            selected.add(resElt.getId().toString());
                        }
                    }
                }
            }
        } else {
            for (MultiRow<ResultsRow<MultiRowValue<ResultElement>>> multiRow : this.getRows()) {
                for (ResultsRow resultsRow : multiRow) {
                    ResultElement resElt;
                    MultiRowValue multiRowValue = (MultiRowValue)resultsRow.get(this.allSelected);
                    if (!(multiRowValue instanceof MultiRowFirstValue) || (resElt = (ResultElement)multiRowValue.getValue()) == null || this.selectionIds.containsKey(resElt.getId())) continue;
                    selected.add(resElt.getId().toString());
                }
            }
            selected.add(this.columns.get(this.allSelected).getColumnId());
        }
        return selected;
    }

    public void clearSelectIds() {
        this.selectionIds.clear();
        this.allSelected = -1;
        this.selectedClass = null;
    }

    private Iterator<SelectionEntry> selectedEntryIterator() {
        if (this.allSelected == -1) {
            return new Iterator<SelectionEntry>(){
                Iterator<Map.Entry<Integer, String>> selectionIter;
                {
                    this.selectionIter = PagedTable.this.selectionIds.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.selectionIter.hasNext();
                }

                @Override
                public SelectionEntry next() {
                    SelectionEntry retEntry = new SelectionEntry();
                    Map.Entry<Integer, String> entry = this.selectionIter.next();
                    retEntry.id = entry.getKey();
                    retEntry.fieldValue = entry.getValue();
                    return retEntry;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<SelectionEntry>(){
            SelectionEntry nextEntry = null;
            int currentIndex = 0;
            int multiRowIndex = 0;
            {
                this.moveToNext();
            }

            private void moveToNext() {
                block5: {
                    try {
                        Integer elementId;
                        ResultElement element;
                        while (true) {
                            MultiRow multiRow;
                            if ((multiRow = PagedTable.this.getAllRows().getResultElements(this.currentIndex)).size() <= this.multiRowIndex) {
                                ++this.currentIndex;
                                this.multiRowIndex = 0;
                                continue;
                            }
                            ResultsRow row = (ResultsRow)multiRow.get(this.multiRowIndex);
                            ++this.multiRowIndex;
                            MultiRowValue value = (MultiRowValue)row.get(PagedTable.this.allSelected);
                            if (!(value instanceof MultiRowFirstValue) || (element = (ResultElement)value.getValue()) == null) continue;
                            elementId = element.getId();
                            if (!PagedTable.this.selectionIds.containsKey(elementId)) break;
                        }
                        this.nextEntry = new SelectionEntry();
                        this.nextEntry.id = elementId;
                        if (element.getField() == null) {
                            this.nextEntry.fieldValue = null;
                            break block5;
                        }
                        this.nextEntry.fieldValue = element.getField().toString();
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.nextEntry = null;
                    }
                }
            }

            @Override
            public boolean hasNext() {
                return this.nextEntry != null;
            }

            @Override
            public SelectionEntry next() {
                SelectionEntry retVal = this.nextEntry;
                this.moveToNext();
                return retVal;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<Integer> selectedIdsIterator() {
        return new Iterator<Integer>(){
            Iterator<SelectionEntry> selectedEntryIter;
            {
                this.selectedEntryIter = PagedTable.this.selectedEntryIterator();
            }

            @Override
            public boolean hasNext() {
                return this.selectedEntryIter.hasNext();
            }

            @Override
            public Integer next() {
                return this.selectedEntryIter.next().id;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int getAllSelectedColumn() {
        if (this.selectionIds.isEmpty()) {
            return this.allSelected;
        }
        return -1;
    }

    public void setAllSelectedColumn(int columnSelected) {
        if (columnSelected == -1) {
            this.selectedClass = null;
        } else {
            Class columnClass = ((Column)this.getAllRows().getColumns().get(columnSelected)).getType();
            this.selectedClass = TypeUtil.unqualifiedName((String)columnClass.getName());
        }
        this.allSelected = columnSelected;
    }

    public int getSelectedColumn() {
        return this.selectedColumn;
    }

    public void setSelectedColumn(int selectedColumn) {
        this.selectedColumn = selectedColumn;
    }

    public String getSelectedClass() {
        return this.selectedClass;
    }

    public void setSelectedClass(String selectedClass) {
        this.selectedClass = selectedClass;
    }

    private void updateRows() {
        ArrayList<MultiRow<ResultsRow<MultiRowValue<ResultElement>>>> newRows = new ArrayList<MultiRow<ResultsRow<MultiRowValue<ResultElement>>>>();
        String invalidStartMessage = "Invalid start row of table: " + this.startRow;
        if (this.startRow < 0) {
            throw new PageOutOfRangeException(invalidStartMessage);
        }
        try {
            if (this.startRow != 0) {
                this.webTable.getResultElements(this.startRow);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new PageOutOfRangeException(invalidStartMessage);
        }
        int max = this.startRow + this.pageSize;
        for (int i = this.startRow; i < max; ++i) {
            try {
                newRows.add((MultiRow<ResultsRow<MultiRowValue<ResultElement>>>)this.webTable.getResultElements(i));
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                break;
            }
        }
        this.rows = newRows;
    }

    public int getMaxRetrievableIndex() {
        return this.webTable.getMaxRetrievableIndex();
    }

    public Class<?> getTypeForColumn(int index) {
        return ((Column)this.webTable.getColumns().get(index)).getType();
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    public WebTable getWebTable() {
        return this.webTable;
    }

    public String getTableid() {
        return this.tableid;
    }

    public void setTableid(String tableid) {
        this.tableid = tableid;
    }

    public List<Integer> getVisibleIndexes() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 0; i < this.getColumns().size(); ++i) {
            if (this.getColumns().get(i) == null || !this.getColumns().get(i).isVisible()) continue;
            ret.add(new Integer(this.getColumns().get(i).getIndex()));
        }
        return ret;
    }

    public boolean isEmptySelection() {
        if (this.allSelected == -1) {
            return this.selectionIds.isEmpty();
        }
        WebResults webResults = (WebResults)this.getAllRows();
        Results results = webResults.getInterMineResults();
        int batchSize = results.getBatchSize();
        int i = 0;
        for (MultiRow multiRow : this.getAllRows()) {
            for (ResultsRow subRow : multiRow) {
                Integer elementId;
                ResultElement element;
                MultiRowValue value = (MultiRowValue)subRow.get(this.allSelected);
                if (!(value instanceof MultiRowFirstValue) || (element = (ResultElement)value.getValue()) == null || this.selectionIds.containsKey(elementId = element.getId())) continue;
                return false;
            }
            if (++i < batchSize) continue;
            Query bagCreationQuery = this.getBagCreationQuery();
            SingletonResults bagCreationResults = results.getObjectStore().executeSingleton(bagCreationQuery, 1, true, false, true);
            try {
                bagCreationResults.get(0);
                return false;
            }
            catch (IndexOutOfBoundsException e) {
                return true;
            }
        }
        return true;
    }

    public boolean isAllRowsSelected() {
        if (this.allSelected == -1) {
            int selectedCount = this.selectionIds.size();
            if (selectedCount > 0) {
                try {
                    this.getAllRows().get(selectedCount);
                    return false;
                }
                catch (IndexOutOfBoundsException e) {
                    return true;
                }
            }
            return false;
        }
        return this.selectionIds.size() == 0;
    }

    public Query getBagCreationQuery() {
        if (this.allSelected == -1) {
            throw new IllegalArgumentException("Don't use a query, when a whole column is not selected");
        }
        WebResults webResults = (WebResults)this.getAllRows();
        Results results = webResults.getInterMineResults();
        Query oldQuery = results.getQuery();
        Query newQuery = QueryCloner.cloneQuery((Query)oldQuery);
        newQuery.clearOrderBy();
        HashSet<QuerySelectable> oldSelect = new HashSet<QuerySelectable>(oldQuery.getSelect());
        newQuery.clearSelect();
        Path summaryPath = this.columns.get(this.allSelected).getPath().getPrefix();
        QuerySelectable summarySelectable = (QuerySelectable)((WebResults)this.webTable).getPathToQueryNode().get(summaryPath.toStringNoConstraints());
        if (summarySelectable == null) {
            throw new NullPointerException("Error - path " + summaryPath.toStringNoConstraints() + " is not in map " + ((WebResults)this.webTable).getPathToQueryNode());
        }
        return this.recursiveGetBagCreationQuery(summarySelectable, newQuery, oldSelect);
    }

    private Query recursiveGetBagCreationQuery(QuerySelectable summary, Query newQuery, Set<QuerySelectable> oldSelect) {
        if (summary instanceof QueryObjectPathExpression) {
            QueryObjectPathExpression qope = (QueryObjectPathExpression)summary;
            if (oldSelect.contains(qope) || oldSelect.contains(new PathExpressionField(qope, 0))) {
                QueryClass lastQc = qope.getDefaultClass();
                newQuery.addFrom((FromElement)lastQc);
                newQuery.addToSelect((QuerySelectable)lastQc);
                QueryClass rootQc = qope.getQueryClass();
                QueryHelper.addAndConstraint((Query)newQuery, (Constraint)new ContainsConstraint((QueryReference)new QueryObjectReference(rootQc, qope.getFieldName()), ConstraintOp.CONTAINS, lastQc));
                if (qope.getConstraint() != null) {
                    QueryHelper.addAndConstraint((Query)newQuery, (Constraint)qope.getConstraint());
                }
                if (!this.selectionIds.isEmpty()) {
                    QueryHelper.addAndConstraint((Query)newQuery, (Constraint)new BagConstraint((QueryNode)new QueryField(lastQc, "id"), ConstraintOp.NOT_IN, this.selectionIds.keySet()));
                }
                newQuery.setDistinct(true);
                return newQuery;
            }
        } else if (summary instanceof QueryCollectionPathExpression) {
            QueryCollectionPathExpression qcpe = (QueryCollectionPathExpression)summary;
            if (oldSelect.contains(qcpe)) {
                QueryClass lastQc = qcpe.getDefaultClass();
                newQuery.addFrom((FromElement)lastQc);
                newQuery.addToSelect((QuerySelectable)lastQc);
                QueryClass rootQc = qcpe.getQueryClass();
                try {
                    QueryHelper.addAndConstraint((Query)newQuery, (Constraint)new ContainsConstraint((QueryReference)new QueryCollectionReference(rootQc, qcpe.getFieldName()), ConstraintOp.CONTAINS, lastQc));
                }
                catch (IllegalArgumentException e) {
                    QueryHelper.addAndConstraint((Query)newQuery, (Constraint)new ContainsConstraint((QueryReference)new QueryObjectReference(rootQc, qcpe.getFieldName()), ConstraintOp.CONTAINS, lastQc));
                }
                for (FromElement extraQc : qcpe.getFrom()) {
                    if (extraQc instanceof QueryClass) {
                        newQuery.addFrom(extraQc);
                        continue;
                    }
                    throw new IllegalArgumentException("FromElement is not a QueryClass: " + extraQc);
                }
                if (qcpe.getConstraint() != null) {
                    QueryHelper.addAndConstraint((Query)newQuery, (Constraint)qcpe.getConstraint());
                }
                newQuery.setDistinct(true);
                if (!this.selectionIds.isEmpty()) {
                    QueryHelper.addAndConstraint((Query)newQuery, (Constraint)new BagConstraint((QueryNode)new QueryField(lastQc, "id"), ConstraintOp.NOT_IN, this.selectionIds.keySet()));
                }
                return newQuery;
            }
        } else if (summary instanceof QueryClass) {
            QueryClass qc = (QueryClass)summary;
            if (oldSelect.contains(qc)) {
                newQuery.addToSelect((QuerySelectable)qc);
                newQuery.setDistinct(true);
                if (!this.selectionIds.isEmpty()) {
                    QueryHelper.addAndConstraint((Query)newQuery, (Constraint)new BagConstraint((QueryNode)new QueryField(qc, "id"), ConstraintOp.NOT_IN, this.selectionIds.keySet()));
                }
                return newQuery;
            }
        } else {
            throw new IllegalArgumentException("Error - path resolves to unknown object " + summary);
        }
        for (QuerySelectable qs : oldSelect) {
            try {
                if (qs instanceof PathExpressionField && ((PathExpressionField)qs).getFieldNumber() == 0) {
                    QueryObjectPathExpression qope = ((PathExpressionField)qs).getQope();
                    Query tempNewQuery = QueryCloner.cloneQuery((Query)newQuery);
                    QueryClass lastQc = qope.getDefaultClass();
                    tempNewQuery.addFrom((FromElement)lastQc);
                    QueryClass rootQc = qope.getQueryClass();
                    QueryHelper.addAndConstraint((Query)tempNewQuery, (Constraint)new ContainsConstraint((QueryReference)new QueryObjectReference(rootQc, qope.getFieldName()), ConstraintOp.CONTAINS, lastQc));
                    if (qope.getConstraint() != null) {
                        QueryHelper.addAndConstraint((Query)tempNewQuery, (Constraint)qope.getConstraint());
                    }
                    return this.recursiveGetBagCreationQuery(summary, tempNewQuery, new HashSet<QuerySelectable>(qope.getSelect()));
                }
                if (!(qs instanceof QueryCollectionPathExpression)) continue;
                QueryCollectionPathExpression qcpe = (QueryCollectionPathExpression)qs;
                QueryClass lastQc = qcpe.getDefaultClass();
                Query tempNewQuery = QueryCloner.cloneQuery((Query)newQuery);
                tempNewQuery.addFrom((FromElement)lastQc);
                QueryClass rootQc = qcpe.getQueryClass();
                try {
                    QueryHelper.addAndConstraint((Query)tempNewQuery, (Constraint)new ContainsConstraint((QueryReference)new QueryCollectionReference(rootQc, qcpe.getFieldName()), ConstraintOp.CONTAINS, lastQc));
                }
                catch (IllegalArgumentException e) {
                    QueryHelper.addAndConstraint((Query)tempNewQuery, (Constraint)new ContainsConstraint((QueryReference)new QueryObjectReference(rootQc, qcpe.getFieldName()), ConstraintOp.CONTAINS, lastQc));
                }
                for (FromElement extraQc : qcpe.getFrom()) {
                    if (extraQc instanceof QueryClass) {
                        tempNewQuery.addFrom(extraQc);
                        continue;
                    }
                    throw new IllegalArgumentException("FromElement is not a QueryClass: " + extraQc);
                }
                if (qcpe.getConstraint() != null) {
                    QueryHelper.addAndConstraint((Query)tempNewQuery, (Constraint)qcpe.getConstraint());
                }
                return this.recursiveGetBagCreationQuery(summary, tempNewQuery, new HashSet<QuerySelectable>(qcpe.getSelect()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        throw new IllegalArgumentException("Could not find summary in query.");
    }

    public Map<Integer, String> getSelectionIds() {
        return this.selectionIds;
    }

    public void setSelectionIds(Map<Integer, String> selectionIds) {
        this.selectionIds = selectionIds;
    }

    public void addSelectedToBag(InterMineBag bag) throws ObjectStoreException {
        if (this.allSelected == -1) {
            bag.addIdsToBag(this.selectionIds.keySet(), this.selectedClass);
        } else {
            bag.addToBagFromQuery(this.getBagCreationQuery());
        }
    }

    public int removeSelectedFromBag(InterMineBag bag, HttpSession session) throws Exception {
        int removedCount = 0;
        if (bag.size() == this.selectionIds.size()) {
            return removedCount;
        }
        Set<Integer> idsToRemove = this.getIdsToRemove(bag);
        bag.removeIdsFromBag(idsToRemove, true);
        removedCount = idsToRemove.size();
        SessionMethods.invalidateBagTable(session, bag.getName());
        return removedCount;
    }

    public Set<Integer> getIdsToRemove(InterMineBag bag) {
        HashSet<Integer> idsToRemove = new HashSet();
        if (this.allSelected == -1) {
            idsToRemove = this.selectionIds.keySet();
        } else {
            idsToRemove = new HashSet();
            for (Integer id : bag.getContentsAsIds()) {
                if (this.selectionIds.keySet().contains(id)) continue;
                idsToRemove.add(id);
            }
        }
        return idsToRemove;
    }

    private class SelectionEntry {
        Integer id;
        String fieldValue;

        private SelectionEntry() {
        }
    }
}

