/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.results;

import java.io.Writer;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.OWL;
import org.intermine.api.InterMineAPI;
import org.intermine.api.rdf.Namespaces;
import org.intermine.api.rdf.PurlConfig;
import org.intermine.api.rdf.RDFHelper;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.proxy.ProxyCollection;
import org.intermine.objectstore.proxy.ProxyReference;
import org.intermine.objectstore.query.ClobAccess;
import org.intermine.util.DynamicUtil;
import org.intermine.web.logic.PermanentURIHelper;
import org.intermine.web.uri.InterMineLUI;
import org.intermine.web.uri.InterMineLUIConverter;

public class RDFObject {
    private InterMineObject imObject;
    private boolean isValid = true;
    private String resourceURI;
    private InterMineLUIConverter urlConverter;
    private String baseUrl;
    private ClassDescriptor objectClassDescriptor;
    private Model model;
    private Set<String> nullRefsCols;

    public RDFObject(InterMineLUI lui, InterMineAPI im, HttpServletRequest request) throws Exception {
        if (lui != null) {
            this.urlConverter = new InterMineLUIConverter();
            this.imObject = this.urlConverter.getInterMineObject(lui);
            if (this.imObject == null) {
                this.isValid = false;
                return;
            }
            this.baseUrl = new PermanentURIHelper(request).getPermanentBaseURI();
            this.resourceURI = this.baseUrl.concat(lui.toString());
            String objectType = DynamicUtil.getSimpleClass((FastPathObject)this.imObject).getSimpleName();
            this.objectClassDescriptor = im.getModel().getClassDescriptorByName(objectType);
            this.nullRefsCols = im.getObjectStoreSummary().getNullReferencesAndCollections(this.objectClassDescriptor.getName());
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    private void initialise() {
        this.model = ModelFactory.createDefaultModel();
        this.setKnownPrefixes();
        Resource resource = RDFHelper.createResource((String)this.resourceURI, (ClassDescriptor)this.objectClassDescriptor, (Model)this.model);
        String externalIdentifier = PurlConfig.getExternalIdentifier((InterMineObject)this.imObject);
        if (externalIdentifier != null) {
            resource.addProperty(OWL.sameAs, (RDFNode)ResourceFactory.createProperty((String)externalIdentifier));
        }
        for (FieldDescriptor fd : this.objectClassDescriptor.getAllFieldDescriptors()) {
            if (fd.isAttribute() && !"id".equals(fd.getName())) {
                this.initialiseAttribute(resource, this.imObject, fd);
                continue;
            }
            if (fd.isReference()) {
                this.initialiseReference(resource, fd);
                continue;
            }
            if (!fd.isCollection()) continue;
            this.initialiseCollection(resource, fd);
        }
    }

    private void setKnownPrefixes() {
        Map namespaces = Namespaces.getNamespaces();
        for (String prefix : namespaces.keySet()) {
            this.model.setNsPrefix(prefix, (String)namespaces.get(prefix));
        }
    }

    private void initialiseAttribute(Resource resource, InterMineObject obj, FieldDescriptor fd) {
        Object fieldValue = null;
        try {
            fieldValue = obj.getFieldValue(fd.getName());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (fieldValue != null) {
            if (fieldValue instanceof ClobAccess) {
                ClobAccess fieldClob = (ClobAccess)fieldValue;
                fieldValue = fieldClob.toString();
            }
            AttributeDescriptor attributeDescriptor = (AttributeDescriptor)fd;
            resource.addProperty(RDFHelper.createIMProperty((FieldDescriptor)attributeDescriptor), fieldValue.toString());
        }
    }

    private void initialiseReference(Resource resource, FieldDescriptor fieldDescriptor) {
        ReferenceDescriptor ref = (ReferenceDescriptor)fieldDescriptor;
        String refName = ref.getName();
        if (!this.nullRefsCols.contains(refName)) {
            Object proxyObject = null;
            ProxyReference proxy = null;
            try {
                proxyObject = this.imObject.getFieldProxy(refName);
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            if (proxyObject instanceof ProxyReference) {
                proxy = (ProxyReference)proxyObject;
            }
            if (proxy != null) {
                InterMineObject referenceObj = proxy.getObject();
                this.addReferenceResource(referenceObj, ref, resource);
            }
        }
    }

    private void addReferenceResource(InterMineObject referenceObj, ReferenceDescriptor ref, Resource resource) {
        InterMineLUI lui = this.urlConverter.getInterMineLUI(referenceObj.getId());
        if (lui != null) {
            this.resourceURI = this.baseUrl.concat(lui.toString());
            Resource referenceObjResource = this.model.createResource(this.resourceURI);
            resource.addProperty(RDFHelper.createIMProperty((FieldDescriptor)ref), (RDFNode)referenceObjResource);
        }
    }

    private void initialiseCollection(Resource resource, FieldDescriptor fieldDescriptor) {
        String colName = fieldDescriptor.getName();
        if (!this.nullRefsCols.contains(colName)) {
            Object proxyObject = null;
            ProxyCollection proxyCollection = null;
            try {
                proxyObject = this.imObject.getFieldProxy(colName);
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            if (proxyObject instanceof ProxyCollection) {
                proxyCollection = (ProxyCollection)proxyObject;
            }
            for (InterMineObject referenceObj : proxyCollection) {
                this.addReferenceResource(referenceObj, (ReferenceDescriptor)fieldDescriptor, resource);
            }
        }
    }

    public void serializeAsRDF(Writer out) {
        if (this.model == null) {
            this.initialise();
        }
        this.model.write(out);
    }
}

