/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.intermine.metadata.ConstraintOp;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathConstraintBag;
import org.intermine.pathquery.PathConstraintLookup;
import org.intermine.pathquery.PathConstraintMultiValue;
import org.intermine.pathquery.PathConstraintNull;
import org.intermine.template.SwitchOffAbility;
import org.intermine.template.TemplateQuery;
import org.intermine.template.TemplateValue;
import org.intermine.web.logic.template.ConstraintInput;
import org.intermine.web.logic.template.TemplateResultInput;
import org.intermine.webservice.server.CodeTranslator;

public final class Templates {
    private static final String OPERATION_PARAMETER = "op";
    private static final String EXTRA_PARAMETER = "extra";
    private static final String VALUE_PARAMETER = "value";
    private static final String ID_PARAMETER = "constraint";
    private static final String CODE_PARAMETER = "code";

    private Templates() {
    }

    private static ConstraintOp getConstraintOp(String parName, String parValue) throws TemplateValueParseException {
        ConstraintOp ret = ConstraintOp.getConstraintOp((String)CodeTranslator.getCode(parValue));
        if (parValue != null && ret == null) {
            throw new TemplateValueParseException("Problem with parameter '" + parName + "': '" + parValue + "' is not a valid operator.");
        }
        return ret;
    }

    private static boolean isPresent(String value) {
        return value != null && value.length() > 0;
    }

    private static boolean isPresent(ConstraintOp op) {
        return op != null;
    }

    public static Map<String, List<ConstraintInput>> parseConstraints(HttpServletRequest request) throws TemplateValueParseException {
        HashMap<String, List<ConstraintInput>> ret = new HashMap<String, List<ConstraintInput>>();
        HashSet<String> processedIds = new HashSet<String>();
        for (int i = 1; i <= 25; ++i) {
            String idParameter = ID_PARAMETER + i;
            String id = request.getParameter(idParameter);
            processedIds.add(idParameter);
            String opParameter = OPERATION_PARAMETER + i;
            String opString = request.getParameter(opParameter);
            ConstraintOp op = Templates.getConstraintOp(opParameter, opString);
            String valueParameter = VALUE_PARAMETER + i;
            String[] values = request.getParameterValues(valueParameter);
            String value = null;
            List<String> multivalues = null;
            if (values != null) {
                value = values[0];
                multivalues = Arrays.asList(values);
            }
            String extraParameter = EXTRA_PARAMETER + i;
            String extraValue = request.getParameter(extraParameter);
            String codeParameter = CODE_PARAMETER + i;
            String code = request.getParameter(codeParameter);
            if (opString != null && opString.length() > 0 && op == null) {
                throw new TemplateValueParseException("invalid parameter: '" + opParameter + "' with value '" + opString + "': This must be valid operation code. Special characters must be encoded in request.  See help for 'url encoding'.");
            }
            if (!Templates.isPresent(op) && !Templates.isPresent(value) && !Templates.isPresent(id) && !Templates.isPresent(extraValue) && !Templates.isPresent(code) && multivalues == null) continue;
            String problemIntro = "parameters were provided for constraint " + i;
            if (!Templates.isPresent(id)) {
                throw new TemplateValueParseException(problemIntro + " but no path was provided to identify the constraint. Missing parameter: '" + idParameter + "'.");
            }
            if (!Templates.isPresent(op)) {
                throw new TemplateValueParseException(problemIntro + " but the operation was not specified. Missing parameter '" + opParameter + "'.");
            }
            if (!PathConstraintNull.VALID_OPS.contains(op) && request.getParameterValues(valueParameter) == null) {
                throw new TemplateValueParseException(problemIntro + " but no values were provided, and " + op + " requires at least one value. Missing parameter '" + valueParameter + "'.");
            }
            if (!PathConstraintMultiValue.VALID_OPS.contains(op) && multivalues != null && multivalues.size() > 1) {
                throw new TemplateValueParseException(" An operation was provided ('" + op + "')  that expected at most one value, but " + multivalues.size() + " values were provided using the parameter '" + valueParameter + "'.");
            }
            ConstraintInput load = new ConstraintInput(idParameter, id, code, op, value, multivalues, extraValue);
            if (ret.get(id) == null) {
                ret.put(id, new ArrayList());
            }
            ((List)ret.get(id)).add(load);
        }
        HashSet<String> allIdParameters = new HashSet<String>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String next = (String)e.nextElement();
            if (!next.startsWith(ID_PARAMETER)) continue;
            allIdParameters.add(next);
        }
        allIdParameters.removeAll(processedIds);
        if (allIdParameters.size() > 0) {
            throw new TemplateValueParseException("Maximum number of template parameters (25) exceeded. The extra values were :" + allIdParameters);
        }
        return ret;
    }

    public static Map<String, List<TemplateValue>> getValuesFromInput(TemplateQuery template, TemplateResultInput input) throws TemplateValueParseException {
        HashMap<String, List<TemplateValue>> values = new HashMap<String, List<TemplateValue>>();
        for (String path : template.getEditablePaths()) {
            List constraintsForPath = template.getEditableConstraints(path);
            ArrayList inputsForPath = new ArrayList();
            if (input.getConstraints().get(path) != null) {
                inputsForPath.addAll(input.getConstraints().get(path));
            }
            if (constraintsForPath.size() < inputsForPath.size()) {
                throw new TemplateValueParseException("There were more constraints specified  in the request than there are editable constraints for path " + path + ".");
            }
            if (constraintsForPath.size() == 1) {
                PathConstraint con = (PathConstraint)constraintsForPath.get(0);
                ConstraintInput conInput = null;
                if (!inputsForPath.isEmpty()) {
                    conInput = (ConstraintInput)inputsForPath.get(0);
                }
                Templates.checkAndAddValue(values, template, con, conInput, null);
                continue;
            }
            for (PathConstraint con : constraintsForPath) {
                ConstraintInput foundConInput = null;
                String code = (String)template.getConstraints().get(con);
                for (ConstraintInput conInput : inputsForPath) {
                    if (StringUtils.isBlank((String)conInput.getCode())) {
                        String err = "There are multiple editable constraintsfor path " + path + " but codes weren't set.  If there is more than one constraint on a path you need to specify the corresponding constraint codes.";
                        throw new TemplateValueParseException(err);
                    }
                    if (!conInput.getCode().equals(code)) continue;
                    if (foundConInput != null) {
                        String err = "There was more than one constraint specified with code: " + conInput.getCode() + " in the request for path: " + path + "  You should only provide one value per code.";
                        throw new TemplateValueParseException(err);
                    }
                    foundConInput = conInput;
                }
                Templates.checkAndAddValue(values, template, con, foundConInput, code);
            }
        }
        return values;
    }

    private static void checkAndAddValue(Map<String, List<TemplateValue>> values, TemplateQuery template, PathConstraint con, ConstraintInput conInput, String code) throws TemplateValueParseException {
        if (conInput != null) {
            if (template.isRequired(con)) {
                Templates.addToValuesMap(values, Templates.createTemplateValue(con, conInput, SwitchOffAbility.LOCKED));
            } else {
                Templates.addToValuesMap(values, Templates.createTemplateValue(con, conInput, SwitchOffAbility.ON));
            }
        } else if (template.isRequired(con)) {
            throw new TemplateValueParseException("There isn't a specified constraint value and operation for path " + con.getPath() + (code != null ? " and code " + code : "") + " in the request; this constraint is required.");
        }
    }

    private static void addToValuesMap(Map<String, List<TemplateValue>> valMap, TemplateValue newValue) {
        String path = newValue.getConstraint().getPath();
        List<TemplateValue> values = valMap.get(path);
        if (values == null) {
            values = new ArrayList<TemplateValue>();
            valMap.put(path, values);
        }
        values.add(newValue);
    }

    private static TemplateValue createTemplateValue(PathConstraint con, ConstraintInput input, SwitchOffAbility switchOffAbility) {
        TemplateValue value = PathConstraintBag.VALID_OPS.contains(input.getConstraintOp()) ? new TemplateValue(con, input.getConstraintOp(), input.getValue(), TemplateValue.ValueType.BAG_VALUE, switchOffAbility) : (con instanceof PathConstraintLookup ? new TemplateValue(con, input.getConstraintOp(), input.getValue(), TemplateValue.ValueType.SIMPLE_VALUE, input.getExtraValue(), switchOffAbility) : (con instanceof PathConstraintBag ? new TemplateValue(con, input.getConstraintOp(), input.getValue(), TemplateValue.ValueType.BAG_VALUE, switchOffAbility) : (PathConstraintMultiValue.VALID_OPS.contains(input.getConstraintOp()) ? new TemplateValue(con, input.getConstraintOp(), TemplateValue.ValueType.SIMPLE_VALUE, input.getMultivalues(), switchOffAbility) : (input.getValue() != null ? new TemplateValue(con, input.getConstraintOp(), input.getValue(), TemplateValue.ValueType.SIMPLE_VALUE, switchOffAbility) : new TemplateValue(con, input.getConstraintOp(), TemplateValue.ValueType.SIMPLE_VALUE, switchOffAbility)))));
        return value;
    }

    public static class TemplateValueParseException
    extends Exception {
        private static final long serialVersionUID = -6128402589193631537L;

        public TemplateValueParseException(String message) {
            super(message);
        }
    }
}

