/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.widget;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math3.distribution.HypergeometricDistribution;
import org.intermine.web.logic.widget.CorrectionCoefficient;
import org.intermine.web.logic.widget.EnrichmentInput;
import org.intermine.web.logic.widget.EnrichmentResults;
import org.intermine.web.logic.widget.ErrorCorrection;
import org.intermine.web.logic.widget.PopulationInfo;

public final class EnrichmentCalculation {
    private static final String UNKNOWN_STRATEGY = "Unknown error correction strategy: ";

    private EnrichmentCalculation() {
    }

    public static EnrichmentResults calculate(EnrichmentInput input, Double maxValue, String errorCorrection, boolean extraCorrectionCoefficient, CorrectionCoefficient correctionCoefficient) {
        int sampleSize = input.getSampleSize();
        PopulationInfo population = input.getPopulationInfo();
        int populationSize = population.getSize();
        Map<String, Integer> sampleCounts = input.getAnnotatedCountsInSample();
        Map<String, PopulationInfo> annotatedPopulationInfo = input.getAnnotatedCountsInPopulation();
        Map<String, BigDecimal> rawResults = EnrichmentCalculation.getRawResults(sampleSize, populationSize, sampleCounts, annotatedPopulationInfo);
        ErrorCorrection.Strategy strategy = EnrichmentCalculation.getStrategy(errorCorrection);
        Map<String, BigDecimal> correctedResults = ErrorCorrection.adjustPValues(strategy, rawResults, maxValue, input.getTestCount());
        if (extraCorrectionCoefficient && correctionCoefficient.isApplicable()) {
            correctionCoefficient.apply(correctedResults, population, annotatedPopulationInfo, maxValue);
        }
        Map<String, BigDecimal> sortedCorrectedResults = ErrorCorrection.sortMap(correctedResults);
        int analysedTotal = rawResults.isEmpty() ? 0 : sampleSize;
        EnrichmentResults results = new EnrichmentResults(sortedCorrectedResults, input.getAnnotatedCountsInSample(), input.getLabels(), analysedTotal, annotatedPopulationInfo, populationSize);
        return results;
    }

    private static Map<String, BigDecimal> getRawResults(int sampleSize, int populationSize, Map<String, Integer> sampleCounts, Map<String, PopulationInfo> annotatedPopulationInfo) {
        HashMap<String, BigDecimal> rawResults = new HashMap<String, BigDecimal>();
        for (Map.Entry<String, Integer> entry : sampleCounts.entrySet()) {
            String attribute = entry.getKey();
            Integer sampleCount = entry.getValue();
            PopulationInfo pi = annotatedPopulationInfo.get(attribute);
            Integer populationCount = pi != null ? pi.getSize() : 0;
            HypergeometricDistribution h = new HypergeometricDistribution(populationSize, populationCount.intValue(), sampleSize);
            Double pValue = h.upperCumulativeProbability(sampleCount.intValue());
            rawResults.put(attribute, new BigDecimal(pValue));
        }
        return rawResults;
    }

    private static ErrorCorrection.Strategy getStrategy(String errorCorrection) {
        ErrorCorrection.Strategy strategy = null;
        StringUtils.defaultIfBlank((String)errorCorrection, (String)"None");
        for (ErrorCorrection.Strategy s : ErrorCorrection.Strategy.values()) {
            if (!s.getAlgorithm().equalsIgnoreCase(errorCorrection)) continue;
            strategy = s;
            break;
        }
        if (strategy == null) {
            throw new IllegalArgumentException(UNKNOWN_STRATEGY + errorCorrection);
        }
        return strategy;
    }
}

