/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.widget;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashMap;
import java.util.Map;
import org.intermine.web.logic.SortableMap;

public final class ErrorCorrection {
    protected static final BigDecimal ZERO = new BigDecimal(0);
    protected static final BigDecimal ONE = new BigDecimal(1);

    private ErrorCorrection() {
    }

    public static Map<String, BigDecimal> adjustPValues(Strategy errorCorrection, Map<String, BigDecimal> results, Double max, int testCount) {
        switch (errorCorrection) {
            case NONE: {
                return ErrorCorrection.calculate(results, max);
            }
            case BONFERRONI: {
                return ErrorCorrection.calculateBonferroni(results, testCount, max);
            }
            case BENJAMINI_HOCHBERG: {
                return ErrorCorrection.calculateBenjaminiHochberg(results, testCount, max);
            }
            case HOLM_BONFERRONI: {
                return ErrorCorrection.calculateBonferroniHolm(results, testCount, max);
            }
        }
        throw new IllegalArgumentException("Unsupported strategy: " + (Object)((Object)errorCorrection));
    }

    public static Map<String, BigDecimal> sortMap(Map<String, BigDecimal> originalMap) {
        SortableMap<String, BigDecimal> sortedMap = new SortableMap<String, BigDecimal>(originalMap);
        sortedMap.sortValues(false, true);
        return sortedMap;
    }

    private static Map<String, BigDecimal> calculate(Map<String, BigDecimal> results, Double max) {
        HashMap<String, BigDecimal> adjustedMap = new HashMap<String, BigDecimal>();
        for (String id : results.keySet()) {
            BigDecimal pvalue = results.get(id);
            if (!(pvalue.doubleValue() <= max)) continue;
            adjustedMap.put(id, pvalue);
        }
        return adjustedMap;
    }

    private static Map<String, BigDecimal> calculateBonferroni(Map<String, BigDecimal> results, int numberOfTests, Double max) {
        HashMap<String, BigDecimal> adjustedMap = new HashMap<String, BigDecimal>();
        for (Map.Entry<String, BigDecimal> entry : results.entrySet()) {
            BigDecimal p = entry.getValue();
            BigDecimal adjustedP = p.multiply(new BigDecimal(numberOfTests), MathContext.DECIMAL128);
            if (adjustedP.compareTo(ONE) >= 0) {
                adjustedP = ONE;
            }
            if (!(adjustedP.doubleValue() <= max)) continue;
            adjustedMap.put(entry.getKey(), adjustedP);
        }
        return adjustedMap;
    }

    private static Map<String, BigDecimal> calculateBenjaminiHochberg(Map<String, BigDecimal> results, int numberOfTests, Double max) {
        HashMap<String, BigDecimal> adjustedResults = new HashMap<String, BigDecimal>();
        Map<String, BigDecimal> sortedResults = ErrorCorrection.sortMap(results);
        BigDecimal lastValue = null;
        int i = 1;
        BigDecimal index = ONE;
        for (Map.Entry<String, BigDecimal> entry : sortedResults.entrySet()) {
            BigDecimal m;
            BigDecimal adjustedP;
            BigDecimal p = entry.getValue();
            if (lastValue == null || p.compareTo(lastValue) != 0) {
                index = new BigDecimal(i);
            }
            if ((adjustedP = p.multiply(m = new BigDecimal(numberOfTests).divide(index, MathContext.DECIMAL128), MathContext.DECIMAL128)).compareTo(ONE) > 0) {
                adjustedP = ONE;
            }
            if (!(adjustedP.doubleValue() <= max)) {
                return adjustedResults;
            }
            adjustedResults.put(entry.getKey(), adjustedP);
            lastValue = p;
            ++i;
        }
        return adjustedResults;
    }

    private static Map<String, BigDecimal> calculateBonferroniHolm(Map<String, BigDecimal> results, int numberOfTests, Double max) {
        HashMap<String, BigDecimal> adjustedResults = new HashMap<String, BigDecimal>();
        Map<String, BigDecimal> sortedResults = ErrorCorrection.sortMap(results);
        BigDecimal lastValue = null;
        int i = 0;
        BigDecimal rank = ZERO;
        for (Map.Entry<String, BigDecimal> entry : sortedResults.entrySet()) {
            BigDecimal adjustedP;
            BigDecimal p = entry.getValue();
            BigDecimal m = null;
            if (lastValue != null && p.compareTo(lastValue) != 0) {
                rank = new BigDecimal(i);
            }
            if (!((adjustedP = p.multiply(m = new BigDecimal(numberOfTests).subtract(rank, MathContext.DECIMAL128), MathContext.DECIMAL128)).doubleValue() <= max)) {
                return adjustedResults;
            }
            adjustedResults.put(entry.getKey(), adjustedP);
            lastValue = p;
            ++i;
        }
        return adjustedResults;
    }

    public static enum Strategy {
        BONFERRONI("Bonferroni"),
        BENJAMINI_HOCHBERG("Benjamini Hochberg"),
        HOLM_BONFERRONI("Holm-Bonferroni"),
        NONE("None");

        private final String algorithm;

        private Strategy(String name) {
            this.algorithm = name;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }
    }
}

