/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.widget;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.intermine.api.config.ClassKeyHelper;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.types.ClassKeys;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.ConstraintOp;
import org.intermine.objectstore.ObjectStore;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.widget.GraphWidgetLoader;
import org.intermine.web.logic.widget.Widget;
import org.intermine.web.logic.widget.WidgetOptions;
import org.intermine.web.logic.widget.config.GraphWidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfigUtil;

public class GraphWidget
extends Widget {
    private static final String NOT_ACCEPTABLE = "The %s chart widget only accepts lists of %s, but you provided a list of %s";
    private static final String WIDGET_TYPE_NOT_IN_MODEL = "This widget is configured incorrectly. Its type is not in the model: ";
    private static final String NOT_IN_MODEL = "This bag has a type not found in the current model: ";
    private static final Logger LOG = Logger.getLogger(GraphWidget.class);
    private GraphWidgetLoader grapgWidgetLdr = null;
    private String filter;
    private List<Integer> intermineIds = new ArrayList<Integer>();
    private String type;
    private ClassKeys classKeys;

    public GraphWidget(GraphWidgetConfig config, InterMineBag interMineBag, ObjectStore os, WidgetOptions options, String ids) {
        super(config);
        this.bag = interMineBag;
        this.os = os;
        this.ids = ids;
        this.filter = options.getFilter();
        if (this.bag != null) {
            this.validateBagType();
        } else if (ids != null) {
            this.validateIDs();
        }
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setClassKeys(ClassKeys classKeys) {
        this.classKeys = classKeys;
    }

    public void setFilter(String filter) {
        this.checkNotProcessed();
        this.filter = filter;
    }

    private void checkNotProcessed() {
        if (this.grapgWidgetLdr != null) {
            throw new IllegalStateException("This widget has already been processed.");
        }
    }

    private void checkProcessed() {
        if (this.grapgWidgetLdr == null) {
            throw new IllegalStateException("This widget has not been processed yet.");
        }
    }

    private void validateBagType() {
        String bagType = this.bag.getType();
        String accepts = this.config.getTypeClass();
        ClassDescriptor bagTypeClassDescr = this.os.getModel().getClassDescriptorByName(bagType);
        if (bagTypeClassDescr == null) {
            throw new IllegalArgumentException(NOT_IN_MODEL + bagType);
        }
        ClassDescriptor accepted = this.os.getModel().getClassDescriptorByName(accepts);
        if (accepted == null) {
            throw new IllegalStateException(WIDGET_TYPE_NOT_IN_MODEL + accepts);
        }
        if ("InterMineObject".equals(accepted.getUnqualifiedName())) {
            return;
        }
        if (bagTypeClassDescr.equals((Object)accepted)) {
            return;
        }
        if (bagTypeClassDescr.getAllSuperDescriptors().contains(accepted)) {
            return;
        }
        throw new IllegalArgumentException(String.format(NOT_ACCEPTABLE, this.config.getId(), accepts, bagType));
    }

    private void validateIDs() {
        String[] idStrings = this.ids.split(",");
        for (int i = 0; i < idStrings.length; ++i) {
            try {
                this.intermineIds.add(Integer.parseInt(idStrings[i]));
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Bad IDs for graph widget");
            }
        }
    }

    @Override
    public void process() {
        this.checkNotProcessed();
        this.grapgWidgetLdr = new GraphWidgetLoader(this.bag, this.os, (GraphWidgetConfig)this.config, this.filter, this.ids, this.type);
        if (this.grapgWidgetLdr == null || this.grapgWidgetLdr.getResults() == null) {
            LOG.warn((Object)"No data found for graph widget");
            return;
        }
        try {
            int size = this.bag != null ? this.bag.getSize() : this.intermineIds.size();
            this.notAnalysed = size - this.grapgWidgetLdr.getWidgetTotal();
        }
        catch (Exception err) {
            LOG.warn((Object)"Error rendering graph widget.", (Throwable)err);
            return;
        }
    }

    @Override
    public List<List<String>> getExportResults(String[] selected) throws Exception {
        return null;
    }

    @Override
    public boolean getHasResults() {
        this.checkProcessed();
        return this.grapgWidgetLdr != null && this.grapgWidgetLdr.getResults() != null && this.grapgWidgetLdr.getResults().size() > 0;
    }

    @Override
    public List<List<Object>> getResults() {
        this.checkProcessed();
        return this.grapgWidgetLdr.getResultTable();
    }

    @Override
    public PathQuery getPathQuery() {
        PathQuery q = this.createPathQueryView(this.os, this.config);
        if (((GraphWidgetConfig)this.config).isListPathSet()) {
            if (this.bag != null) {
                q.addConstraint((PathConstraint)Constraints.in((String)((GraphWidgetConfig)this.config).getListPath(), (String)this.bag.getName()));
            } else {
                q.addConstraint((PathConstraint)Constraints.inIds((String)((GraphWidgetConfig)this.config).getListPath(), this.intermineIds));
            }
        } else if (this.bag != null) {
            q.addConstraint((PathConstraint)Constraints.in((String)this.config.getStartClass(), (String)this.bag.getName()));
        } else {
            q.addConstraint((PathConstraint)Constraints.inIds((String)this.config.getStartClass(), this.intermineIds));
        }
        String prefix = this.config.getStartClass() + ".";
        q.addConstraint((PathConstraint)Constraints.eq((String)(prefix + ((GraphWidgetConfig)this.config).getCategoryPath()), (String)"%category"));
        if (!((GraphWidgetConfig)this.config).comparesActualToExpected() && ((GraphWidgetConfig)this.config).hasSeries()) {
            q.addConstraint((PathConstraint)Constraints.eq((String)(prefix + ((GraphWidgetConfig)this.config).getSeriesPath()), (String)"%series"));
        }
        List<PathConstraint> pathConstraints = this.config.getPathConstraints();
        for (PathConstraint pc : pathConstraints) {
            if (WidgetConfigUtil.isFilterConstraint(this.config, pc)) continue;
            if (pc.getOp().equals(ConstraintOp.EQUALS)) {
                q.addConstraint((PathConstraint)Constraints.eq((String)(prefix + pc.getPath()), (String)PathConstraint.getValue((PathConstraint)pc)));
                continue;
            }
            if (!pc.getOp().equals(ConstraintOp.NOT_EQUALS)) continue;
            q.addConstraint((PathConstraint)Constraints.neq((String)(prefix + pc.getPath()), (String)PathConstraint.getValue((PathConstraint)pc)));
        }
        return q;
    }

    public PathQuery getSimplePathQuery() {
        PathQuery q = new PathQuery(this.os.getModel());
        List keyFieldNames = this.bag != null ? this.bag.getKeyFieldNames() : ClassKeyHelper.getKeyFieldNames((Map)this.classKeys, (String)this.type);
        String prefix = !((GraphWidgetConfig)this.config).isListPathSet() ? this.config.getStartClass() + "." : ((GraphWidgetConfig)this.config).getListPath() + ".";
        for (String keyFieldName : keyFieldNames) {
            if (!keyFieldName.startsWith(prefix)) {
                keyFieldName = prefix + keyFieldName;
            }
            q.addView(keyFieldName);
        }
        if (((GraphWidgetConfig)this.config).isListPathSet()) {
            if (this.bag != null) {
                q.addConstraint((PathConstraint)Constraints.in((String)((GraphWidgetConfig)this.config).getListPath(), (String)this.bag.getName()));
            } else {
                q.addConstraint((PathConstraint)Constraints.inIds((String)((GraphWidgetConfig)this.config).getListPath(), this.intermineIds));
            }
        } else if (this.bag != null) {
            q.addConstraint((PathConstraint)Constraints.in((String)this.config.getStartClass(), (String)this.bag.getName()));
        } else {
            q.addConstraint((PathConstraint)Constraints.inIds((String)this.config.getStartClass(), this.intermineIds));
        }
        q.addConstraint((PathConstraint)Constraints.eq((String)(prefix + ((GraphWidgetConfig)this.config).getCategoryPath()), (String)"%category"));
        if (((GraphWidgetConfig)this.config).hasSeries()) {
            q.addConstraint((PathConstraint)Constraints.eq((String)(prefix + ((GraphWidgetConfig)this.config).getSeriesPath()), (String)"%series"));
        }
        return q;
    }

    public class DivNumberFormat
    extends DecimalFormat {
        private static final long serialVersionUID = 8247038065756921184L;
        private int magnitude;

        public DivNumberFormat(int magnitude) {
            this.magnitude = magnitude;
        }

        @Override
        public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
            return super.format(number * (double)this.magnitude, result, fieldPosition);
        }

        @Override
        public StringBuffer format(long number, StringBuffer result, FieldPosition fieldPosition) {
            return super.format(number * (long)this.magnitude, result, fieldPosition);
        }
    }
}

