/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.search;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.intermine.api.config.ClassKeyHelper;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.model.InterMineObject;
import org.intermine.template.TemplateQuery;
import org.intermine.web.logic.config.FieldConfig;
import org.intermine.web.logic.config.FieldConfigHelper;
import org.intermine.web.logic.config.WebConfig;

public class KeywordSearchResult {
    private static final Logger LOG = Logger.getLogger(KeywordSearchResult.class);
    final WebConfig webconfig;
    final InterMineObject object;
    final int id;
    final String type;
    final float score;
    final Map<String, TemplateQuery> templates;
    final int points;
    final HashMap<String, FieldConfig> fieldConfigs;
    final Vector<String> keyFields;
    final Vector<String> additionalFields;
    final HashMap<String, Object> fieldValues;
    String linkRedirect = null;

    public KeywordSearchResult(WebConfig webconfig, InterMineObject object, Map<String, List<FieldDescriptor>> classKeys, ClassDescriptor classDescriptor, float score, Map<String, TemplateQuery> templates, String linkRedirect) {
        List<FieldConfig> fieldConfigList = FieldConfigHelper.getClassFieldConfigs(webconfig, classDescriptor);
        this.fieldConfigs = new HashMap();
        this.keyFields = new Vector();
        this.additionalFields = new Vector();
        this.fieldValues = new HashMap();
        for (FieldConfig fieldConfig : fieldConfigList) {
            Object value;
            if (!fieldConfig.getShowInSummary()) continue;
            this.fieldConfigs.put(fieldConfig.getFieldExpr(), fieldConfig);
            if (ClassKeyHelper.isKeyField(classKeys, (String)classDescriptor.getName(), (String)fieldConfig.getFieldExpr())) {
                this.keyFields.add(fieldConfig.getFieldExpr());
            } else {
                this.additionalFields.add(fieldConfig.getFieldExpr());
            }
            if (fieldConfig.getDisplayer() != null || (value = this.getValueForField(object, fieldConfig.getFieldExpr())) == null) continue;
            this.fieldValues.put(fieldConfig.getFieldExpr(), value);
        }
        this.webconfig = webconfig;
        this.object = object;
        this.id = object.getId();
        this.type = classDescriptor.getUnqualifiedName();
        this.score = score;
        this.templates = templates;
        this.points = Math.round(Math.max(0.1f, Math.min(1.0f, this.getScore())) * 10.0f);
        this.linkRedirect = linkRedirect;
    }

    private Object getValueForField(InterMineObject object, String expression) {
        LOG.debug((Object)("Getting field " + object.getClass().getName() + " -> " + expression));
        Object value = null;
        try {
            int dot = expression.indexOf(46);
            if (dot > -1) {
                String subExpression = expression.substring(dot + 1);
                Object reference = object.getFieldValue(expression.substring(0, dot));
                LOG.debug((Object)("Reference=" + reference));
                if (reference != null) {
                    if (reference instanceof InterMineObject) {
                        value = this.getValueForField((InterMineObject)reference, subExpression);
                    } else {
                        LOG.warn((Object)("Reference is not an IMO in " + object.getClass().getName() + " -> " + expression));
                    }
                }
            } else {
                value = object.getFieldValue(expression);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Value/reference not found", (Throwable)e);
        }
        return value;
    }

    public InterMineObject getObject() {
        return this.object;
    }

    public int getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public float getScore() {
        return this.score;
    }

    public Map<String, TemplateQuery> getTemplates() {
        return this.templates;
    }

    public int getPoints() {
        return this.points;
    }

    public String getLinkRedirect() {
        return this.linkRedirect;
    }

    public HashMap<String, FieldConfig> getFieldConfigs() {
        return this.fieldConfigs;
    }

    public final Vector<String> getKeyFields() {
        return this.keyFields;
    }

    public final Vector<String> getAdditionalFields() {
        return this.additionalFields;
    }

    public HashMap<String, Object> getFieldValues() {
        return this.fieldValues;
    }
}

