/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.search;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.LinkRedirectManager;
import org.intermine.api.searchengine.KeywordSearchResultContainer;
import org.intermine.api.types.ClassKeys;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.model.InterMineObject;
import org.intermine.util.DynamicUtil;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.search.KeywordSearchResult;

public final class SearchUtils {
    private static final Logger LOG = Logger.getLogger(SearchUtils.class);

    private SearchUtils() {
    }

    public static Collection<KeywordSearchResult> parseResults(InterMineAPI im, WebConfig webconfig, Collection<KeywordSearchResultContainer> searchHits) {
        long time = System.currentTimeMillis();
        Model model = im.getModel();
        ClassKeys classKeys = im.getClassKeys();
        Vector<KeywordSearchResult> searchResultsParsed = new Vector<KeywordSearchResult>();
        LinkRedirectManager redirector = im.getLinkRedirector();
        for (KeywordSearchResultContainer keywordSearchHit : searchHits) {
            Class objectClass = DynamicUtil.getSimpleClass(keywordSearchHit.getObject().getClass());
            ClassDescriptor classDescriptor = model.getClassDescriptorByName(objectClass.getName());
            InterMineObject o = keywordSearchHit.getObject();
            String linkRedirect = null;
            if (redirector != null) {
                linkRedirect = redirector.generateLink(im, o);
            }
            KeywordSearchResult ksr = new KeywordSearchResult(webconfig, o, (Map<String, List<FieldDescriptor>>)classKeys, classDescriptor, keywordSearchHit.getScore(), null, linkRedirect);
            searchResultsParsed.add(ksr);
        }
        LOG.debug((Object)("Parsing search hits took " + (System.currentTimeMillis() - time) + " ms"));
        return searchResultsParsed;
    }
}

