/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.security;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.intermine.web.security.DecodingException;
import org.intermine.web.security.KeyDecoder;

public class Base64PublicKeyDecoder
implements KeyDecoder {
    Base64 decoder = new Base64();
    KeyFactory fact;

    public Base64PublicKeyDecoder() {
        try {
            this.fact = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("This JVM cannot create RSA keys.");
        }
    }

    @Override
    public PublicKey decode(String input) throws DecodingException {
        byte[] decoded = this.decoder.decode(input);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(decoded);
        try {
            return this.fact.generatePublic(x509KeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new DecodingException(e);
        }
    }
}

