/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.security;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class KeySigner {
    public static final String DEFAULT_ALGORITHM = "SHA256withRSA";
    private PrivateKey signingKey;
    private String issuer;
    private int days;
    private String algorithm;

    public KeySigner(PrivateKey signingKey, String dn, int days, String algorithm) {
        this.signingKey = signingKey;
        this.issuer = dn;
        this.days = days;
        this.algorithm = algorithm;
    }

    public X509Certificate generateCertificate(String subject, PublicKey key) throws SigningException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        X509V3CertificateGenerator cert = new X509V3CertificateGenerator();
        cert.setSerialNumber(BigInteger.valueOf(1L));
        cert.setSubjectDN((X509Name)new X509Principal("CN=" + subject));
        cert.setIssuerDN((X509Name)new X509Principal(this.issuer));
        cert.setPublicKey(key);
        cert.setNotBefore(new Date());
        cert.setNotAfter(new Date(System.currentTimeMillis() + 86400000L * (long)this.days));
        cert.setSignatureAlgorithm(this.algorithm);
        try {
            return cert.generate(this.signingKey, "BC");
        }
        catch (CertificateEncodingException e) {
            throw new SigningException(e);
        }
        catch (InvalidKeyException e) {
            throw new SigningException(e);
        }
        catch (IllegalStateException e) {
            throw new SigningException(e);
        }
        catch (NoSuchProviderException e) {
            throw new SigningException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SigningException("Unknown algorithm", e);
        }
        catch (SignatureException e) {
            throw new SigningException(e);
        }
    }

    public final class SigningException
    extends Exception {
        private SigningException(Throwable cause) {
            super(cause);
        }

        private SigningException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

