/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.PathQueryBinding;
import org.intermine.web.logic.WebUtil;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.InterMineAction;

public class AvailableColumnsController
extends InterMineAction {
    private static final Logger LOG = Logger.getLogger(AvailableColumnsController.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        String queryXML = (String)request.getAttribute("queryXML");
        String table = (String)request.getAttribute("table");
        PathQuery q = queryXML != null ? PathQueryBinding.unmarshalPathQuery((Reader)new StringReader(queryXML), (int)2) : SessionMethods.getResultsTable(session, table).getWebTable().getPathQuery();
        request.setAttribute("availableColumns", this.getColumnsThatCanBeAdded(q));
        return null;
    }

    private Map<String, String> getColumnsThatCanBeAdded(PathQuery query) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        List<String> availPaths = this.getPathsThatCanBeAdded(query);
        for (String availPath : availPaths) {
            ret.put(availPath, WebUtil.formatColumnName(query.getGeneratedPathDescription(availPath)));
        }
        return ret;
    }

    private List<String> getPathsThatCanBeAdded(PathQuery pathQuery) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(this.getAllLastFieldsPaths(pathQuery));
        return this.getWithoutOriginalPaths(ret, pathQuery.getView());
    }

    private List<String> getAllLastFieldsPaths(PathQuery pathQuery) {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String pathString : pathQuery.getView()) {
            try {
                paths.add(pathQuery.makePath(pathString));
            }
            catch (PathException e) {
                LOG.warn((Object)("Invalid path '" + pathString + " finding available columns for query:" + pathQuery));
            }
        }
        HashSet<String> processed = new HashSet<String>();
        ArrayList<String> ret = new ArrayList<String>();
        for (Path path : paths) {
            ClassDescriptor desc = this.getPenultimateDescriptor(path);
            String key = path.getPrefix().toStringNoConstraints();
            if (processed.contains(key)) continue;
            processed.add(key);
            ret.addAll(this.getFieldPaths(desc, path.getPrefix().toStringNoConstraints()));
        }
        return ret;
    }

    private List<String> getWithoutOriginalPaths(List<String> output, List<String> paths) {
        ArrayList<String> ret = new ArrayList<String>();
        TreeSet<String> filterOut = new TreeSet<String>();
        for (String path : paths) {
            filterOut.add(path);
        }
        for (String o : output) {
            if (filterOut.contains(o)) continue;
            ret.add(o);
        }
        return ret;
    }

    private List<String> getFieldPaths(ClassDescriptor desc, String prefix) {
        ArrayList<String> ret = new ArrayList<String>();
        Set atts = desc.getAllAttributeDescriptors();
        for (AttributeDescriptor att : atts) {
            if ("id".equals(att.getName())) continue;
            ret.add(prefix + "." + att.getName());
        }
        return ret;
    }

    private ClassDescriptor getPenultimateDescriptor(Path path) {
        return path.getPrefix().getLastClassDescriptor();
    }
}

