/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagManager;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.results.ResultElement;
import org.intermine.api.results.WebTable;
import org.intermine.api.results.flatouterjoins.MultiRow;
import org.intermine.api.results.flatouterjoins.MultiRowFirstValue;
import org.intermine.api.results.flatouterjoins.MultiRowValue;
import org.intermine.api.types.ClassKeys;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.config.FieldConfig;
import org.intermine.web.logic.config.Type;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.pathqueryresult.PathQueryResultHelper;
import org.intermine.web.logic.results.PagedTable;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.logic.widget.config.WidgetConfig;

public class BagDetailsController
extends TilesAction {
    private static final int PAGE_SIZE = 10;
    private static final Logger LOG = Logger.getLogger(BagDetailsController.class);

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        Profile profile = SessionMethods.getProfile(session);
        ObjectStore os = im.getObjectStore();
        ClassKeys classKeys = im.getClassKeys();
        BagManager bagManager = im.getBagManager();
        String bagName = request.getParameter("bagName");
        Boolean myBag = Boolean.FALSE;
        if (bagName == null) {
            bagName = request.getParameter("name");
        }
        InterMineBag imBag = null;
        String scope = request.getParameter("scope");
        if (scope == null) {
            scope = "all";
        }
        if (scope.equals("user") || scope.equals("all")) {
            imBag = bagManager.getUserBag(profile, bagName);
            if (imBag != null) {
                myBag = Boolean.TRUE;
            }
            if (profile.getInvalidBags().containsKey(bagName)) {
                request.setAttribute("bag", profile.getInvalidBags().get(bagName));
                request.setAttribute("invalid", (Object)true);
                return null;
            }
        }
        if (scope.equals("global") || scope.equals("all")) {
            if (bagManager.getGlobalBag(bagName) != null) {
                imBag = bagManager.getGlobalBag(bagName);
            } else if (imBag == null) {
                imBag = (InterMineBag)bagManager.getSharedBags(profile).get(bagName);
            }
        }
        if (imBag == null) {
            ActionMessages actionMessages = this.getErrors(request);
            actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("errors.bag.missing", (Object)bagName));
            this.saveErrors(request, actionMessages);
            request.setAttribute("bag", (Object)imBag);
            return null;
        }
        String currentState = "CURRENT";
        if (!"CURRENT".equalsIgnoreCase(imBag.getState())) {
            String msg = "List '" + bagName + "' is currently unavailable. It requires upgrading by the list owner.";
            request.setAttribute("errorMessage", (Object)msg);
            request.setAttribute("invalid", (Object)true);
            return null;
        }
        WebConfig webConfig = SessionMethods.getWebConfig(request);
        Model model = os.getModel();
        Map<String, Type> types = webConfig.getTypes();
        Type type = null;
        LinkedList<WidgetConfig> widgets = new LinkedList<WidgetConfig>();
        LinkedList<Object> subWidgets = new LinkedList();
        ClassDescriptor typeClassDescriptor = model.getClassDescriptorByName(imBag.getType());
        Set superClasses = typeClassDescriptor.getAllSuperclassNames();
        for (Object superClass : superClasses) {
            type = types.get(superClass);
            subWidgets = type.getWidgets();
            for (WidgetConfig widgetConfig : subWidgets) {
                boolean isNew = true;
                for (WidgetConfig oldW : widgets) {
                    if (!widgetConfig.equals(oldW)) continue;
                    isNew = false;
                }
                if (!isNew) continue;
                widgets.add(widgetConfig);
            }
        }
        HashMap<String, Map<String, Collection<String>>> widget2extraAttrs = new HashMap<String, Map<String, Collection<String>>>();
        for (WidgetConfig widget2 : widgets) {
            widget2extraAttrs.put(widget2.getId(), widget2.getExtraAttributes(imBag, os));
        }
        request.setAttribute("widgets", widgets);
        request.setAttribute("widget2extraAttrs", widget2extraAttrs);
        PathQuery pathQuery = PathQueryResultHelper.makePathQueryForBag(imBag, webConfig, model);
        SessionMethods.setQuery(session, pathQuery);
        PagedTable pagedResults = SessionMethods.getResultsTable(session, "bag." + imBag.getName());
        int n = imBag.getSize();
        if (pagedResults == null || pagedResults.getExactSize() != n) {
            pagedResults = SessionMethods.doQueryGetPagedTable(request, imBag);
        }
        if (request.getParameter("trackExecution") == null || "true".equals(request.getParameter("trackExecution"))) {
            im.getTrackerDelegate().trackListExecution(imBag.getType(), n, profile, session.getId());
        }
        String pageStr = request.getParameter("page");
        int page = -1;
        String highlightIdStr = request.getParameter("highlightId");
        Integer highlightId = null;
        if (highlightIdStr != null) {
            highlightId = new Integer(Integer.parseInt(highlightIdStr));
        }
        boolean gotoHighlighted = false;
        String gotoHighlightedStr = request.getParameter("gotoHighlighted");
        if (gotoHighlightedStr != null && ("t".equalsIgnoreCase(gotoHighlightedStr) || "true".equalsIgnoreCase(gotoHighlightedStr))) {
            gotoHighlighted = true;
        }
        if (highlightId != null && gotoHighlighted) {
            WebTable webTable = pagedResults.getAllRows();
            for (int i = 0; i < webTable.size(); ++i) {
                MultiRow row = webTable.getResultElements(i);
                block5: for (ResultsRow resultsRow : row) {
                    for (MultiRowValue mrv : resultsRow) {
                        Integer id;
                        ResultElement resultElement;
                        if (!(mrv instanceof MultiRowFirstValue) || (resultElement = (ResultElement)mrv.getValue()) == null || !(id = resultElement.getId()).equals(highlightId)) continue;
                        page = i / 10;
                        continue block5;
                    }
                }
            }
        }
        ArrayList<String> showInPreviewTable = new ArrayList<String>();
        for (Map.Entry<String, FieldConfig> entry : type.getFieldConfigMap().entrySet()) {
            if (!entry.getValue().getShowInListAnalysisPreviewTable().booleanValue()) continue;
            showInPreviewTable.add(type.getDisplayName() + "." + entry.getKey());
        }
        request.setAttribute("showInPreviewTable", showInPreviewTable);
        request.setAttribute("firstSelectedFields", pagedResults.getFirstSelectedFields(os, (Map<String, List<FieldDescriptor>>)classKeys));
        if (page == -1) {
            page = pageStr == null ? 0 : Integer.parseInt(pageStr);
        }
        pagedResults.setPageAndPageSize(page, 10);
        Boolean isPublic = bagManager.isPublic(imBag);
        request.setAttribute("isBagPublic", (Object)isPublic);
        request.setAttribute("addparameter", (Object)request.getParameter("addparameter"));
        request.setAttribute("myBag", (Object)myBag);
        request.setAttribute("bag", (Object)imBag);
        request.setAttribute("bagSize", (Object)new Integer(imBag.size()));
        request.setAttribute("pagedResults", (Object)pagedResults);
        request.setAttribute("highlightId", (Object)highlightIdStr);
        request.setAttribute("notUseQuery", (Object)Boolean.TRUE);
        request.setAttribute("token", (Object)profile.getDayToken());
        LOG.debug((Object)("API key: " + profile.getDayToken()));
        return null;
    }
}

