/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.tracker.util.ListBuildMode;
import org.intermine.metadata.StringUtil;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.BagUploadConfirmForm;
import org.intermine.web.struts.ForwardParameters;
import org.intermine.web.struts.InterMineAction;

public class BagUploadConfirmAction
extends InterMineAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int id;
        String idString;
        int i;
        String bagName;
        if (request.getParameter("goBack") != null) {
            return mapping.findForward("back");
        }
        HttpSession session = request.getSession();
        Profile profile = SessionMethods.getProfile(session);
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        BagUploadConfirmForm confirmForm = (BagUploadConfirmForm)form;
        String string = bagName = !"".equals(confirmForm.getNewBagName()) ? confirmForm.getNewBagName() : request.getParameter("upgradeBagName");
        if (StringUtils.isBlank((String)bagName)) {
            this.recordError(new ActionMessage("bagUploadConfirm.noName"), request);
            return mapping.findForward("error");
        }
        String idsString = confirmForm.getMatchIDs().trim();
        String[] ids = StringUtil.split((String)idsString, (String)" ");
        ArrayList<Integer> contents = new ArrayList<Integer>();
        String bagType = confirmForm.getBagType();
        for (i = 0; i < ids.length; ++i) {
            idString = ids[i];
            if (idString.length() == 0) continue;
            id = Integer.parseInt(idString);
            contents.add(new Integer(id));
        }
        for (i = 0; i < confirmForm.getSelectedObjects().length; ++i) {
            idString = confirmForm.getSelectedObjects()[i];
            id = Integer.parseInt(idString);
            contents.add(new Integer(id));
        }
        if (contents.size() == 0) {
            this.recordError(new ActionMessage("bagUploadConfirm.emptyBag"), request);
            return mapping.findForward("error");
        }
        if (request.getParameter("upgradeBagName") == null) {
            InterMineBag bag = profile.createBag(bagName, bagType, "", (Map)im.getClassKeys());
            bag.addIdsToBag(contents, bagType);
            im.getTrackerDelegate().trackListCreation(bagType, bag.getSize(), ListBuildMode.IDENTIFIERS, profile, session.getId());
            session.removeAttribute("bagQueryResult");
        } else {
            InterMineBag bagToUpgrade = (InterMineBag)profile.getSavedBags().get(bagName);
            if (bagToUpgrade == null) {
                this.recordError(new ActionMessage("bagUploadConfirm.notFound"), request);
                return mapping.findForward("error");
            }
            bagToUpgrade.upgradeOsb(contents, true);
            session.removeAttribute("bagQueryResult_" + bagName);
        }
        confirmForm.reset(mapping, request);
        ForwardParameters forwardParameters = new ForwardParameters(mapping.findForward("bagDetails"));
        forwardParameters.addParameter("bagName", bagName);
        forwardParameters.addParameter("trackExecution", "false");
        return forwardParameters.forward();
    }
}

