/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagManager;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.TagManager;
import org.intermine.api.template.TemplateManager;
import org.intermine.api.userprofile.Tag;
import org.intermine.metadata.TypeUtil;
import org.intermine.util.PropertiesUtil;
import org.intermine.web.fair.SemanticMarkupFormatter;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.InterMineAction;
import org.json.JSONObject;

public class BeginAction
extends InterMineAction {
    private static final int MAX_TEMPLATES = 8;
    private static LinkedHashMap<String, HashMap<String, Object>> bagOfTabs;
    private static final String GALAXY_KEY = "GALAXY_URL";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        ServletContext servletContext = session.getServletContext();
        Map<String, String> errorKeys = SessionMethods.getErrorOnInitialiser(servletContext);
        if (errorKeys != null && !errorKeys.isEmpty()) {
            for (String errorKey : errorKeys.keySet()) {
                this.recordError(new ActionMessage(errorKey, (Object)errorKeys.get(errorKey)), request);
            }
            return mapping.findForward("blockingError");
        }
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        Properties properties = SessionMethods.getWebProperties(servletContext);
        session.removeAttribute("NEW_TEMPLATE");
        this.rememberThisGalaxy(request, session, properties);
        List templates = null;
        Properties props = PropertiesUtil.getPropertiesStartingWith((String)"begin.tabs", (Properties)properties);
        if (props.size() != 0) {
            props = PropertiesUtil.stripStart((String)"begin.tabs", (Properties)props);
            int i = 1;
            bagOfTabs = new LinkedHashMap();
            while (props.containsKey(i + ".id")) {
                LinkedHashMap<String, Object> tab = new LinkedHashMap<String, Object>();
                String identifier = (String)props.get(i + ".id");
                tab.put("identifier", identifier);
                tab.put("description", props.containsKey(i + ".description") ? (String)props.get(i + ".description") : "");
                tab.put("description", props.containsKey(i + ".description") ? (String)props.get(i + ".description") : "");
                tab.put("name", props.containsKey(i + ".name") ? (String)props.get(i + ".name") : identifier);
                TemplateManager tm = im.getTemplateManager();
                Profile profile = SessionMethods.getProfile(session);
                templates = profile.isLoggedIn() ? tm.getPopularTemplatesByAspect("im:aspect:" + identifier, 8, profile.getUsername(), session.getId()) : tm.getPopularTemplatesByAspect("im:aspect:" + identifier, 8);
                tab.put("templates", templates);
                bagOfTabs.put(Integer.toString(i), tab);
                ++i;
            }
        }
        request.setAttribute("tabs", bagOfTabs);
        LinkedList<String> preferredBags = new LinkedList<String>();
        TagManager tagManager = im.getTagManager();
        List preferredBagTypeTags = tagManager.getTags("im:preferredBagType", null, "class", im.getProfileManager().getSuperuser());
        for (Tag tag : preferredBagTypeTags) {
            preferredBags.add(TypeUtil.unqualifiedName((String)tag.getObjectIdentifier()));
        }
        Collections.sort(preferredBags);
        request.setAttribute("preferredBags", preferredBags);
        BagManager bm = im.getBagManager();
        ArrayList<String> requiredTags = new ArrayList<String>();
        requiredTags.add("im:frontpage");
        requiredTags.add("im:public");
        request.setAttribute("frontpageBags", (Object)bm.orderBags(bm.getGlobalBagsWithTags(requiredTags)));
        if (!this.hasUserVisited(request)) {
            this.setUserVisitedCookie(response);
            request.setAttribute("isNewUser", (Object)Boolean.TRUE);
        } else {
            request.setAttribute("isNewUser", (Object)Boolean.FALSE);
        }
        this.markupHomePage(request, SessionMethods.getProfile(session));
        return mapping.findForward("begin");
    }

    private void rememberThisGalaxy(HttpServletRequest request, HttpSession session, Properties properties) {
        String galaxyUrl = request.getParameter(GALAXY_KEY);
        if ("false".equals(properties.getProperty("galaxy.display"))) {
            if (galaxyUrl != null) {
                String disabledMsg = properties.getProperty("galaxy.disabledMessage");
                SessionMethods.recordError(disabledMsg, session);
            }
        } else if (galaxyUrl != null) {
            session.setAttribute(GALAXY_KEY, (Object)galaxyUrl);
            String welcomeMsg = properties.getProperty("galaxy.welcomeMessage");
            SessionMethods.recordMessage(welcomeMsg, session);
        } else {
            String defaultGalaxy = properties.getProperty("galaxy.baseurl.default") + properties.getProperty("galaxy.url.value");
            session.setAttribute(GALAXY_KEY, (Object)defaultGalaxy);
        }
    }

    private boolean hasUserVisited(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return false;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (!"visited".equals(cookie.getName())) continue;
            return true;
        }
        return false;
    }

    private HttpServletResponse setUserVisitedCookie(HttpServletResponse response) {
        Cookie cookie = new Cookie("visited", "at-some-point");
        cookie.setMaxAge(31536000);
        response.addCookie(cookie);
        return response;
    }

    private void markupHomePage(HttpServletRequest request, Profile profile) {
        try {
            Map<String, Object> homePageMarkup = SemanticMarkupFormatter.formatInstance(request, profile);
            if (homePageMarkup != null) {
                request.setAttribute("semanticMarkup", (Object)new JSONObject(homePageMarkup).toString(2));
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

