/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ChangePasswordForm;
import org.intermine.web.struts.InterMineAction;
import org.intermine.web.struts.RequestPasswordAction;

public class ChangePasswordAction
extends InterMineAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        ProfileManager pm = im.getProfileManager();
        Profile profile = SessionMethods.getProfile(session);
        String username = profile.getUsername();
        String password = ((ChangePasswordForm)form).getNewpassword();
        String oldpassword = ((ChangePasswordForm)form).getOldpassword();
        if (!pm.hasProfile(username)) {
            this.recordError(new ActionMessage("password.usernotexist", (Object)username), request);
            return mapping.findForward("changePassword");
        }
        if (!pm.validPassword(username, oldpassword)) {
            this.recordError(new ActionMessage("password.wrongpass"), request);
            return mapping.findForward("changePassword");
        }
        pm.setPassword(username, password);
        try {
            this.recordMessage(new ActionMessage("password.changed", (Object)username), request);
        }
        catch (Exception e) {
            RequestPasswordAction.LOG.warn((Object)e);
            this.recordError(new ActionMessage("login.invalidemail"), request);
        }
        return mapping.findForward("mymine");
    }
}

