/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.TagManager;
import org.intermine.api.userprofile.Tag;
import org.intermine.metadata.TypeUtil;
import org.intermine.objectstore.ObjectStoreSummary;
import org.intermine.web.logic.session.SessionMethods;

public class ClassChooserController
extends TilesAction {
    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        ObjectStoreSummary oss = im.getObjectStoreSummary();
        ServletContext servletContext = session.getServletContext();
        Set qualifiedTypes = im.getModel().getClassNames();
        Map classDescrs = (Map)servletContext.getAttribute("classDescriptions");
        StringBuffer sb = new StringBuffer();
        TagManager tagManager = im.getTagManager();
        List preferredBagTypeTags = tagManager.getTags("im:preferredBagType", null, "class", im.getProfileManager().getSuperuser());
        ArrayList<String> typeList = new ArrayList<String>();
        ArrayList<String> preferedTypeList = new ArrayList<String>();
        for (Tag tag : preferredBagTypeTags) {
            preferedTypeList.add(TypeUtil.unqualifiedName((String)tag.getObjectIdentifier()));
        }
        for (String className : qualifiedTypes) {
            String unqualifiedName = TypeUtil.unqualifiedName((String)className);
            if (oss.getClassCount(className) <= 0 || "InterMineObject".equalsIgnoreCase(unqualifiedName)) continue;
            String helpKey = unqualifiedName;
            String helpText = (String)classDescrs.get(helpKey);
            if (helpText != null) {
                String escaped = helpText.replaceAll("'", "\\\\'");
                sb.append("'" + helpKey + "': '" + escaped + "', ");
            }
            typeList.add(unqualifiedName);
        }
        Collections.sort(preferedTypeList);
        Collections.sort(typeList);
        request.setAttribute("typeList", typeList);
        request.setAttribute("preferredTypeList", preferedTypeList);
        if (sb.length() >= 2) {
            sb.deleteCharAt(sb.length() - 2);
        }
        request.setAttribute("helpMap", (Object)sb);
        return null;
    }
}

