/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.ProfileManager;
import org.intermine.util.MailUtils;
import org.intermine.web.logic.profile.LoginHandler;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.CreateAccountForm;

public class CreateAccountAction
extends LoginHandler {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        ProfileManager pm = im.getProfileManager();
        String username = ((CreateAccountForm)form).getUsername();
        String password = ((CreateAccountForm)form).getPassword();
        pm.createNewProfile(username, password);
        Properties webProperties = SessionMethods.getWebProperties(session.getServletContext());
        try {
            MailUtils.welcome(username, webProperties);
            if (((CreateAccountForm)form).getMailinglist() && webProperties.getProperty("mail.mailing-list") != null && webProperties.getProperty("mail.mailing-list").length() > 0) {
                MailUtils.subscribe(username, webProperties);
            }
            SessionMethods.recordMessage("You have successfully created an account, and logged in.", session);
        }
        catch (Exception e) {
            SessionMethods.recordError("Failed to send confirmation email", session);
        }
        this.doLogin(request, username, password);
        if (session.getAttribute("returnTo") != null) {
            return new ActionForward(session.getAttribute("returnTo").toString());
        }
        return new ActionForward("/begin.do");
    }
}

