/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.web.logic.session.SessionMethods;

public class CreateAccountForm
extends ActionForm {
    protected String username;
    protected String password;
    protected String password2;
    protected boolean mailinglist;

    public boolean getMailinglist() {
        return this.mailinglist;
    }

    public void setMailinglist(boolean mailinglist) {
        this.mailinglist = mailinglist;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username.toLowerCase();
    }

    public String getPassword2() {
        return this.password2;
    }

    public void setPassword2(String password2) {
        this.password2 = password2;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        ActionErrors errors = new ActionErrors();
        Pattern p = Pattern.compile(".+@.+\\.[a-z]+");
        Matcher m = p.matcher(this.username);
        if (this.username == null || this.username.length() == 0) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("createAccount.emptyusername"));
        } else if (this.password == null || this.password.length() == 0) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("createAccount.emptypassword"));
        } else if (!this.password.equals(this.password2)) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("createAccount.nomatchpass"));
        } else if (im.getProfileManager().hasProfile(this.username)) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("createAccount.userexists", (Object)this.username));
        } else if (!m.matches()) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("createAccount.nonvalidemail", (Object)this.username));
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.username = null;
        this.password = null;
        this.password2 = null;
        this.mailinglist = false;
    }
}

