/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.WebResultsExecutor;
import org.intermine.api.template.ApiTemplate;
import org.intermine.api.util.NameUtil;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.template.TemplateQuery;
import org.intermine.web.logic.query.DisplayConstraint;
import org.intermine.web.logic.query.DisplayConstraintFactory;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.InterMineAction;
import org.intermine.web.struts.TemplateSettingsForm;

public class CreateTemplateAction
extends InterMineAction {
    protected static final Logger LOG = Logger.getLogger(CreateTemplateAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isNewTemplate;
        Profile superUser;
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        Profile profile = SessionMethods.getProfile(session);
        ApiTemplate template = new ApiTemplate((TemplateQuery)SessionMethods.getQuery(session));
        String prevTemplateName = (String)session.getAttribute("PREV_TEMPLATE_NAME");
        boolean seenProblem = false;
        TemplateSettingsForm tsf = (TemplateSettingsForm)form;
        ActionErrors errors = tsf.validate(mapping, request);
        this.saveErrors(request, (ActionMessages)errors);
        if (!errors.isEmpty()) {
            return mapping.findForward("query");
        }
        template.setDescription(tsf.getDescription());
        template.setName(tsf.getName());
        template.setTitle(tsf.getTitle());
        template.setComment(tsf.getComment());
        WebResultsExecutor webResultsExecutor = im.getWebResultsExecutor(profile);
        if (template.getView().size() == 0) {
            this.recordError(new ActionMessage("errors.createtemplate.nooutputs"), request);
            seenProblem = true;
        }
        if (template.getBagNames().size() != 0) {
            this.recordError(new ActionMessage("errors.createtemplate.templatewithlist"), request);
            seenProblem = true;
        }
        if (!(superUser = im.getProfileManager().getSuperuserProfile()).equals(profile) && superUser.getSavedTemplates().containsKey(template.getName())) {
            this.recordError(new ActionMessage("errors.createtemplate.existinginpublic", (Object)template.getName()), request);
            seenProblem = true;
        }
        boolean bl = isNewTemplate = session.getAttribute("NEW_TEMPLATE") != null && (Boolean)session.getAttribute("NEW_TEMPLATE") != false;
        if (profile.getSavedTemplates().containsKey(template.getName()) && (isNewTemplate || prevTemplateName != null && !prevTemplateName.equals(template.getName()))) {
            this.recordError(new ActionMessage("errors.createtemplate.existing", (Object)template.getName()), request);
            seenProblem = true;
        }
        if (StringUtils.isEmpty((String)template.getName())) {
            this.recordError(new ActionMessage("errors.required", (Object)"Template name"), request);
            seenProblem = true;
        } else if (!NameUtil.isValidName((String)template.getName())) {
            this.recordError(new ActionMessage("errors.badChars"), request);
            seenProblem = true;
        }
        if (!seenProblem) {
            try {
                if (webResultsExecutor.getQueryInfo((PathQuery)template) == null) {
                    webResultsExecutor.setQueryInfo((PathQuery)template, webResultsExecutor.explain((PathQuery)template));
                }
            }
            catch (ObjectStoreException e) {
                this.recordError(new ActionMessage("errors.query.objectstoreerror"), request, (Exception)((Object)e), LOG);
                seenProblem = true;
            }
        }
        if (template.getEditableConstraints().isEmpty()) {
            this.recordError(new ActionMessage("errors.createtemplate.noconstraints"), request);
            seenProblem = true;
        }
        if (!template.validateLookupConstraints()) {
            this.recordError(new ActionMessage("errors.createtemplate.noneditablelookup"), request);
            seenProblem = true;
        }
        if (seenProblem) {
            return mapping.findForward("query");
        }
        String key = isNewTemplate ? "templateBuilder.templateCreated" : "templateBuilder.templateUpdated";
        this.recordMessage(new ActionMessage(key, (Object)template.getName()), request);
        if (isNewTemplate) {
            profile.saveTemplate(template.getName(), template);
        } else {
            String oldTemplateName = prevTemplateName != null ? prevTemplateName : template.getName();
            profile.updateTemplate(oldTemplateName, template);
            im.getTrackerDelegate().updateTemplateName(oldTemplateName, template.getName());
        }
        session.removeAttribute("NEW_TEMPLATE");
        session.removeAttribute("PREV_TEMPLATE_NAME");
        SessionMethods.loadQuery((PathQuery)template, request.getSession(), response);
        if ("SAVE".equals(tsf.getActionType())) {
            session.setAttribute("EDITING_TEMPLATE", (Object)Boolean.TRUE);
            return mapping.findForward("query");
        }
        DisplayConstraintFactory factory = new DisplayConstraintFactory(im, null);
        DisplayConstraint displayConstraint = null;
        ArrayList<DisplayConstraint> displayConstraintList = new ArrayList<DisplayConstraint>();
        for (PathConstraint pathConstraint : template.getEditableConstraints()) {
            displayConstraint = factory.get(pathConstraint, profile, (PathQuery)template);
            displayConstraintList.add(displayConstraint);
        }
        session.setAttribute("dcl", displayConstraintList);
        return mapping.findForward("run");
    }
}

