/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.intermine.web.logic.config.TableExportConfig;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.export.http.TableHttpExporter;
import org.intermine.web.logic.results.PagedTable;
import org.intermine.web.logic.session.SessionMethods;

public class ExportController
extends TilesAction {
    private static final Logger LOG = Logger.getLogger(ExportController.class);

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        WebConfig webConfig = SessionMethods.getWebConfig(request);
        String tableName = (String)request.getAttribute("tableName");
        PagedTable pt = SessionMethods.getResultsTable(session, tableName);
        if (pt == null) {
            LOG.error((Object)("PagedTable " + request.getParameter("table") + " is null"));
            return null;
        }
        Map<String, TableExportConfig> allExporters = webConfig.getTableExportConfigs();
        HashMap usableExporters = new HashMap();
        for (String exporterId : allExporters.keySet()) {
            TableExportConfig tableExportConfig = allExporters.get(exporterId);
            TableHttpExporter tableExporter = (TableHttpExporter)Class.forName(tableExportConfig.getClassName()).newInstance();
            boolean canExport = false;
            try {
                canExport = tableExporter.canExport(pt);
            }
            catch (Exception e) {
                LOG.error((Object)("Caught an error running canExport() for: " + exporterId + ". " + e));
            }
            if (canExport) {
                HashMap<String, String> config = new HashMap<String, String>();
                config.put("id", tableExportConfig.getId());
                config.put("className", tableExportConfig.getClassName());
                usableExporters.put(exporterId, config);
                continue;
            }
            usableExporters.put(exporterId, null);
        }
        request.setAttribute("exporters", usableExporters);
        return null;
    }
}

