/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.template.ApiTemplate;
import org.intermine.api.template.TemplateManager;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.web.logic.results.ReportObject;
import org.intermine.web.logic.results.ReportObjectFactory;
import org.intermine.web.logic.session.SessionMethods;

public class HtmlHeadController
extends TilesAction {
    protected static final Logger LOG = Logger.getLogger(HtmlHeadController.class);

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        ObjectStore os = im.getObjectStore();
        ReportObjectFactory reportObjects = SessionMethods.getReportObjects(session);
        String pageName = (String)context.getAttribute("pageName");
        String bagName = (String)context.getAttribute("bagName");
        String objectId = (String)context.getAttribute("objectId");
        String name = (String)context.getAttribute("name");
        String htmlPageTitle = (String)context.getAttribute("pageNameTitle");
        String scope = (String)context.getAttribute("scope");
        if (name != null && "aspect".equals(pageName)) {
            htmlPageTitle = htmlPageTitle + ":  " + name;
        } else if ("bagDetails".equals(pageName)) {
            htmlPageTitle = bagName != null && !"".equals(bagName) ? htmlPageTitle + ":  " + bagName : htmlPageTitle + ":  " + name;
        } else if ("template".equals(pageName)) {
            String templateTitle = "";
            ApiTemplate template = null;
            Profile profile = null;
            TemplateManager templateManager = im.getTemplateManager();
            if (scope != null && scope.equals("user")) {
                profile = SessionMethods.getProfile(session);
                template = templateManager.getUserOrGlobalTemplate(profile, name);
            } else {
                template = templateManager.getGlobalTemplate(name);
            }
            if (template != null) {
                templateTitle = ":  " + template.getTitle();
            }
            htmlPageTitle = htmlPageTitle + templateTitle;
        } else if ("report".equals(pageName) && objectId != null) {
            if (!StringUtils.isNumeric((String)objectId)) {
                LOG.warn((Object)("object ID not a number! " + objectId));
                htmlPageTitle = "invalid id";
                request.setAttribute("htmlPageTitle", (Object)htmlPageTitle);
                return null;
            }
            if (StringUtils.isBlank((String)objectId)) {
                LOG.warn((Object)"object ID null! ");
                htmlPageTitle = "no id provided";
                request.setAttribute("htmlPageTitle", (Object)htmlPageTitle);
                return null;
            }
            Integer id = null;
            try {
                id = new Integer(Integer.parseInt(objectId));
                InterMineObject object = os.getObjectById(id);
                if (object == null) {
                    request.setAttribute("htmlPageTitle", (Object)htmlPageTitle);
                    return null;
                }
                ReportObject reportObject = reportObjects.get(object);
                this.markupReportPage(request, reportObject);
                htmlPageTitle = reportObject.getHtmlHeadTitle();
            }
            catch (Exception e) {
                LOG.warn((Object)("Could not correctly set the page title for object ID - " + objectId), (Throwable)e);
            }
        }
        request.setAttribute("htmlPageTitle", (Object)StringEscapeUtils.escapeHtml((String)htmlPageTitle));
        String userTrackingMessage = (String)SessionMethods.getWebProperties(request.getSession().getServletContext()).get("google.analytics.message");
        if (userTrackingMessage != null) {
            request.setAttribute("userTrackingMessage", (Object)userTrackingMessage);
            request.setAttribute("userTracking", (Object)this.canWeUserTrack(request));
        } else {
            request.setAttribute("userTracking", (Object)1);
        }
        return null;
    }

    private String canWeUserTrack(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return "2";
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (!"userTracking".equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return "2";
    }

    private void markupReportPage(HttpServletRequest request, ReportObject reportObject) {
        try {
            String semanticMarkup = reportObject.getSemanticMarkup(request);
            if (semanticMarkup != null) {
                request.setAttribute("semanticMarkup", (Object)semanticMarkup);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

