/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.intermine.api.profile.Profile;
import org.intermine.api.util.NameUtil;
import org.intermine.metadata.StringUtil;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ForwardParameters;
import org.intermine.web.struts.ImportQueriesForm;
import org.intermine.web.struts.InterMineAction;

public class ImportQueriesAction
extends InterMineAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        ImportQueriesForm qif = (ImportQueriesForm)form;
        Profile profile = SessionMethods.getProfile(session);
        Map<String, PathQuery> queries = null;
        queries = qif.getQueryMap();
        if (queries.size() == 1 && (request.getParameter("query_builder") != null && "yes".equals(request.getParameter("query_builder")) || profile.getUsername() == null)) {
            PathQuery pathQuery = queries.values().iterator().next();
            if (!pathQuery.isValid()) {
                this.recordError(new ActionMessage("errors.importFailed", (Object)StringUtil.prettyList((Collection)pathQuery.verifyQuery())), request);
            }
            try {
                SessionMethods.loadQuery(pathQuery, session, response);
            }
            catch (Exception e) {
                e.printStackTrace();
                return mapping.findForward("importQueries");
            }
            return mapping.findForward("query");
        }
        if (!profile.isLoggedIn()) {
            ActionMessages actionMessages = this.getErrors(request);
            actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("import.queries.notloggedin"));
            this.saveErrors(request, actionMessages);
            return mapping.findForward("importQueries");
        }
        try {
            profile.disableSaving();
            int imported = 0;
            boolean validNameQuery = true;
            for (String queryName : queries.keySet()) {
                PathQuery query = queries.get(queryName);
                queryName = NameUtil.validateName(profile.getSavedQueries().keySet(), (String)queryName);
                if (queryName.isEmpty()) {
                    validNameQuery = false;
                    continue;
                }
                SessionMethods.saveQuery(session, queryName, query);
                ++imported;
            }
            this.recordMessage(new ActionMessage("query.imported", (Object)new Integer(imported)), request);
            if (!validNameQuery) {
                this.recordError(new ActionMessage("query.imported.invalidname"), request);
            }
            ActionForward actionForward = new ForwardParameters(mapping.findForward("mymine")).addParameter("subtab", "saved").forward();
            return actionForward;
        }
        finally {
            profile.enableSaving();
        }
    }
}

