/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.PathQueryBinding;
import org.intermine.web.struts.ImportXMLForm;

public class ImportQueriesForm
extends ImportXMLForm {
    private Map<String, PathQuery> map;
    private String queryBuilder;

    public Map<String, PathQuery> getQueryMap() throws Exception {
        if (this.map == null) {
            this.xml = this.xml.trim();
            if (!this.xml.isEmpty()) {
                if (!this.xml.startsWith("<queries>")) {
                    this.xml = "<queries>" + this.xml + "</queries>";
                }
                this.map = PathQueryBinding.unmarshalPathQueries((Reader)new StringReader(this.xml), (int)2);
            } else if (this.formFile != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.formFile.getInputStream()));
                this.map = PathQueryBinding.unmarshalPathQueries((Reader)reader, (int)2);
            }
        }
        return this.map;
    }

    public String getQueryBuilder() {
        return this.queryBuilder;
    }

    public void setQueryBuilder(String queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    @Override
    protected void reset() {
        super.reset();
        this.queryBuilder = "";
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = super.validate(mapping, request);
        if (errors != null && errors.size() > 0) {
            return errors;
        }
        if (this.formFile != null && this.formFile.getFileName() != null && this.formFile.getFileName().length() > 0) {
            String mimetype = this.formFile.getContentType();
            if (!"application/octet-stream".equals(mimetype) && !mimetype.startsWith("text")) {
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("errors.importQuery.notText", (Object)mimetype));
                return errors;
            }
            if (this.formFile.getFileSize() == 0) {
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("errors.importQuery.noQueryFileOrEmpty"));
                return errors;
            }
        }
        try {
            if (this.getQueryMap().size() == 0) {
                if (errors == null) {
                    errors = new ActionErrors();
                }
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("errors.importQuery.noqueries"));
            }
        }
        catch (Exception err) {
            if (errors == null) {
                errors = new ActionErrors();
            }
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("errors.importFailed", (Object)err.getCause().getMessage()));
        }
        return errors;
    }
}

