/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.apache.tools.ant.BuildException;
import org.intermine.api.InterMineAPI;
import org.intermine.api.LinkRedirectManager;
import org.intermine.api.bag.BagQueryConfig;
import org.intermine.api.bag.BagQueryHelper;
import org.intermine.api.config.ClassKeyHelper;
import org.intermine.api.profile.BagState;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.profile.TagManager;
import org.intermine.api.profile.UserNotFoundException;
import org.intermine.api.query.MainHelper;
import org.intermine.api.search.GlobalRepository;
import org.intermine.api.search.SearchRepository;
import org.intermine.api.tracker.TrackerDelegate;
import org.intermine.api.types.ClassKeys;
import org.intermine.api.userprofile.Tag;
import org.intermine.api.userprofile.UserProfile;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.Model;
import org.intermine.metadata.TypeUtil;
import org.intermine.model.InterMineObject;
import org.intermine.modelproduction.MetadataManager;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.ObjectStoreFactory;
import org.intermine.objectstore.ObjectStoreSummary;
import org.intermine.objectstore.ObjectStoreWriter;
import org.intermine.objectstore.ObjectStoreWriterFactory;
import org.intermine.objectstore.intermine.ObjectStoreInterMineImpl;
import org.intermine.sql.Database;
import org.intermine.sql.DatabaseUtil;
import org.intermine.util.PropertiesUtil;
import org.intermine.util.ShutdownHook;
import org.intermine.web.autocompletion.AutoCompleter;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.aspects.Aspect;
import org.intermine.web.logic.aspects.AspectBinding;
import org.intermine.web.logic.config.FieldConfig;
import org.intermine.web.logic.config.FieldConfigHelper;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.profile.LoginHandler;
import org.intermine.web.logic.profile.UpgradeBagList;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ResourceFinder;
import org.intermine.webservice.server.query.result.XMLValidator;

public class InitialiserPlugin
implements PlugIn {
    private static final Logger LOG = Logger.getLogger(InitialiserPlugin.class);
    ProfileManager profileManager;
    TrackerDelegate trackerDelegate;
    ObjectStore os;
    Map<String, String> blockingErrorKeys;
    public static final List<String> PUBLIC_TAG_LIST = Arrays.asList("im:public");
    private static final Map<String, String> DERIVED_PROPERTIES = new HashMap<String, String>(){
        {
            this.put("jwt.publicidentity", "project.title");
        }
    };

    public void init(ActionServlet servlet, ModuleConfig config) throws ServletException {
        long start = System.currentTimeMillis();
        ServletContext servletContext = servlet.getServletContext();
        this.initBlockingErrors(servletContext);
        Properties webProperties = this.loadWebProperties(servletContext);
        if (webProperties == null) {
            throw new ServletException("webProperties is null");
        }
        this.loadAspectsConfig(servletContext);
        this.loadClassDescriptions(servletContext);
        this.loadOpenIDProviders(servletContext);
        this.loadOAuth2Providers(servletContext, webProperties);
        this.os = this.getProductionObjectStore(webProperties);
        if (this.os == null) {
            throw new ServletException("Production object store is null");
        }
        WebConfig webConfig = this.loadWebConfig(servletContext, this.os);
        if (webConfig == null) {
            throw new ServletException("webConfig is null");
        }
        ObjectStoreWriter userprofileOSW = this.getUserprofileWriter(webProperties);
        if (userprofileOSW == null) {
            throw new ServletException("userprofileOSW is null");
        }
        this.verifyUserProfile(userprofileOSW);
        ObjectStoreSummary oss = this.summariseObjectStore(servletContext);
        this.setupClassSummaryInformation(servletContext, oss, this.os.getModel());
        this.trackerDelegate = this.initTrackers(webProperties, userprofileOSW);
        InterMineAPI im = this.loadInterMineAPI(servletContext, webProperties, webConfig, userprofileOSW, oss);
        this.profileManager = im.getProfileManager();
        Profile superProfile = this.profileManager.getSuperuserProfile();
        this.initSuperUser(superProfile);
        try {
            this.startBagUpgrade(im, this.profileManager.getAllSuperUsers());
        }
        catch (ObjectStoreException e) {
            throw new ServletException("Could not read from userprofile data store", (Throwable)e);
        }
        this.initSearch(servletContext, superProfile);
        servletContext.setAttribute("GRAPH_CACHE", new HashMap());
        this.loadAutoCompleter(servletContext, this.os);
        LOG.debug((Object)"LOADED AUTO COMPLETER");
        InitialiserPlugin.cleanTags(im.getTagManager());
        this.initKeylessClasses(servletContext, webConfig);
        LOG.debug((Object)("Application initialised in " + (System.currentTimeMillis() - start) + "ms"));
    }

    private void initSearch(ServletContext servletContext, Profile superProfile) {
        GlobalRepository searchRepository = new GlobalRepository(superProfile);
        List users = this.profileManager.getSuperUsers();
        for (String su : users) {
            new GlobalRepository(this.profileManager.getProfile(su));
        }
        SessionMethods.setGlobalSearchRepository(servletContext, (SearchRepository)searchRepository);
        LOG.debug((Object)"LOADED SEARCH REPOSITORY");
    }

    private void initSuperUser(Profile superProfile) {
        if (!superProfile.getUsername().equals(PropertiesUtil.getProperties().getProperty("superuser.account").trim())) {
            this.blockingErrorKeys.put("errors.init.superuser", null);
        }
        LOG.debug((Object)"CHECKED SUPER PROFILE");
    }

    private void startBagUpgrade(InterMineAPI im, Collection<Profile> users) {
        for (Profile user : users) {
            if (!im.getBagManager().isAnyBagInState(user, BagState.UPGRADING)) {
                UpgradeBagList upgrade = new UpgradeBagList(user, im.getBagQueryRunner());
                LoginHandler.runBagUpgrade(upgrade, im, user);
            }
            LOG.info((Object)("UPGRADING BAGS FOR " + user.getUsername()));
        }
    }

    private void initKeylessClasses(ServletContext servletContext, WebConfig webConfig) {
        HashMap<String, Boolean> keylessClasses = new HashMap<String, Boolean>();
        for (ClassDescriptor cld : this.os.getModel().getClassDescriptors()) {
            boolean keyless = true;
            for (FieldConfig fc : FieldConfigHelper.getClassFieldConfigs(webConfig, cld)) {
                if (fc.getDisplayer() != null || !fc.getShowInSummary()) continue;
                keyless = false;
                break;
            }
            if (!keyless) continue;
            keylessClasses.put(TypeUtil.unqualifiedName((String)cld.getName()), Boolean.TRUE);
        }
        servletContext.setAttribute("KEYLESS_CLASSES_MAP", keylessClasses);
    }

    private InterMineAPI loadInterMineAPI(ServletContext servletContext, Properties webProperties, WebConfig webConfig, ObjectStoreWriter userprofileOSW, ObjectStoreSummary oss) throws ServletException {
        InterMineAPI im;
        ClassKeys classKeys = this.loadClassKeys(this.os.getModel());
        BagQueryConfig bagQueryConfig = this.loadBagQueries(servletContext, this.os);
        LinkRedirectManager redirector = this.getLinkRedirector(webProperties);
        try {
            im = new InterMineAPI(this.os, userprofileOSW, classKeys, bagQueryConfig, oss, this.trackerDelegate, redirector);
        }
        catch (UserNotFoundException unfe) {
            this.blockingErrorKeys.put("errors.init.superuser", null);
            throw new ServletException("Super user not found");
        }
        SessionMethods.setInterMineAPI(servletContext, im);
        ResourceFinder finder = new ResourceFinder(servletContext);
        InterMineContext.initialise(im, webProperties, webConfig, finder);
        return im;
    }

    private void verifyUserProfile(ObjectStoreWriter userprofileOSW) throws ServletException {
        if (userprofileOSW != null) {
            if (!this.verifyTablesExist((ObjectStore)userprofileOSW)) {
                throw new ServletException("Userprofile objectstore is missing required tables.");
            }
            String superuserAccountName = PropertiesUtil.getProperties().getProperty("superuser.account");
            if (!this.setSuperuser(superuserAccountName, userprofileOSW)) {
                throw new ServletException("Cannot set superuser.account '" + superuserAccountName + "' to be superuser. Does this profile exist?");
            }
            if (!this.verifyListTables((ObjectStore)userprofileOSW)) {
                throw new ServletException("Userprofile objectstore is missing list tables.");
            }
            this.checkSerialNumber((ObjectStore)userprofileOSW);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPermaTokenTable(ObjectStore os, Connection con) throws SQLException, ClassNotFoundException {
        ClassDescriptor cd = os.getModel().getClassDescriptorByName("PermanentToken");
        Database db = ((ObjectStoreInterMineImpl)os).getDatabase();
        if (cd == null) {
            throw new IllegalStateException("Expected model to contain PermanentToken");
        }
        String tableDef = DatabaseUtil.getTableDefinition((Database)db, (ClassDescriptor)cd);
        LOG.info((Object)("Adding table for " + cd.getName()));
        LOG.debug((Object)tableDef);
        try (Statement s = null;){
            s = con.createStatement();
            s.execute(tableDef);
        }
    }

    private void initBlockingErrors(ServletContext servletContext) {
        this.blockingErrorKeys = new HashMap<String, String>();
        SessionMethods.setErrorOnInitialiser(servletContext, this.blockingErrorKeys);
    }

    private ObjectStore getProductionObjectStore(Properties webProperties) {
        String osAlias = (String)webProperties.get("webapp.os.alias");
        try {
            this.os = ObjectStoreFactory.getObjectStore((String)osAlias);
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to create objectstore '" + osAlias + "' specified in web property webapp.os.alias"), (Throwable)e);
            this.blockingErrorKeys.put("errors.init.objectstoreconnection", e.getMessage());
        }
        return this.os;
    }

    private void loadAspectsConfig(ServletContext servletContext) {
        InputStream xmlInputStream = servletContext.getResourceAsStream("/WEB-INF/aspects.xml");
        InputStream xmlInputStreamForValidate = servletContext.getResourceAsStream("/WEB-INF/aspects.xml");
        if (xmlInputStream == null) {
            LOG.info((Object)"Unable to find /WEB-INF/aspects.xml, there will be no aspects");
            SessionMethods.setAspects(servletContext, Collections.EMPTY_MAP);
            SessionMethods.setCategories(servletContext, Collections.EMPTY_SET);
        } else {
            StringWriter writer = new StringWriter();
            try {
                IOUtils.copy((InputStream)xmlInputStreamForValidate, (Writer)writer);
            }
            catch (IOException ioe) {
                LOG.error((Object)"Problems converting xmlInputStream into a String ", (Throwable)ioe);
                this.blockingErrorKeys.put("errors.init.aspects.generic", ioe.getMessage());
                return;
            }
            String xml = writer.toString();
            String xmlSchemaUrl = "";
            try {
                xmlSchemaUrl = servletContext.getResource("/WEB-INF/aspects.xsd").toString();
            }
            catch (MalformedURLException mue) {
                LOG.warn((Object)"Problems retrieving url fo aspects.xsd ", (Throwable)mue);
            }
            if (this.validateXML(xml, xmlSchemaUrl, "errors.init.aspects.validation")) {
                Map<String, Aspect> aspects;
                try {
                    aspects = AspectBinding.unmarhsal(xmlInputStream);
                }
                catch (Exception e) {
                    LOG.error((Object)"problem while reading aspect configuration file", (Throwable)e);
                    this.blockingErrorKeys.put("errors.init.aspects", e.getMessage());
                    return;
                }
                SessionMethods.setAspects(servletContext, aspects);
                SessionMethods.setCategories(servletContext, Collections.unmodifiableSet(aspects.keySet()));
            }
        }
    }

    private boolean validateXML(String xml, String schemaUrl, String errorCode) {
        XMLValidator validator = new XMLValidator();
        validator.validate(xml, schemaUrl);
        if (validator.getErrorsAndWarnings().size() == 0) {
            return true;
        }
        this.blockingErrorKeys.put(errorCode, validator.getErrorsAndWarnings().get(0));
        return false;
    }

    private void loadAutoCompleter(ServletContext servletContext, ObjectStore os) throws ServletException {
        if (os instanceof ObjectStoreInterMineImpl) {
            SessionMethods.setAutoCompleter(servletContext, new AutoCompleter(os));
        }
    }

    private WebConfig loadWebConfig(ServletContext servletContext, ObjectStore os) {
        WebConfig retval = null;
        InputStream xmlInputStream = servletContext.getResourceAsStream("/WEB-INF/webconfig-model.xml");
        InputStream xmlInputStreamForValidation = servletContext.getResourceAsStream("/WEB-INF/webconfig-model.xml");
        if (xmlInputStream == null) {
            LOG.error((Object)"Unable to find /WEB-INF/webconfig-model.xml.");
            this.blockingErrorKeys.put("errors.init.webconfig.notfound", null);
        } else {
            StringWriter writer = new StringWriter();
            try {
                IOUtils.copy((InputStream)xmlInputStreamForValidation, (Writer)writer);
            }
            catch (IOException ioe) {
                LOG.error((Object)"Problems converting xmlInputStream into a String ", (Throwable)ioe);
                this.blockingErrorKeys.put("errors.init.webconfig.generic", ioe.getMessage());
            }
            String xml = writer.toString();
            String xmlSchemaUrl = "";
            try {
                xmlSchemaUrl = servletContext.getResource("/WEB-INF/webconfig-model.xsd").toString();
            }
            catch (MalformedURLException mue) {
                LOG.warn((Object)"Problems retrieving url fo aspects.xsd ", (Throwable)mue);
            }
            if (this.validateXML(xml, xmlSchemaUrl, "errors.init.webconfig.validation")) {
                try {
                    retval = WebConfig.parse(servletContext, os.getModel());
                    String validationMessage = retval.validateWidgetsConfig(os.getModel());
                    if (validationMessage.isEmpty()) {
                        SessionMethods.setWebConfig(servletContext, retval);
                    } else {
                        this.blockingErrorKeys.put("errors.init.webconfig.validation", validationMessage);
                    }
                }
                catch (FileNotFoundException fnf) {
                    LOG.error((Object)"Can't find the webconfig-model.xml file.", (Throwable)fnf);
                    this.blockingErrorKeys.put("errors.init.webconfig.notfound", null);
                }
                catch (ClassNotFoundException cnf) {
                    LOG.error((Object)"Classes mentioned in the webconfig-model.xml file aren't in the Model", (Throwable)cnf);
                    this.blockingErrorKeys.put("errors.init.webconfig.classnotfound", cnf.getMessage());
                }
                catch (Exception e) {
                    LOG.error((Object)"Could not parse the webconfig-model.xml file", (Throwable)e);
                    this.blockingErrorKeys.put("errors.init.webconfig.parsing", e.getMessage());
                }
            }
        }
        return retval;
    }

    private void loadClassDescriptions(ServletContext servletContext) {
        Properties classDescriptions = new Properties();
        try {
            classDescriptions.load(servletContext.getResourceAsStream("/WEB-INF/classDescriptions.properties"));
        }
        catch (Exception e) {
            LOG.error((Object)"Error loading class descriptions", (Throwable)e);
            this.blockingErrorKeys.put("errors.init.classDescriptions", null);
        }
        servletContext.setAttribute("classDescriptions", (Object)classDescriptions);
    }

    private ClassKeys loadClassKeys(Model model) {
        Properties classKeyProps = new Properties();
        try {
            classKeyProps.load(InitialiserPlugin.class.getClassLoader().getResourceAsStream("class_keys.properties"));
        }
        catch (Exception e) {
            LOG.error((Object)"Error loading class descriptions", (Throwable)e);
            this.blockingErrorKeys.put("errors.init.classkeys", null);
        }
        return ClassKeyHelper.readKeys((Model)model, (Properties)classKeyProps);
    }

    private BagQueryConfig loadBagQueries(ServletContext servletContext, ObjectStore os) {
        BagQueryConfig bagQueryConfig = null;
        InputStream is = servletContext.getResourceAsStream("/WEB-INF/bag-queries.xml");
        if (is != null) {
            try {
                bagQueryConfig = BagQueryHelper.readBagQueryConfig((Model)os.getModel(), (InputStream)is);
            }
            catch (Exception e) {
                LOG.error((Object)"Error loading class bag queries. ", (Throwable)e);
                this.blockingErrorKeys.put("errors.init.bagqueries", e.getMessage());
            }
            InputStream isBag = this.getClass().getClassLoader().getResourceAsStream("extraBag.properties");
            Properties bagProperties = new Properties();
            if (isBag != null) {
                try {
                    bagProperties.load(isBag);
                    bagQueryConfig.setConnectField(bagProperties.getProperty("extraBag.connectField"));
                    bagQueryConfig.setExtraConstraintClassName(bagProperties.getProperty("extraBag.className"));
                    bagQueryConfig.setConstrainField(bagProperties.getProperty("extraBag.constrainField"));
                }
                catch (IOException e) {
                    LOG.error((Object)"Error loading extraBag.properties. ", (Throwable)e);
                    this.blockingErrorKeys.put("errors.init.extrabagloading", null);
                }
            } else {
                LOG.error((Object)"Could not find extraBag.properties file");
                this.blockingErrorKeys.put("errors.init.extrabag", null);
            }
        } else {
            LOG.warn((Object)"No custom bag queries found - using default query");
        }
        return bagQueryConfig;
    }

    private void updateOrigins(Map<String, String> lastState, Map<String, List<String>> origins, String currentSource, Properties currentState) {
        for (Map.Entry<Object, Object> pair : currentState.entrySet()) {
            if (!origins.containsKey(pair.getKey())) {
                origins.put(String.valueOf(pair.getKey()), new ArrayList());
            }
            if (!lastState.containsKey(pair.getKey()) || !lastState.get(pair.getKey()).equals(((String)pair.getValue()).trim())) {
                origins.get(pair.getKey()).add(currentSource);
            }
            lastState.put((String)pair.getKey(), ((String)pair.getValue()).trim());
        }
    }

    private Properties loadWebProperties(ServletContext servletContext) {
        HashMap<String, String> lastState = new HashMap<String, String>();
        TreeMap<String, List<String>> origins = new TreeMap<String, List<String>>();
        Properties webProperties = new Properties();
        String globalPropertiesStreamPath = "/WEB-INF/global.web.properties";
        LOG.info((Object)("Loading global webapp properties from " + globalPropertiesStreamPath));
        InputStream globalPropertiesStream = servletContext.getResourceAsStream(globalPropertiesStreamPath);
        try {
            webProperties.load(globalPropertiesStream);
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to find " + globalPropertiesStreamPath), (Throwable)e);
            this.blockingErrorKeys.put("errors.init.globalweb", null);
            return webProperties;
        }
        String xmlLibrary = webProperties.getProperty("javax.xml.stream.XMLOutputFactory");
        System.setProperty("javax.xml.stream.XMLOutputFactory", xmlLibrary);
        this.updateOrigins(lastState, origins, globalPropertiesStreamPath, webProperties);
        Pattern pattern = Pattern.compile("/WEB-INF/(?!global)\\w+\\.web\\.properties$");
        LOG.info((Object)("Looking for extra webapp properties files matching " + pattern.pattern()));
        ResourceFinder finder = new ResourceFinder(servletContext);
        Collection<String> otherResources = finder.findResourcesMatching(pattern);
        LOG.info((Object)("Found " + otherResources.size() + " extra webapp properties files"));
        for (String resource : otherResources) {
            LOG.debug((Object)("Loading extra webapp properties from " + resource));
            InputStream otherResourceStream = servletContext.getResourceAsStream(resource);
            try {
                webProperties.load(otherResourceStream);
            }
            catch (Exception e) {
                LOG.error((Object)("Unable to load " + resource), (Throwable)e);
                this.blockingErrorKeys.put("errors.init.globalweb", null);
                return webProperties;
            }
            this.updateOrigins(lastState, origins, resource, webProperties);
        }
        String modelPropertiesStreamPath = "/WEB-INF/web.properties";
        LOG.info((Object)("Loading model webapp properties from " + modelPropertiesStreamPath));
        InputStream modelPropertiesStream = servletContext.getResourceAsStream(modelPropertiesStreamPath);
        if (modelPropertiesStream != null) {
            try {
                webProperties.load(modelPropertiesStream);
            }
            catch (Exception e) {
                LOG.error((Object)("Unable to load " + modelPropertiesStreamPath), (Throwable)e);
                this.blockingErrorKeys.put("errors.init.webproperties", null);
                return webProperties;
            }
            this.updateOrigins(lastState, origins, modelPropertiesStreamPath, webProperties);
        }
        SessionMethods.setPropertiesOrigins(servletContext, origins);
        Properties trimProperties = this.trimProperties(webProperties);
        this.setComputedProperties(trimProperties);
        SessionMethods.setWebProperties(servletContext, trimProperties);
        MainHelper.loadHelpers((Properties)trimProperties);
        return trimProperties;
    }

    private void setComputedProperties(Properties props) {
        Map<String, String> computedMapping = DERIVED_PROPERTIES;
        for (String dest : computedMapping.keySet()) {
            String src;
            if (!StringUtils.isBlank((String)props.getProperty(dest)) || (src = computedMapping.get(dest)) == null) continue;
            props.setProperty(dest, props.getProperty(src));
        }
    }

    private Properties trimProperties(Properties webProperties) {
        Properties trimProperties = new Properties();
        for (Map.Entry<Object, Object> property : webProperties.entrySet()) {
            trimProperties.put(property.getKey(), ((String)property.getValue()).trim());
        }
        return trimProperties;
    }

    private void loadOpenIDProviders(ServletContext context) {
        HashSet<String> providers = new HashSet<String>();
        Properties providerProps = new Properties();
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("openid-providers.properties");
        if (is == null) {
            LOG.debug((Object)"couldn't find openid providers, using system class-loader");
            is = ClassLoader.getSystemClassLoader().getResourceAsStream("openid-properties.properties");
        }
        if (is != null) {
            try {
                providerProps.load(is);
            }
            catch (IOException e) {
                LOG.error((Object)"Could not load openid-providers.properties", (Throwable)e);
                this.blockingErrorKeys.put("errors.init.openidprovidersloading", null);
                return;
            }
        } else {
            LOG.error((Object)"Could not find openid-providers.properties");
            this.blockingErrorKeys.put("errors.init.openidproviders", null);
            return;
        }
        for (Object key : providerProps.keySet()) {
            String keyString = (String)key;
            if (keyString.endsWith(".alias")) continue;
            providers.add(keyString);
            LOG.debug((Object)("Added " + keyString));
        }
        SessionMethods.setOpenIdProviders(context, providers);
    }

    private void loadOAuth2Providers(ServletContext context, Properties webProperties) {
        LinkedHashSet<String> providers = new LinkedHashSet<String>();
        String oauth2Providers = webProperties.getProperty("oauth2.providers", "");
        for (String provider : oauth2Providers.split(",")) {
            String providerName = provider.trim().toUpperCase();
            if (!webProperties.containsKey("oauth2." + providerName + ".client-id")) continue;
            providers.add(providerName);
        }
        SessionMethods.setOAuth2Providers(context, providers);
    }

    private LinkRedirectManager getLinkRedirector(Properties webProperties) {
        Constructor constr;
        String err = "Initialisation of link redirector failed: ";
        String linkRedirector = (String)webProperties.get("webapp.linkRedirect");
        if (linkRedirector == null) {
            return null;
        }
        Class c = TypeUtil.instantiate((String)linkRedirector);
        try {
            constr = c.getConstructor(Properties.class);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)"Initialisation of link redirector failed: ", (Throwable)e);
            return null;
        }
        LinkRedirectManager redirector = null;
        try {
            redirector = (LinkRedirectManager)constr.newInstance(webProperties);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Initialisation of link redirector failed: ", (Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.error((Object)"Initialisation of link redirector failed: ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)"Initialisation of link redirector failed: ", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)"Initialisation of link redirector failed: ", (Throwable)e);
        }
        return redirector;
    }

    private ObjectStoreSummary summariseObjectStore(ServletContext servletContext) {
        Properties objectStoreSummaryProperties = new Properties();
        InputStream objectStoreSummaryPropertiesStream = servletContext.getResourceAsStream("/WEB-INF/objectstoresummary.properties");
        if (objectStoreSummaryPropertiesStream == null) {
            LOG.error((Object)"Unable to find objectstoresummary.properties");
            this.blockingErrorKeys.put("errors.init.objectstoresummary", null);
        }
        try {
            objectStoreSummaryProperties.load(objectStoreSummaryPropertiesStream);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to read objectstoresummary.properties", (Throwable)e);
            this.blockingErrorKeys.put("errors.init.objectstoresummary.loading", null);
        }
        return new ObjectStoreSummary(objectStoreSummaryProperties);
    }

    private void setupClassSummaryInformation(ServletContext servletContext, ObjectStoreSummary oss, Model model) {
        String errorKey = "errors.init.objectstoresummary.classcount";
        LinkedHashMap<String, String> classes = new LinkedHashMap<String, String>();
        LinkedHashMap<String, Integer> classCounts = new LinkedHashMap<String, Integer>();
        for (String className : new TreeSet(model.getClassNames())) {
            if (!className.equals(InterMineObject.class.getName())) {
                classes.put(className, TypeUtil.unqualifiedName((String)className));
            }
            try {
                classCounts.put(className, oss.getClassCount(className));
            }
            catch (Exception e) {
                LOG.error((Object)("Unable to get class count for " + className), (Throwable)e);
                this.blockingErrorKeys.put(errorKey, e.getMessage());
                return;
            }
        }
        servletContext.setAttribute("classes", classes);
        servletContext.setAttribute("classCounts", classCounts);
        LinkedHashMap subclassesMap = new LinkedHashMap();
        for (ClassDescriptor cld : model.getClassDescriptors()) {
            ArrayList<String> subclasses = new ArrayList<String>();
            for (String thisClassName : new TreeSet<String>(InitialiserPlugin.getChildren(cld))) {
                Integer classCount = (Integer)classCounts.get(thisClassName);
                if (classCount == null) {
                    this.blockingErrorKeys.put(errorKey, thisClassName);
                    return;
                }
                if (classCount <= 0) continue;
                subclasses.add(TypeUtil.unqualifiedName((String)thisClassName));
            }
            subclassesMap.put(TypeUtil.unqualifiedName((String)cld.getName()), subclasses);
        }
        servletContext.setAttribute("SUBCLASSES", subclassesMap);
    }

    private ObjectStoreWriter getUserprofileWriter(Properties webProperties) {
        ObjectStoreWriter osw;
        String userProfileAlias = (String)webProperties.get("webapp.userprofile.os.alias");
        try {
            osw = ObjectStoreWriterFactory.getObjectStoreWriter((String)userProfileAlias);
        }
        catch (ObjectStoreException e) {
            LOG.error((Object)("Unable to create userprofile objectstore '" + userProfileAlias + "' specified in web property webapp.userprofile.os.alias"), (Throwable)e);
            this.blockingErrorKeys.put("errors.init.userprofileconnection", e.getMessage());
            return null;
        }
        return osw;
    }

    private boolean setSuperuser(String accountName, ObjectStoreWriter uosw) {
        UserProfile superuserProfile = this.getUserProfile(accountName, uosw);
        if (superuserProfile != null) {
            superuserProfile.setSuperuser(true);
            try {
                uosw.store((Object)superuserProfile);
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException("Unable to set the flag to the user profile", e);
            }
            return true;
        }
        this.blockingErrorKeys.put("errors.init.superusernotexist", null);
        return false;
    }

    private UserProfile getSuperUser(ObjectStoreWriter uosw) {
        String superuser = PropertiesUtil.getProperties().getProperty("superuser.account");
        UserProfile superuserProfile = new UserProfile();
        superuserProfile.setUsername(superuser);
        HashSet<String> fieldNames = new HashSet<String>();
        fieldNames.add("username");
        try {
            superuserProfile = (UserProfile)uosw.getObjectByExample((InterMineObject)superuserProfile, fieldNames);
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException("Unable to load user profile", e);
        }
        return superuserProfile;
    }

    private boolean verifySuperUserExist(ObjectStoreWriter uosw) {
        UserProfile superuserProfile = this.getSuperUser(uosw);
        if (superuserProfile != null) {
            superuserProfile.setSuperuser(true);
            try {
                uosw.store((Object)superuserProfile);
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException("Unable to set the flag to the user profile", e);
            }
            return true;
        }
        this.blockingErrorKeys.put("errors.init.superusernotexist", null);
        return false;
    }

    private UserProfile getUserProfile(String profileName, ObjectStoreWriter uosw) {
        UserProfile superuserProfile = new UserProfile();
        superuserProfile.setUsername(profileName);
        HashSet<String> fieldNames = new HashSet<String>();
        fieldNames.add("username");
        try {
            superuserProfile = (UserProfile)uosw.getObjectByExample((InterMineObject)superuserProfile, fieldNames);
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException("Unable to load user profile " + profileName, e);
        }
        return superuserProfile;
    }

    public void destroy() {
        ShutdownHook.shutdown();
        Runtime.getRuntime().removeShutdownHook((Thread)ShutdownHook.getInstance());
    }

    protected static void cleanTags(TagManager tagManager) {
        for (Tag tag : tagManager.getTagsByType("class")) {
            try {
                Class.forName(tag.getObjectIdentifier());
            }
            catch (ClassNotFoundException e) {
                tagManager.deleteTag(tag);
            }
        }
    }

    protected static Set<String> getChildren(ClassDescriptor cld) {
        HashSet<String> children = new HashSet<String>();
        InitialiserPlugin.getChildren(cld, children);
        return children;
    }

    protected static void getChildren(ClassDescriptor cld, Set<String> children) {
        for (ClassDescriptor child : cld.getSubDescriptors()) {
            children.add(child.getName());
            InitialiserPlugin.getChildren(child, children);
        }
    }

    private TrackerDelegate initTrackers(Properties webProperties, ObjectStoreWriter userprofileOSW) {
        if (!this.verifyTrackTables(userprofileOSW.getObjectStore())) {
            this.blockingErrorKeys.put("errors.init.tracktable.runAnt", null);
        }
        return this.getTrackerDelegate(webProperties, userprofileOSW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyTrackTables(ObjectStore uos) {
        Connection con = null;
        try {
            ResultSet res;
            con = ((ObjectStoreInterMineImpl)uos).getConnection();
            if (DatabaseUtil.tableExists((Connection)con, (String)"templatetrack") && (res = con.getMetaData().getColumns(null, null, "templatetrack", "timestamp")).next()) {
                boolean bl = res.getString(3).equals("templatetrack") && "timestamp".equals(res.getString(4)) && res.getInt(5) == 93;
                return bl;
            }
        }
        catch (SQLException sqle) {
            LOG.error((Object)"Problem retriving connection", (Throwable)sqle);
        }
        finally {
            ((ObjectStoreInterMineImpl)uos).releaseConnection(con);
        }
        return true;
    }

    private TrackerDelegate getTrackerDelegate(Properties webProperties, ObjectStoreWriter userprofileOSW) {
        String trackerList = (String)webProperties.get("webapp.trackers");
        LOG.info((Object)("initializeTrackers: trackerList is" + trackerList));
        if (trackerList != null) {
            String[] trackerClassNames = trackerList.split(",");
            return new TrackerDelegate(trackerClassNames, userprofileOSW);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyTablesExist(ObjectStore uos) {
        Connection con = null;
        Set classDescriptors = uos.getModel().getClassDescriptors();
        try {
            con = ((ObjectStoreInterMineImpl)uos).getConnection();
            for (ClassDescriptor cd : classDescriptors) {
                String tableNameToVerify;
                if (cd.isInterface() || DatabaseUtil.tableExists((Connection)con, (String)(tableNameToVerify = DatabaseUtil.getTableName((ClassDescriptor)cd)))) continue;
                LOG.error((Object)("In the userprofile database, the table " + tableNameToVerify + " doesn't exist."));
                this.blockingErrorKeys.put("errors.init.tablesNotExisting", tableNameToVerify);
                boolean bl = false;
                return bl;
            }
        }
        catch (SQLException sqle) {
            LOG.error((Object)"Problem retrieving connection", (Throwable)sqle);
        }
        finally {
            ((ObjectStoreInterMineImpl)uos).releaseConnection(con);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyListTables(ObjectStore uos) {
        Connection con = null;
        try {
            con = ((ObjectStoreInterMineImpl)uos).getConnection();
            if (!DatabaseUtil.tableExists((Connection)con, (String)"bagvalues")) {
                this.blockingErrorKeys.put("errors.init.savedbagtable.runLoadBagValuesTableAnt", null);
                boolean bl = false;
                return bl;
            }
            if (!DatabaseUtil.columnExists((Connection)con, (String)"bagvalues", (String)"extra") || DatabaseUtil.columnExists((Connection)con, (String)"savedbag", (String)"intermine_current")) {
                this.blockingErrorKeys.put("errors.init.savedbagtable.runListTablesAnt", null);
                boolean bl = false;
                return bl;
            }
        }
        catch (SQLException sqle) {
            LOG.error((Object)"Probelm retrieving connection", (Throwable)sqle);
        }
        finally {
            ((ObjectStoreInterMineImpl)uos).releaseConnection(con);
        }
        return true;
    }

    private void checkSerialNumber(ObjectStore uosw) throws ServletException {
        block15: {
            try {
                boolean listUpgrade = false;
                String productionSerialNumber = MetadataManager.retrieve((Database)((ObjectStoreInterMineImpl)this.os).getDatabase(), (String)"serialNumber");
                String userprofileSerialNumber = MetadataManager.retrieve((Database)((ObjectStoreInterMineImpl)uosw).getDatabase(), (String)"serialNumber");
                LOG.info((Object)("Production database has serialNumber \"" + productionSerialNumber + "\""));
                LOG.info((Object)("Userprofile database has serialNumber \"" + userprofileSerialNumber + "\""));
                if (!(productionSerialNumber == null || userprofileSerialNumber != null && userprofileSerialNumber.equals(productionSerialNumber))) {
                    listUpgrade = true;
                }
                if (productionSerialNumber == null && userprofileSerialNumber != null) {
                    listUpgrade = true;
                }
                if (!listUpgrade) break block15;
                LOG.debug((Object)"Serial numbers not equal: list upgrade needed");
                Connection conn = null;
                try {
                    conn = ((ObjectStoreInterMineImpl)uosw).getDatabase().getConnection();
                    if (DatabaseUtil.columnExists((Connection)conn, (String)"savedbag", (String)"intermine_state")) {
                        DatabaseUtil.updateColumnValue((Database)((ObjectStoreInterMineImpl)uosw).getDatabase(), (String)"savedbag", (String)"intermine_state", (Object)BagState.NOT_CURRENT.toString());
                    }
                }
                catch (SQLException sqle) {
                    throw new BuildException("Problems connecting bagvalues table", (Throwable)sqle);
                }
                finally {
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
                MetadataManager.store((Database)((ObjectStoreInterMineImpl)uosw).getDatabase(), (String)"serialNumber", (String)productionSerialNumber);
            }
            catch (SQLException sqle) {
                throw new ServletException("Error verifying list upgrading", (Throwable)sqle);
            }
        }
    }
}

