/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.TagManager;
import org.intermine.api.profile.Taggable;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.CollectionDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.web.logic.session.SessionMethods;

public class InlineTagEditorController
extends TilesAction {
    private static int counter = 0;

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Set availableTags;
        Set currentTags;
        Object taggable = context.getAttribute("taggable");
        Profile profile = SessionMethods.getProfile(request.getSession());
        String tagged = null;
        String type = null;
        if (taggable instanceof Taggable) {
            tagged = ((Taggable)taggable).getName();
            type = ((Taggable)taggable).getTagType();
        } else if (taggable instanceof FieldDescriptor) {
            FieldDescriptor fd = (FieldDescriptor)taggable;
            tagged = fd.getClassDescriptor().getUnqualifiedName() + "." + fd.getName();
            type = taggable instanceof CollectionDescriptor ? "collection" : (taggable instanceof ReferenceDescriptor ? "reference" : "attribute");
        } else if (taggable instanceof ClassDescriptor) {
            tagged = ((ClassDescriptor)taggable).getName();
            type = "class";
        }
        request.setAttribute("editorId", (Object)this.createUniqueEditorId());
        request.setAttribute("taggableIdentifer", (Object)tagged);
        request.setAttribute("type", (Object)type);
        InterMineAPI im = SessionMethods.getInterMineAPI(request.getSession());
        TagManager tagManager = im.getTagManager();
        if (profile.isLoggedIn()) {
            currentTags = tagManager.getObjectTagNames(tagged, type, profile.getUsername());
            availableTags = tagManager.getUserTagNames(type, profile.getUsername());
        } else {
            currentTags = new TreeSet();
            availableTags = new TreeSet();
        }
        request.setAttribute("currentTags", currentTags);
        request.setAttribute("availableTags", availableTags);
        return null;
    }

    private String createUniqueEditorId() {
        return "inline-tag-editor-" + counter++;
    }
}

