/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagManager;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.WebResultsExecutor;
import org.intermine.api.results.WebResults;
import org.intermine.api.results.WebTable;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.PathQueryBinding;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.export.http.TableExporterFactory;
import org.intermine.web.logic.export.http.TableHttpExporter;
import org.intermine.web.logic.pathqueryresult.PathQueryResultHelper;
import org.intermine.web.logic.results.PagedTable;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ForwardParameters;
import org.intermine.web.struts.InterMineDispatchAction;

public class LoadQueryAction
extends InterMineDispatchAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward xml(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        Profile profile = SessionMethods.getProfile(session);
        String trail = request.getParameter("trail");
        String queryXml = request.getParameter("query");
        Boolean skipBuilder = Boolean.valueOf(request.getParameter("skipBuilder"));
        String exportFormat = request.getParameter("exportFormat");
        PathQuery query = PathQueryBinding.unmarshalPathQuery((Reader)new StringReader(queryXml), (int)2);
        BagManager bagManager = im.getBagManager();
        Map allBags = bagManager.getBags(profile);
        for (String bagName : query.getBagNames()) {
            if (allBags.containsKey(bagName)) continue;
            throw new RuntimeException("Saved bag (list) '" + bagName + "' not found for profile: " + profile.getUsername() + ", referenced in query: " + query);
        }
        if (exportFormat == null) {
            SessionMethods.loadQuery(query, session, response);
            if (!skipBuilder.booleanValue()) {
                return mapping.findForward("query");
            }
            SessionMethods.logQuery(request.getSession());
            return new ForwardParameters(mapping.findForward("results")).addParameter("trail", trail).forward();
        }
        PagedTable pt = null;
        try {
            WebConfig webConfig;
            TableExporterFactory factory;
            TableHttpExporter exporter;
            WebResultsExecutor executor = im.getWebResultsExecutor(profile);
            pt = new PagedTable((WebTable)executor.execute(query));
            if (pt.getWebTable() instanceof WebResults) {
                ((WebResults)pt.getWebTable()).goFaster();
            }
            if ((exporter = (factory = new TableExporterFactory(webConfig = SessionMethods.getWebConfig(request))).getExporter(exportFormat)) == null) {
                throw new RuntimeException("unknown export format: " + exportFormat);
            }
            exporter.export(pt, request, response, null, null, null);
            ActionForward actionForward = null;
            return actionForward;
        }
        finally {
            if (pt != null && pt.getWebTable() instanceof WebResults) {
                ((WebResults)pt.getWebTable()).releaseGoFaster();
            }
        }
    }

    public ActionForward list(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        Profile profile = SessionMethods.getProfile(session);
        String listName = request.getParameter("name");
        if (listName == null) {
            this.recordError(new ActionMessage("query.load.noName"), request);
            return mapping.findForward("errors");
        }
        BagManager bagManager = im.getBagManager();
        Map allBags = bagManager.getBags(profile);
        if (allBags == null) {
            this.recordError(new ActionMessage("query.load.notFound"), request);
            return mapping.findForward("errors");
        }
        InterMineBag bag = (InterMineBag)allBags.get(listName);
        if (bag == null) {
            this.recordError(new ActionMessage("query.load.notFound"), request);
            return mapping.findForward("errors");
        }
        WebConfig webConfig = SessionMethods.getWebConfig(request);
        PathQuery query = PathQueryResultHelper.makePathQueryForBag(bag, webConfig, im.getModel());
        SessionMethods.loadQuery(query, session, response);
        return mapping.findForward("query");
    }
}

