/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.web.logic.profile.LoginHandler;
import org.intermine.web.logic.profile.ProfileMergeIssues;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.LoginForm;

public class LoginAction
extends LoginHandler {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        LoginForm lf = (LoginForm)form;
        ActionErrors errors = lf.validate(mapping, request);
        if (!errors.isEmpty()) {
            this.saveErrors(request, (ActionMessages)errors);
            return mapping.findForward("login");
        }
        ProfileMergeIssues issues = this.doLogin(request, lf.getUsername(), lf.getPassword());
        Profile user = SessionMethods.getProfile(session);
        this.recordMessage(new ActionMessage("login.loggedin", (Object)user.getName()), request);
        im.getTrackerDelegate().trackLogin(lf.getUsername());
        if (issues.hasIssues()) {
            for (Map.Entry<String, String> renamed : issues.getRenamedBags().entrySet()) {
                this.recordMessage(new ActionMessage("login.renamedbags", (Object)renamed.getKey(), (Object)renamed.getValue()), request);
            }
            for (Map.Entry<String, String> renamed : issues.getRenamedTemplates().entrySet()) {
                this.recordMessage(new ActionMessage("login.failedtemplate", (Object)renamed.getKey(), (Object)renamed.getValue()), request);
            }
            return mapping.findForward("mymine");
        }
        if (lf.returnToString != null && lf.returnToString.startsWith("/") && lf.returnToString.indexOf("error") == -1 && lf.returnToString.indexOf("bagUploadConfirm") == -1 && lf.returnToString.indexOf("keywordsearchresults") == -1) {
            return new ActionForward(lf.returnToString);
        }
        return mapping.findForward("mymine");
    }
}

