/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.AdditionalConverter;
import org.intermine.api.bag.BagManager;
import org.intermine.api.bag.BagQueryConfig;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.template.TemplateManager;
import org.intermine.api.util.NameUtil;
import org.intermine.metadata.Model;
import org.intermine.metadata.TypeUtil;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.PortalHelper;
import org.intermine.web.logic.bag.BagConversionHelper;
import org.intermine.web.logic.bag.BagConverter;
import org.intermine.web.logic.results.PagedTable;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ForwardParameters;
import org.intermine.web.struts.InterMineAction;
import org.intermine.web.struts.ModifyBagDetailsForm;

public class ModifyBagDetailsAction
extends InterMineAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        Profile profile = SessionMethods.getProfile(session);
        Model model = im.getModel();
        ModifyBagDetailsForm mbdf = (ModifyBagDetailsForm)form;
        BagManager bagManager = im.getBagManager();
        InterMineBag imBag = bagManager.getBag(profile, mbdf.getBagName());
        String bagIdentifier = "bag." + imBag.getName();
        if (request.getParameter("removeFromBag") != null) {
            PagedTable pc = SessionMethods.getResultsTable(session, bagIdentifier);
            String msg = "";
            if (pc.isAllRowsSelected()) {
                msg = "You can't remove all items from your list.  Try deleting your list instead.";
            } else {
                int removed = pc.removeSelectedFromBag(imBag, session);
                msg = "You have removed " + removed + " items from your list.";
            }
            SessionMethods.recordMessage(msg, session);
            return new ForwardParameters(mapping.findForward("bagDetails")).addParameter("bagName", mbdf.getBagName()).addParameter("table", "open").forward();
        }
        if (request.getParameter("addToBag") != null) {
            InterMineBag newBag = bagManager.getBag(profile, mbdf.getExistingBagName());
            String msg = "";
            if (newBag.getType().equals(imBag.getType())) {
                PagedTable pc = SessionMethods.getResultsTable(session, bagIdentifier);
                int oldSize = newBag.size();
                pc.addSelectedToBag(newBag);
                int newSize = newBag.size();
                int added = newSize - oldSize;
                msg = "You have added " + added + " items from list <strong>" + imBag.getName() + "</strong> to list <strong>" + newBag.getName() + "</strong>";
            } else {
                msg = "You can only add objects to other lists of the same type";
            }
            SessionMethods.recordMessage(msg, session);
        } else if (request.getParameter("convertToThing") != null) {
            Iterator pc;
            BagQueryConfig bagQueryConfig = im.getBagQueryConfig();
            Set additionalConverters = bagQueryConfig.getAdditionalConverters(imBag.getType());
            if (additionalConverters != null && !additionalConverters.isEmpty() && (pc = additionalConverters.iterator()).hasNext()) {
                AdditionalConverter additionalConverter = (AdditionalConverter)pc.next();
                BagConverter bagConverter = PortalHelper.getBagConverter(im, SessionMethods.getWebConfig(request), additionalConverter.getClassName());
                List<Integer> converted = bagConverter.getConvertedObjectIds(profile, imBag.getType(), imBag.getContentsAsIds(), mbdf.getExtraFieldValue());
                if (converted.size() == 1) {
                    return this.goToReport(mapping, converted.get(0).toString());
                }
                String bagName = NameUtil.generateNewName(profile.getSavedBags().keySet(), (String)(mbdf.getExtraFieldValue() + " orthologues of " + imBag.getName()));
                InterMineBag newBag = profile.createBag(bagName, imBag.getType(), "", (Map)im.getClassKeys());
                return this.createBagAndGoToBagDetails(mapping, newBag, converted);
            }
        } else {
            if (request.getParameter("useBag") != null) {
                PagedTable pc = SessionMethods.getResultsTable(session, bagIdentifier);
                PathQuery pathQuery = pc.getWebTable().getPathQuery().clone();
                SessionMethods.setQuery(session, pathQuery);
                session.setAttribute("path", (Object)imBag.getType());
                session.setAttribute("prefix", (Object)imBag.getType());
                String msg = "You can now create a query using your list " + imBag.getName();
                SessionMethods.recordMessage(msg, session);
                return mapping.findForward("query");
            }
            if (request.getParameter("convert") != null && request.getParameter("bagName") != null) {
                String type2 = request.getParameter("convert");
                TemplateManager templateManager = im.getTemplateManager();
                Class classA = TypeUtil.instantiate((String)(model.getPackageName() + "." + imBag.getType()));
                Class classB = TypeUtil.instantiate((String)(model.getPackageName() + "." + type2));
                PathQuery q = BagConversionHelper.getConvertedObjects(session, templateManager.getConversionTemplates(), classA, classB, imBag);
                q.setTitle(type2 + "s from list '" + imBag.getName() + "'");
                SessionMethods.loadQuery(q, session, response);
                String trail = "%7Cbag." + imBag.getName();
                return new ForwardParameters(mapping.findForward("results")).addParameter("trail", trail).forward();
            }
        }
        return new ForwardParameters(mapping.findForward("bagDetails")).addParameter("bagName", mbdf.getBagName()).forward();
    }

    private ActionForward createBagAndGoToBagDetails(ActionMapping mapping, InterMineBag imBag, List<Integer> bagList) throws ObjectStoreException {
        imBag.addIdsToBag(bagList, imBag.getType());
        return new ForwardParameters(mapping.findForward("bagDetails")).addParameter("bagName", imBag.getName()).forward();
    }

    private ActionForward goToReport(ActionMapping mapping, String id) {
        return new ForwardParameters(mapping.findForward("report")).addParameter("id", id).forward();
    }
}

