/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.tiles.ComponentContext;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagManager;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.WebResultsExecutor;
import org.intermine.api.results.WebResults;
import org.intermine.api.results.WebTable;
import org.intermine.api.template.ApiTemplate;
import org.intermine.api.template.TemplateHelper;
import org.intermine.api.template.TemplateManager;
import org.intermine.api.template.TemplatePopulator;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.PathQuery;
import org.intermine.template.TemplatePopulatorException;
import org.intermine.template.TemplateQuery;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.logic.results.DisplayField;
import org.intermine.web.logic.results.PagedTable;
import org.intermine.web.logic.results.ReportObject;
import org.intermine.web.logic.results.ReportObjectFactory;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ForwardParameters;
import org.intermine.web.struts.ReportDisplayerController;
import org.intermine.web.struts.ReportTemplateController;

public class ModifyDetails
extends DispatchAction {
    private static final Logger LOG = Logger.getLogger(ModifyDetails.class);

    public ActionForward runTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TemplateQuery populatedTemplate;
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        String name = request.getParameter("name");
        String scope = request.getParameter("scope");
        String bagName = request.getParameter("bagName");
        String idForLookup = request.getParameter("idForLookup");
        Profile profile = SessionMethods.getProfile(session);
        TemplateManager templateManager = im.getTemplateManager();
        ApiTemplate template = templateManager.getTemplate(profile, name, scope);
        BagManager bagManager = im.getBagManager();
        InterMineBag bag = bagManager.getBag(profile, bagName);
        try {
            if (idForLookup != null && idForLookup.length() != 0) {
                Integer objectId = new Integer(idForLookup);
                ObjectStore os = im.getObjectStore();
                InterMineObject object = os.getObjectById(objectId);
                template = TemplateHelper.removeDirectAttributesFromView((TemplateQuery)template);
                populatedTemplate = TemplatePopulator.populateTemplateWithObject((TemplateQuery)template, (InterMineObject)object);
            } else {
                populatedTemplate = TemplatePopulator.populateTemplateWithBag((TemplateQuery)template, (InterMineBag)bag);
            }
        }
        catch (TemplatePopulatorException e) {
            LOG.error((Object)("Error running up template '" + template.getName() + "' from report page for" + (idForLookup == null ? " bag " + bagName : " object " + idForLookup) + "."), (Throwable)e);
            throw new RuntimeException("Error running up template '" + template.getName() + "' from report page for" + (idForLookup == null ? " bag " + bagName : " object " + idForLookup) + ".", e);
        }
        String identifier = "itt." + populatedTemplate.getName() + "." + idForLookup;
        WebResultsExecutor executor = im.getWebResultsExecutor(profile);
        WebResults webResults = executor.execute((PathQuery)populatedTemplate);
        PagedTable pagedResults = new PagedTable((WebTable)webResults, 10);
        SessionMethods.setResultsTable(session, identifier, pagedResults);
        String trail = request.getParameter("trail");
        trail = trail != null ? trail + "%7Cresults." + identifier : "%7Cresults." + identifier;
        return new ForwardParameters(mapping.findForward("results")).addParameter("templateQueryTitle", template.getTitle()).addParameter("templateQueryDescription", template.getDescription() != null ? template.getDescription() : "").addParameter("table", identifier).addParameter("trail", trail).forward();
    }

    @Deprecated
    public ActionForward verbosify(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        if (session == null) {
            return null;
        }
        String trail = request.getParameter("trail");
        ReportObject object = this.getReportObject(session, request.getParameter("id"));
        if (object != null) {
            // empty if block
        }
        return this.forwardToReport(mapping, request.getParameter("id"), trail);
    }

    @Deprecated
    public ActionForward unverbosify(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String trail = request.getParameter("trail");
        return this.forwardToReport(mapping, request.getParameter("id"), trail);
    }

    public ActionForward ajaxVerbosify(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        String fieldName = request.getParameter("field");
        String trail = request.getParameter("trail");
        ReportObject object = this.getReportObject(session, request.getParameter("id"));
        DisplayField collection = object.getRefsAndCollections().get(fieldName);
        request.setAttribute("object", (Object)object);
        request.setAttribute("trail", (Object)trail);
        request.setAttribute("collection", (Object)collection);
        request.setAttribute("fieldName", (Object)fieldName);
        return null;
    }

    public ActionForward ajaxTemplateCount(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        Profile profile = SessionMethods.getProfile(session);
        String type = request.getParameter("type");
        String id = request.getParameter("id");
        String templateName = request.getParameter("template");
        String detailsType = request.getParameter("detailsType");
        ObjectStore os = im.getObjectStore();
        TemplateManager templateManager = im.getTemplateManager();
        ApiTemplate tq = templateManager.getTemplate(profile, templateName, type);
        ComponentContext cc = new ComponentContext();
        if ("object".equals(detailsType)) {
            InterMineObject o = os.getObjectById(new Integer(id));
            ReportObjectFactory reportObjects = SessionMethods.getReportObjects(session);
            ReportObject obj = reportObjects.get(o);
            cc.putAttribute("reportObject", (Object)obj);
            cc.putAttribute("templateQuery", (Object)tq);
            cc.putAttribute("placement", (Object)request.getParameter("placement"));
            try {
                new ReportTemplateController().execute(cc, mapping, form, request, response);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            request.setAttribute("org.apache.struts.taglib.tiles.CompContext", (Object)cc);
            return mapping.findForward("reportTemplateTable");
        }
        BagManager bagManager = im.getBagManager();
        InterMineBag interMineBag = bagManager.getBag(profile, id);
        cc.putAttribute("interMineIdBag", (Object)interMineBag);
        cc.putAttribute("templateQuery", (Object)tq);
        cc.putAttribute("placement", (Object)request.getParameter("placement"));
        new ReportTemplateController().execute(cc, mapping, form, request, response);
        request.setAttribute("org.apache.struts.taglib.tiles.CompContext", (Object)cc);
        return mapping.findForward("reportTemplateTable");
    }

    public ActionForward ajaxShowDisplayer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String displayerName = request.getParameter("name");
        String reportObjectID = request.getParameter("id");
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        ObjectStore os = im.getObjectStore();
        try {
            InterMineObject o = os.getObjectById(new Integer(reportObjectID));
            ReportObjectFactory reportObjects = SessionMethods.getReportObjects(session);
            ReportObject reportObject = reportObjects.get(o);
            ReportDisplayer d = reportObject.getReportDisplayer(displayerName);
            ComponentContext cc = new ComponentContext();
            cc.putAttribute("reportObject", (Object)reportObject);
            cc.putAttribute("displayer", (Object)d);
            new ReportDisplayerController().execute(cc, mapping, form, request, response);
            request.setAttribute("org.apache.struts.taglib.tiles.CompContext", (Object)cc);
            return mapping.findForward("reportDisplayer");
        }
        catch (ObjectStoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ActionForward forwardToReport(ActionMapping mapping, String id, String trail) {
        ForwardParameters forward = new ForwardParameters(mapping.findForward("report"));
        forward.addParameter("id", id);
        forward.addParameter("trail", trail);
        return forward.forward();
    }

    protected ReportObject getReportObject(HttpSession session, String idString) {
        ObjectStore os = SessionMethods.getInterMineAPI(session).getObjectStore();
        InterMineObject obj = null;
        try {
            obj = os.getObjectById(new Integer(idString));
        }
        catch (ObjectStoreException e) {
            LOG.error((Object)("Exception while fetching object with id " + idString), (Throwable)e);
        }
        if (obj == null) {
            LOG.error((Object)("Could not find object with id " + idString));
            return null;
        }
        ReportObjectFactory reportObjects = SessionMethods.getReportObjects(session);
        ReportObject retval = reportObjects.get(obj);
        if (retval == null) {
            LOG.error((Object)("Could not find ReportObject on session for id " + idString));
        }
        return retval;
    }
}

