/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.SavedQuery;
import org.intermine.api.util.NameUtil;
import org.intermine.template.TemplateQuery;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ForwardParameters;
import org.intermine.web.struts.InterMineDispatchAction;

public class ModifyQueryChangeAction
extends InterMineDispatchAction {
    private static final Logger LOG = Logger.getLogger(ModifyQueryChangeAction.class);

    public ActionForward load(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Profile profile = SessionMethods.getProfile(session);
        String queryName = request.getParameter("name");
        SavedQuery sq = "history".equals(request.getParameter("type")) ? (SavedQuery)profile.getHistory().get(queryName) : (SavedQuery)profile.getSavedQueries().get(queryName);
        if (sq == null) {
            this.recordError(new ActionMessage("errors.query.missing", (Object)queryName), request);
            return mapping.findForward("mymine");
        }
        SessionMethods.loadQuery(sq.getPathQuery(), session, response);
        if (sq.getPathQuery() instanceof TemplateQuery) {
            return new ForwardParameters(mapping.findForward("template")).addParameter("loadModifiedTemplate", "true").addParameter("name", sq.getName()).forward();
        }
        return mapping.findForward("query");
    }

    public ActionForward run(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Profile profile = SessionMethods.getProfile(session);
        String queryName = request.getParameter("name");
        String trail = request.getParameter("trail");
        SavedQuery sq = "history".equals(request.getParameter("type")) ? (SavedQuery)profile.getHistory().get(queryName) : (SavedQuery)profile.getSavedQueries().get(queryName);
        if (sq == null) {
            this.recordError(new ActionMessage("errors.query.missing", (Object)queryName), request);
            return mapping.findForward("mymine");
        }
        SessionMethods.loadQuery(sq.getPathQuery(), session, response);
        if (StringUtils.isEmpty((String)trail)) {
            trail = "%7Cquery%7Cresults";
        }
        return new ForwardParameters(mapping.findForward("results")).addParameter("trail", trail).forward();
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Profile profile = SessionMethods.getProfile(session);
        String queryName = request.getParameter("name");
        SavedQuery sq = (SavedQuery)profile.getHistory().get(queryName);
        if (sq == null) {
            this.recordError(new ActionMessage("errors.query.missing", (Object)queryName), request);
            return mapping.findForward("mymine");
        }
        sq = SessionMethods.saveQuery(session, NameUtil.findNewQueryName(profile.getSavedQueries().keySet(), (String)queryName), sq.getPathQuery(), sq.getDateCreated());
        this.recordMessage(new ActionMessage("savedInSavedQueries.message", (Object)sq.getName()), request);
        return new ForwardParameters(mapping.findForward("mymine")).addParameter("action", "rename").addParameter("subtab", "saved").addParameter("name", sq.getName()).forward();
    }
}

