/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.search.GlobalRepository;
import org.intermine.api.search.SearchRepository;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.InterMineAction;
import org.intermine.web.struts.ModifySuperUserForm;

public class ModifySuperUserAction
extends InterMineAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Profile profileLogged;
        String userLogged;
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        ProfileManager pm = im.getProfileManager();
        List allUsers = pm.getProfileUserNames();
        ModifySuperUserForm superUserForm = (ModifySuperUserForm)form;
        String[] superUsers = superUserForm.getSuperUsers();
        List<String> superUsersList = Arrays.asList(superUsers);
        if (superUsersList.isEmpty()) {
            this.recordMessage(new ActionMessage("errors.users.superusernotselected"), request);
            return mapping.findForward("mymine");
        }
        String suInProperties = pm.getSuperuser();
        if (!superUsersList.contains(suInProperties)) {
            this.recordMessage(new ActionMessage("errors.users.superuserinpropertiesnotselected"), request);
        }
        if (!superUsersList.contains(userLogged = (profileLogged = SessionMethods.getProfile(session)).getUsername())) {
            this.recordMessage(new ActionMessage("errors.users.userloggednotselected"), request);
        }
        for (String user : allUsers) {
            Profile profileToUpdate = pm.getProfile(user);
            if (superUsersList.contains(user)) {
                if (profileToUpdate.isSuperuser()) continue;
                profileToUpdate.setSuperuser(true);
                SessionMethods.setGlobalSearchRepository(session.getServletContext(), (SearchRepository)new GlobalRepository(profileToUpdate));
                continue;
            }
            if (user.equals(suInProperties) || user.equals(userLogged) || !profileToUpdate.isSuperuser()) continue;
            profileToUpdate.setSuperuser(false);
            GlobalRepository globalRepository = (GlobalRepository)SessionMethods.getGlobalSearchRepository(session.getServletContext());
            globalRepository.deleteGlobalRepository(profileToUpdate);
        }
        return mapping.findForward("mymine");
    }
}

