/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.template.TemplateQuery;
import org.intermine.util.XmlUtil;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.InterMineAction;
import org.intermine.web.struts.ModifyTemplateForm;

public class ModifyTemplateAction
extends InterMineAction {
    private static final Logger LOG = Logger.getLogger(ModifyTemplateAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModifyTemplateForm mtf = (ModifyTemplateForm)form;
        ActionErrors errors = mtf.validate(mapping, request);
        if (errors == null || errors.isEmpty()) {
            if (request.getParameter("delete") != null) {
                errors = this.delete(mapping, form, request, response);
            } else if (request.getParameter("export") != null || mtf.getTemplateButton() != null) {
                this.export(mapping, form, request, response);
            }
        }
        this.saveErrors(request, (ActionMessages)errors);
        if (request.getParameter("export") != null || mtf.getTemplateButton() != null) {
            return null;
        }
        return this.getReturn(mtf.getPageName(), mapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionErrors delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        Profile profile = SessionMethods.getProfile(session);
        ModifyTemplateForm mqf = (ModifyTemplateForm)form;
        ActionErrors errors = new ActionErrors();
        try {
            profile.disableSaving();
            for (int i = 0; i < mqf.getSelected().length; ++i) {
                String template = mqf.getSelected()[i];
                if (profile.getTemplate(template) == null) {
                    errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("errors.modifyTemplate.delete"));
                }
                profile.deleteTemplate(template, im.getTrackerDelegate(), true);
            }
        }
        finally {
            profile.enableSaving();
        }
        return errors;
    }

    public void export(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        Profile profile = SessionMethods.getProfile(session);
        ModifyTemplateForm mqf = (ModifyTemplateForm)form;
        response.setContentType("text/plain; charset=utf-8");
        PrintStream out = new PrintStream((OutputStream)response.getOutputStream());
        out.println("<template-queries>");
        Map myTemplates = profile.getSavedTemplates();
        Map publicTemplates = im.getProfileManager().getSuperuserProfile().getSavedTemplates();
        for (int i = 0; i < mqf.getSelected().length; ++i) {
            String name = mqf.getSelected()[i];
            String xml = null;
            if (publicTemplates.get(name) != null) {
                xml = ((TemplateQuery)publicTemplates.get(name)).toXml(2);
            } else if (myTemplates.get(name) != null) {
                xml = ((TemplateQuery)myTemplates.get(name)).toXml(2);
            }
            if (xml == null) continue;
            xml = XmlUtil.indentXmlSimple((String)xml).trim();
            out.println(xml);
        }
        out.println("</template-queries>");
        out.flush();
    }

    private ActionForward getReturn(String pageName, ActionMapping mapping) {
        if (pageName != null && "MyMine".equals(pageName)) {
            return mapping.findForward("mymine");
        }
        return mapping.findForward("templates");
    }
}

