/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.TagManager;
import org.intermine.api.profile.UserPreferences;
import org.intermine.api.template.ApiTemplate;
import org.intermine.api.template.TemplatePrecomputeHelper;
import org.intermine.api.template.TemplateSummariser;
import org.intermine.api.tracker.TrackerDelegate;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.intermine.ObjectStoreInterMineImpl;
import org.intermine.objectstore.query.Query;
import org.intermine.template.TemplateQuery;
import org.intermine.util.PropertiesUtil;
import org.intermine.web.logic.results.WebState;
import org.intermine.web.logic.session.SessionMethods;

public class MyMineController
extends TilesAction {
    private static final String BOOL_PREFS = "BOOLEAN_PREFERENCES";
    private static final String PREFERENCES = "SPECIAL_PREFERENCES";
    private static final String USER_PREFS = "webapp.user.preferences.";
    private Set<String> configuredPreferences = null;
    private Set<String> booleanPreferences = null;

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String userName;
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        TagManager tagManager = im.getTagManager();
        String page = request.getParameter("page");
        Profile profile = SessionMethods.getProfile(session);
        if (SessionMethods.isSuperUser(session)) {
            Map templateRank;
            TrackerDelegate td = im.getTrackerDelegate();
            Map templateCounter = td.getAccessCounter();
            if (templateCounter != null) {
                request.setAttribute("templateCounter", (Object)templateCounter);
            }
            if ((templateRank = td.getRank(im.getTemplateManager())) != null) {
                request.setAttribute("templateRank", (Object)templateRank);
            }
        }
        if (page != null && !"history".equals(page) && !profile.isLoggedIn()) {
            page = "lists";
        }
        if (!StringUtils.isEmpty((String)page)) {
            session.setAttribute("MYMINE_PAGE", (Object)page);
        }
        if (page != null && "templates".equals(page) && (userName = profile.getUsername()) != null) {
            tagManager.getTags(null, null, "template", userName);
        }
        if (MyMineController.onSubTab(request, "templates")) {
            session.removeAttribute("NEW_TEMPLATE");
            MyMineController.getPrecomputedSummarisedInfo(profile, session, request);
        }
        if (MyMineController.onSubTab(request, "lists") || MyMineController.onSubTab(request, null)) {
            ActionMessages actionErrors = this.getErrors(request);
            if (im.getBagManager().isAnyBagToUpgrade(profile)) {
                actionErrors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("login.upgradeListManually"));
            }
            if (!profile.getInvalidBags().isEmpty()) {
                actionErrors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("bags.invalid.notice"));
            }
            this.saveErrors(request, actionErrors);
        }
        if (MyMineController.onSubTab(request, "account")) {
            Properties webProperties = SessionMethods.getWebProperties(request);
            session.setAttribute(PREFERENCES, this.getConfiguredPreferences(webProperties));
            session.setAttribute(BOOL_PREFS, this.getBooleanPreferences(webProperties));
        }
        return null;
    }

    private Set<String> getConfiguredPreferences(Properties webProperties) {
        if (this.configuredPreferences == null) {
            this.configuredPreferences = new LinkedHashSet<String>(UserPreferences.COMMON_KEYS);
            Properties webPrefs = PropertiesUtil.getPropertiesStartingWith((String)USER_PREFS, (Properties)webProperties);
            for (Object key : webPrefs.keySet()) {
                this.configuredPreferences.add(webProperties.getProperty(String.valueOf(key)));
            }
        }
        return this.configuredPreferences;
    }

    private Set<String> getBooleanPreferences(Properties webProperties) {
        if (this.booleanPreferences == null) {
            this.booleanPreferences = new LinkedHashSet<String>(UserPreferences.BOOLEAN_KEYS);
            Properties webPrefs = PropertiesUtil.getPropertiesStartingWith((String)USER_PREFS, (Properties)webProperties);
            for (Object key : webPrefs.keySet()) {
                String name = String.valueOf(key);
                if (name == null || !name.contains("bool")) continue;
                this.booleanPreferences.add(webProperties.getProperty(name));
            }
        }
        return this.booleanPreferences;
    }

    private static boolean onSubTab(HttpServletRequest request, String inQuestion) {
        WebState webState = SessionMethods.getWebState(request.getSession());
        String subTab = request.getParameter("subtab");
        String wsst = webState.getSubtab("subtabmymine");
        if (inQuestion == null) {
            return subTab == null && wsst == null;
        }
        return subTab != null && inQuestion.equals(subTab) || wsst != null && inQuestion.equals(wsst);
    }

    public static void getPrecomputedSummarisedInfo(Profile profile, HttpSession session, HttpServletRequest request) throws ObjectStoreException {
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        Map templates = profile.getSavedTemplates();
        ObjectStoreInterMineImpl os = (ObjectStoreInterMineImpl)im.getObjectStore();
        HashMap<String, String> precomputedTemplateMap = new HashMap<String, String>();
        HashMap<String, String> summarisedTemplateMap = new HashMap<String, String>();
        TemplateSummariser summariser = im.getTemplateSummariser();
        for (ApiTemplate template : templates.values()) {
            if (!template.isValid()) continue;
            if (session.getAttribute("precomputing_" + template.getName()) != null && "true".equals(session.getAttribute("precomputing_" + template.getName()))) {
                precomputedTemplateMap.put(template.getName(), "precomputing");
            } else {
                Query query = TemplatePrecomputeHelper.getPrecomputeQuery((TemplateQuery)template, new ArrayList(), null);
                precomputedTemplateMap.put(template.getName(), Boolean.toString(os.isPrecomputed(query, "template")));
            }
            if (session.getAttribute("summarising_" + template.getName()) != null && "true".equals(session.getAttribute("summarising_" + template.getName()))) {
                summarisedTemplateMap.put(template.getName(), "summarising");
                continue;
            }
            summarisedTemplateMap.put(template.getName(), Boolean.toString(summariser.isSummarised(template)));
        }
        request.setAttribute("precomputedTemplateMap", precomputedTemplateMap);
        request.setAttribute("summarisedTemplateMap", summarisedTemplateMap);
    }
}

