/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.ProfileManager;
import org.intermine.web.logic.profile.LoginHandler;
import org.intermine.web.logic.profile.ProfileMergeIssues;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.PasswordResetForm;
import org.intermine.web.struts.RequestPasswordAction;

public class PasswordResetAction
extends LoginHandler {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        ProfileManager pm = im.getProfileManager();
        String token = ((PasswordResetForm)form).getToken();
        String password = ((PasswordResetForm)form).getNewpassword();
        session.removeAttribute("passwordResetToken");
        try {
            String username = pm.changePasswordWithToken(token, password);
            ProfileMergeIssues issues = this.doLogin(request, username, password);
            this.recordMessage(new ActionMessage("password.changed", (Object)username), request);
            this.recordMessage(new ActionMessage("login.loggedin", (Object)username), request);
            Map<String, String> renamedBags = issues.getRenamedBags();
            for (String string : renamedBags.keySet()) {
                this.recordMessage(new ActionMessage("login.renamedbags", (Object)string, (Object)renamedBags.get(string)), request);
            }
            for (Map.Entry entry : issues.getRenamedTemplates().entrySet()) {
                this.recordMessage(new ActionMessage("login.failedtemplate", entry.getKey(), entry.getValue()), request);
            }
        }
        catch (Exception e) {
            RequestPasswordAction.LOG.warn((Object)e);
            this.recordError(new ActionMessage("login.invalidemail"), request);
        }
        return mapping.findForward("begin");
    }
}

