/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.pathquery.Node;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.OuterJoinStatus;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathConstraintLoop;
import org.intermine.pathquery.PathConstraintSubclass;
import org.intermine.pathquery.PathQuery;
import org.intermine.template.TemplateQuery;
import org.intermine.web.logic.config.FieldConfig;
import org.intermine.web.logic.config.FieldConfigHelper;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.querybuilder.DisplayPath;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ForwardParameters;
import org.intermine.web.struts.QueryBuilderController;

public class QueryBuilderChange
extends DispatchAction {
    protected static final Logger LOG = Logger.getLogger(QueryBuilderChange.class);

    public ActionForward removeNode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        PathQuery pathQuery = SessionMethods.getQuery(session);
        String path = request.getParameter("path");
        pathQuery.removeAllUnder(path);
        return mapping.findForward("query");
    }

    public ActionForward newConstraint(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        PathQuery query = SessionMethods.getQuery(session).clone();
        String path = request.getParameter("path");
        session.setAttribute("newConstraintPath", (Object)new DisplayPath(query.makePath(path)));
        return new ForwardParameters(mapping.findForward("query")).forward();
    }

    public ActionForward removeConstraint(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        PathQuery query = SessionMethods.getQuery(session);
        String code = request.getParameter("code");
        query.removeConstraint(query.getConstraintForCode(code));
        query.removeAllIrrelevant();
        return mapping.findForward("query");
    }

    public ActionForward removeSubclass(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        PathQuery query = SessionMethods.getQuery(session);
        String path = request.getParameter("path");
        List msgs = query.removeSubclassAndFixUp(path);
        for (String message : msgs) {
            SessionMethods.recordMessage(message, session);
        }
        return mapping.findForward("query");
    }

    public ActionForward editConstraint(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        PathQuery query = SessionMethods.getQuery(session);
        String code = request.getParameter("code");
        PathConstraint c = query.getConstraintForCode(code);
        session.setAttribute("editingConstraint", (Object)c);
        return mapping.findForward("query");
    }

    public ActionForward editTemplateConstraint(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        PathQuery query = SessionMethods.getQuery(session);
        String code = request.getParameter("code");
        session.setAttribute("editingTemplateConstraint", (Object)Boolean.TRUE);
        PathConstraint c = query.getConstraintForCode(code);
        session.setAttribute("editingConstraint", (Object)c);
        return mapping.findForward("query");
    }

    public ActionForward editJoinStyle(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        String path = request.getParameter("path");
        session.setAttribute("joinStylePath", (Object)path);
        return mapping.findForward("query");
    }

    public ActionForward changePath(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        String path = request.getParameter("path");
        session.setAttribute("path", (Object)path);
        return new ForwardParameters(mapping.findForward("query")).forward();
    }

    public ActionForward startTemplateBuild(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        PathQuery query = SessionMethods.getQuery(session);
        TemplateQuery template = new TemplateQuery("", "", "", query);
        for (PathConstraint con : query.getConstraints().keySet()) {
            if (con instanceof PathConstraintLoop || con instanceof PathConstraintSubclass) continue;
            template.setEditable(con, true);
        }
        SessionMethods.loadQuery((PathQuery)template, session, response);
        session.setAttribute("NEW_TEMPLATE", (Object)Boolean.TRUE);
        session.removeAttribute("EDITING_TEMPLATE");
        session.removeAttribute("PREV_TEMPLATE_NAME");
        return mapping.findForward("query");
    }

    public ActionForward stopTemplateBuild(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        session.removeAttribute("NEW_TEMPLATE");
        session.removeAttribute("EDITING_TEMPLATE");
        return mapping.findForward("query");
    }

    public ActionForward addToView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        WebConfig webConfig = SessionMethods.getWebConfig(request);
        String pathName = request.getParameter("path");
        PathQuery query = SessionMethods.getQuery(session);
        if (query.getView().contains(pathName)) {
            return new ForwardParameters(mapping.findForward("query")).forward();
        }
        Path path = query.makePath(pathName);
        if (path.isRootPath() || path.endIsReference() || path.endIsCollection()) {
            ClassDescriptor cld = path.getEndClassDescriptor();
            for (FieldConfig fc : FieldConfigHelper.getClassFieldConfigs(webConfig, cld)) {
                Path pathToAdd = query.makePath(path.toStringNoConstraints() + "." + fc.getFieldExpr());
                if (!pathToAdd.endIsAttribute() || query.getView().contains(pathToAdd.getNoConstraintsString()) || fc.getDisplayer() != null || !fc.getShowInSummary()) continue;
                query.addView(pathToAdd.getNoConstraintsString());
                if (!fc.getOuterInSummary() || pathToAdd.decomposePath().size() <= 2) continue;
                query.setOuterJoinStatus(pathToAdd.getPrefix().getNoConstraintsString(), OuterJoinStatus.OUTER);
            }
        } else {
            query.addView(pathName);
        }
        if (query.getOrderBy().isEmpty()) {
            for (String view : query.getView()) {
                if (!query.isPathCompletelyInner(view)) continue;
                query.addOrderBy(view, OrderDirection.ASC);
                break;
            }
        }
        return new ForwardParameters(mapping.findForward("query")).forward();
    }

    public ActionForward ajaxExpand(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.changePath(mapping, form, request, response);
        QueryBuilderController.populateRequest(request, response);
        ArrayList<Node> newNodes = new ArrayList<Node>();
        Collection nodes = (Collection)request.getAttribute("nodes");
        for (Node node : nodes) {
            if (!node.getPathString().startsWith(request.getParameter("path") + ".")) continue;
            newNodes.add(node);
        }
        request.setAttribute("nodes", newNodes);
        request.setAttribute("noTreeIds", (Object)Boolean.TRUE);
        request.setAttribute("scrollTo", (Object)request.getParameter("path"));
        return mapping.findForward("browserLines");
    }

    public ActionForward ajaxCollapse(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.changePath(mapping, form, request, response);
        return null;
    }

    public ActionForward ajaxNewConstraint(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.newConstraint(mapping, form, request, response);
        return mapping.findForward("queryBuilderConstraint");
    }

    public ActionForward ajaxEditConstraint(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.editConstraint(mapping, form, request, response);
        return mapping.findForward("queryBuilderConstraint");
    }

    public ActionForward ajaxEditTemplateConstraint(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.editTemplateConstraint(mapping, form, request, response);
        return mapping.findForward("queryBuilderConstraint");
    }

    public ActionForward ajaxRenderPaths(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        QueryBuilderController.populateRequest(request, response);
        return mapping.findForward("queryPaths");
    }

    public ActionForward ajaxEditJoinStyle(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.editJoinStyle(mapping, form, request, response);
        return mapping.findForward("queryBuilderConstraint");
    }
}

