/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.metadata.TypeUtil;
import org.intermine.pathquery.OrderElement;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.query.MetadataNode;
import org.intermine.web.logic.querybuilder.ModelBrowserHelper;
import org.intermine.web.logic.session.SessionMethods;

public class QueryBuilderController
extends TilesAction {
    protected static final Logger LOG = Logger.getLogger(QueryBuilderController.class);

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(request.getSession());
        Profile profile = SessionMethods.getProfile(session);
        if (im.getBagManager().isAnyBagToUpgrade(profile)) {
            ActionMessages actionErrors = this.getErrors(request);
            actionErrors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("login.upgradeListManually"));
            this.saveErrors(request, actionErrors);
        }
        ActionMessages msgs = this.getMessages(request);
        for (String removedOrderBy : QueryBuilderController.populateRequest(request, response)) {
            msgs.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("querybuilder.assuresortorder.removeorderby", (Object)removedOrderBy));
        }
        this.saveMessages(request, msgs);
        return null;
    }

    public static Collection<String> populateRequest(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        Model model = im.getModel();
        PathQuery query = SessionMethods.getQuery(session);
        Collection<String> removedOrderBys = QueryBuilderController.assureCorrectSortOrder(query);
        try {
            request.setAttribute("viewStrings", QueryBuilderController.findViewSortOrders(query));
            request.setAttribute("viewPaths", QueryBuilderController.listToMap(query.getView()));
            WebConfig webConfig = SessionMethods.getWebConfig(request);
            boolean isSuperUser = SessionMethods.isSuperUser(session);
            String prefix = (String)session.getAttribute("prefix");
            String path = (String)session.getAttribute("path");
            if (path == null) {
                path = prefix;
            }
            Collection<MetadataNode> nodes = ModelBrowserHelper.makeSelectedNodes(path, prefix, model, isSuperUser, query, webConfig, (Map<String, List<FieldDescriptor>>)im.getClassKeys(), im.getBagManager(), SessionMethods.getProfile(session), im.getObjectStoreSummary());
            request.setAttribute("nodes", nodes);
            Map<String, String> prefixes = QueryBuilderController.getViewPathLinkPaths(query);
            request.setAttribute("viewPathLinkPrefixes", prefixes);
            request.setAttribute("viewPathLinkPaths", QueryBuilderController.getPathTypes(prefixes.values(), query));
        }
        catch (PathException e) {
            LOG.error((Object)("PathQuery is invalid: " + query), (Throwable)e);
        }
        return removedOrderBys;
    }

    private static Collection<String> assureCorrectSortOrder(PathQuery pathQuery) {
        HashSet<String> ret = new HashSet<String>();
        for (OrderElement order : pathQuery.getOrderBy()) {
            if (pathQuery.getView().contains(order.getOrderPath())) continue;
            pathQuery.removeOrderBy(order.getOrderPath());
            ret.add(order.getOrderPath());
        }
        return ret;
    }

    private static Map<String, String> findViewSortOrders(PathQuery pathQuery) throws PathException {
        LinkedHashMap<String, String> retval = new LinkedHashMap<String, String>();
        List orderList = pathQuery.getOrderBy();
        OrderElement order = orderList.isEmpty() ? null : (OrderElement)orderList.get(0);
        for (String view : pathQuery.getView()) {
            if (pathQuery.isPathCompletelyInner(view)) {
                if (order != null && view.equals(order.getOrderPath())) {
                    retval.put(view, order.getDirection().toString().toLowerCase());
                    continue;
                }
                retval.put(view, "none");
                continue;
            }
            retval.put(view, "disabled");
        }
        return retval;
    }

    private static Map<String, String> getPathTypes(Collection<String> paths, PathQuery pathQuery) {
        HashMap<String, String> viewPathTypes = new HashMap<String, String>();
        for (String path : paths) {
            try {
                String unqualifiedName = TypeUtil.unqualifiedName((String)pathQuery.makePath(path).getEndType().getName());
                viewPathTypes.put(path, unqualifiedName);
            }
            catch (PathException e) {
                throw new Error("There must be a bug", e);
            }
        }
        return viewPathTypes;
    }

    private static Map<String, String> getViewPathLinkPaths(PathQuery pathQuery) throws PathException {
        HashMap<String, String> linkPaths = new HashMap<String, String>();
        for (String viewString : pathQuery.getView()) {
            Path path = pathQuery.makePath(viewString);
            if (path.endIsAttribute()) {
                linkPaths.put(viewString, path.getPrefix().toStringNoConstraints());
                continue;
            }
            linkPaths.put(viewString, viewString);
        }
        return linkPaths;
    }

    private static <E> Map<E, Boolean> listToMap(Collection<E> list) {
        HashMap<E, Boolean> map = new HashMap<E, Boolean>();
        for (E o : list) {
            map.put(o, Boolean.TRUE);
        }
        return map;
    }
}

