/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.tracker.util.ListBuildMode;
import org.intermine.web.logic.results.PagedTable;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ForwardParameters;
import org.intermine.web.struts.InterMineAction;
import org.intermine.web.struts.SaveBagForm;

public class SaveBagAction
extends InterMineAction {
    protected static final Logger LOG = Logger.getLogger(SaveBagAction.class);
    public static final int BIG_BATCH_SIZE = 10000;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.saveBag(mapping, form, request, response);
    }

    public ActionForward saveBag(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        Profile profile = SessionMethods.getProfile(session);
        PagedTable pt = SessionMethods.getResultsTable(session, request.getParameter("table"));
        SaveBagForm sbf = (SaveBagForm)form;
        String bagName = null;
        String operation = "";
        if (request.getParameter("saveNewBag") != null || sbf.getOperationButton() != null && "saveNewBag".equals(sbf.getOperationButton())) {
            bagName = sbf.getNewBagName();
            operation = "saveNewBag";
        } else {
            bagName = sbf.getExistingBagName();
            operation = "addToBag";
        }
        if (bagName == null) {
            return null;
        }
        if (pt.isEmptySelection()) {
            ActionMessage actionMessage = new ActionMessage("errors.bag.empty");
            this.recordError(actionMessage, request);
            return mapping.findForward("results");
        }
        InterMineBag bag = (InterMineBag)profile.getSavedBags().get(bagName);
        if (bag != null && !bag.getType().equals(pt.getSelectedClass())) {
            ActionMessage actionMessage = new ActionMessage("bag.moreThanOneType");
            this.recordError(actionMessage, request);
            return mapping.findForward("results");
        }
        try {
            InterMineAPI im;
            if (bag == null) {
                im = SessionMethods.getInterMineAPI(session);
                bag = profile.createBag(bagName, pt.getSelectedClass(), "", (Map)im.getClassKeys());
            }
            pt.addSelectedToBag(bag);
            this.recordMessage(new ActionMessage("bag.saved", (Object)bagName), request);
            SessionMethods.invalidateBagTable(session, bagName);
            if ("saveNewBag".equals(operation)) {
                im = SessionMethods.getInterMineAPI(session);
                im.getTrackerDelegate().trackListCreation(bag.getType(), bag.getSize(), ListBuildMode.QUERY, profile, session.getId());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to save bag", (Throwable)e);
            this.recordError(new ActionMessage("An error occured while saving the bag"), request);
            return mapping.findForward("results");
        }
        if ("saveNewBag".equals(operation)) {
            ForwardParameters forwardParameters = new ForwardParameters(mapping.findForward("bag"));
            forwardParameters.addParameter("bagName", bag.getName());
            forwardParameters.addParameter("trackExecution", "false");
            return forwardParameters.forward();
        }
        return mapping.findForward("results");
    }
}

