/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.searchengine.solr.SolrKeywordSearchHandler;
import org.intermine.api.util.NameUtil;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ForwardParameters;
import org.intermine.web.struts.InterMineAction;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SaveFromIdsToBagAction
extends InterMineAction {
    protected static final Logger LOG = Logger.getLogger(SaveFromIdsToBagAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Profile profile = SessionMethods.getProfile(session);
        String source = request.getParameter("source");
        Set<Integer> idSet = new LinkedHashSet<Integer>();
        try {
            String type = request.getParameter("type");
            String allChecked = request.getParameter("allChecked");
            InterMineAPI im = SessionMethods.getInterMineAPI(session);
            if ("true".equals(allChecked)) {
                String totalHits = request.getParameter("totalHits");
                int listSize = Integer.parseInt(totalHits);
                String searchTerm = request.getParameter("searchTerm");
                JSONObject jsonRequest = new JSONObject(request.getParameter("jsonFacets"));
                Map<String, String> facetMap = this.jsonToJava(jsonRequest);
                int offset = 0;
                SolrKeywordSearchHandler keywordSearchHandler = new SolrKeywordSearchHandler();
                idSet = keywordSearchHandler.getObjectIdsFromSearch(im, searchTerm, offset, facetMap, new ArrayList(), listSize);
            } else {
                String[] idArray;
                for (String id : idArray = request.getParameter("ids").split(",")) {
                    idSet.add(Integer.valueOf(id.trim()));
                }
            }
            String bagName = request.getParameter("newBagName");
            if (bagName == null) {
                bagName = "new_list";
            }
            bagName = NameUtil.generateNewName(profile.getSavedBags().keySet(), (String)bagName);
            InterMineBag bag = profile.createBag(bagName, type, "", (Map)im.getClassKeys());
            bag.addIdsToBag(idSet, type);
            profile.saveBag(bag.getName(), bag);
            ForwardParameters forwardParameters = new ForwardParameters(mapping.findForward("bagDetails"));
            return forwardParameters.addParameter("bagName", bagName).forward();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.recordError(new ActionMessage(e.toString()), request);
                ActionForward actionForward = mapping.findForward("bagDetails");
                ActionForward newActionForward = new ActionForward(actionForward);
                if (request.getQueryString() == null) {
                    newActionForward.setPath("/" + source + ".do");
                } else {
                    newActionForward.setPath("/" + source + ".do?" + request.getQueryString());
                }
                return newActionForward;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.recordError(new ActionMessage("Error...Please report..."), request);
                return mapping.findForward("begin");
            }
        }
    }

    private Map<String, String> jsonToJava(JSONObject json) throws JSONException {
        JSONArray ja = json.getJSONArray("facets");
        HashMap<String, String> facets = new HashMap<String, String>();
        for (int i = 0; i < ja.length(); ++i) {
            JSONObject facet = ja.getJSONObject(i);
            String name = facet.getString("facetName");
            String value = facet.getString("facetValue");
            facets.put(name, value);
            LOG.error((Object)("faceting -- " + name + " value - " + value));
        }
        return facets;
    }
}

