/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.codegen.WebserviceCodeGenInfo;
import org.intermine.api.query.codegen.WebserviceJavaScriptCodeGenerator;
import org.intermine.api.template.ApiTemplate;
import org.intermine.api.template.TemplateManager;
import org.intermine.api.template.TemplatePopulator;
import org.intermine.api.util.NameUtil;
import org.intermine.metadata.ConstraintOp;
import org.intermine.metadata.StringUtil;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathConstraintAttribute;
import org.intermine.pathquery.PathConstraintBag;
import org.intermine.pathquery.PathConstraintLookup;
import org.intermine.pathquery.PathConstraintLoop;
import org.intermine.pathquery.PathConstraintMultiValue;
import org.intermine.pathquery.PathConstraintNull;
import org.intermine.pathquery.PathConstraintSubclass;
import org.intermine.pathquery.PathQuery;
import org.intermine.template.SwitchOffAbility;
import org.intermine.template.TemplateQuery;
import org.intermine.template.TemplateValue;
import org.intermine.web.logic.query.DisplayConstraint;
import org.intermine.web.logic.query.DisplayConstraintFactory;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ForwardParameters;
import org.intermine.web.struts.InterMineAction;
import org.intermine.web.struts.TemplateForm;
import org.intermine.web.struts.WebserviceCodeGenAction;
import org.intermine.web.util.URLGenerator;
import org.intermine.webservice.server.template.result.TemplateResultLinkGenerator;

public class TemplateAction
extends InterMineAction {
    public static final String SKIP_BUILDER_PARAMETER = "skipBuilder";
    public static final String TEMPLATE_ACTION_PATH = "templateAction.do";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        TemplateForm tf = (TemplateForm)form;
        String templateName = tf.getName();
        boolean saveQuery = request.getParameter("noSaveQuery") == null;
        boolean skipBuilder = request.getParameter(SKIP_BUILDER_PARAMETER) != null;
        boolean editTemplate = request.getParameter("editTemplate") != null;
        boolean editQuery = request.getParameter("editQuery") != null;
        String scope = tf.getScope();
        if (StringUtils.isBlank((String)scope)) {
            scope = "all";
        }
        SessionMethods.logTemplateQueryUse(session, scope, templateName);
        Profile profile = SessionMethods.getProfile(session);
        TemplateManager templateManager = im.getTemplateManager();
        ApiTemplate template = templateManager.getTemplate(profile, templateName, scope);
        if (template == null) {
            PathQuery query = SessionMethods.getQuery(session);
            if (query instanceof TemplateQuery) {
                TemplateQuery currentTemplate = (TemplateQuery)query;
                template = templateManager.getTemplate(profile, currentTemplate.getName(), scope);
            } else {
                template = templateManager.getTemplate(profile, (String)session.getAttribute("templateName"), scope);
            }
        }
        if (template == null) {
            if (editTemplate) {
                this.recordMessage(new ActionMessage("errors.edittemplate.empty"), request);
                return mapping.findForward("template");
            }
            throw new RuntimeException("Could not find a template called " + session.getAttribute("templateName"));
        }
        TemplateQuery populatedTemplate = TemplatePopulator.getPopulatedTemplate((TemplateQuery)template, this.templateFormToTemplateValues(tf, (TemplateQuery)template));
        DisplayConstraintFactory factory = new DisplayConstraintFactory(im, null);
        DisplayConstraint displayConstraint = null;
        ArrayList<DisplayConstraint> displayConstraintList = new ArrayList<DisplayConstraint>();
        for (PathConstraint pathConstraint : populatedTemplate.getEditableConstraints()) {
            displayConstraint = factory.get(pathConstraint, profile, (PathQuery)populatedTemplate);
            displayConstraintList.add(displayConstraint);
        }
        session.setAttribute("dcl", displayConstraintList);
        String url = new URLGenerator(request).getPermanentBaseURL();
        if (!populatedTemplate.isValid()) {
            this.recordError(new ActionMessage("errors.template.badtemplate", (Object)StringUtil.prettyList((Collection)populatedTemplate.verifyQuery())), request);
            return mapping.findForward("template");
        }
        if (!editQuery && !skipBuilder && !editTemplate && this.forwardToLinksPage(request)) {
            Properties webProperties = SessionMethods.getWebProperties(request.getSession().getServletContext());
            WebserviceCodeGenInfo info = new WebserviceCodeGenInfo((PathQuery)populatedTemplate, url, webProperties.getProperty("project.title"), webProperties.getProperty("perl.wsModuleVer"), WebserviceCodeGenAction.templateIsPublic((TemplateQuery)template, im, profile), profile);
            WebserviceJavaScriptCodeGenerator codeGen = new WebserviceJavaScriptCodeGenerator();
            String code = codeGen.generate(info);
            session.setAttribute("realCode", (Object)code);
            String escapedCode = StringEscapeUtils.escapeHtml((String)code);
            session.setAttribute("jsCode", (Object)escapedCode);
            return mapping.findForward("serviceLink");
        }
        if (!editQuery && !skipBuilder && !editTemplate && this.wantsWebserviceURL(request)) {
            TemplateResultLinkGenerator gen = new TemplateResultLinkGenerator();
            String webserviceUrl = gen.getTabLink(url, populatedTemplate);
            response.setContentType("text/plain");
            try {
                PrintStream out = new PrintStream((OutputStream)response.getOutputStream());
                out.print(webserviceUrl);
                out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
        if (!editQuery && !skipBuilder && !editTemplate && this.exportTemplate(request)) {
            SessionMethods.loadQuery((PathQuery)populatedTemplate, request.getSession(), response);
            return mapping.findForward("export");
        }
        if (!editQuery && !skipBuilder && !editTemplate && this.codeGenTemplate(request)) {
            SessionMethods.loadQuery((PathQuery)populatedTemplate, request.getSession(), response);
            return new ForwardParameters(mapping.findForward("codeGen")).addParameter("method", request.getParameter("actionType")).addParameter("source", "templateQuery").forward();
        }
        if (!skipBuilder && !editTemplate) {
            SessionMethods.loadQuery(new PathQuery((PathQuery)populatedTemplate), request.getSession(), response);
            session.setAttribute("templateName", (Object)populatedTemplate.getName());
            session.removeAttribute("NEW_TEMPLATE");
            session.removeAttribute("EDITING_TEMPLATE");
            form.reset(mapping, request);
            return mapping.findForward("query");
        }
        if (editTemplate) {
            session.removeAttribute("NEW_TEMPLATE");
            session.setAttribute("EDITING_TEMPLATE", (Object)Boolean.TRUE);
            SessionMethods.loadQuery((PathQuery)template, request.getSession(), response);
            if (!template.isValid()) {
                this.recordError(new ActionMessage("errors.template.badtemplate", (Object)StringUtil.prettyList((Collection)template.verifyQuery())), request);
            }
            return mapping.findForward("query");
        }
        if (saveQuery) {
            SessionMethods.loadQuery((PathQuery)populatedTemplate, request.getSession(), response);
        }
        form.reset(mapping, request);
        im.getTrackerDelegate().trackTemplate(populatedTemplate.getName(), profile, session.getId());
        String trail = "";
        trail = saveQuery ? "%7Cquery" : "";
        String queryName = NameUtil.findNewQueryName(profile.getHistory().keySet());
        SessionMethods.saveQueryToHistory(session, queryName, populatedTemplate.getQueryToExecute());
        return new ForwardParameters(mapping.findForward("results")).addParameter("trail", trail).forward();
    }

    private boolean forwardToLinksPage(HttpServletRequest request) {
        return "links".equalsIgnoreCase(request.getParameter("actionType"));
    }

    private boolean wantsWebserviceURL(HttpServletRequest request) {
        return "webserviceURL".equals(request.getParameter("actionType"));
    }

    private boolean exportTemplate(HttpServletRequest request) {
        return "exportTemplate".equals(request.getParameter("actionType"));
    }

    private boolean codeGenTemplate(HttpServletRequest request) {
        String codeGenTemplate = request.getParameter("actionType");
        return codeGenTemplate != null && ("perl".equalsIgnoreCase(codeGenTemplate) || "java".equalsIgnoreCase(codeGenTemplate) || "python".equalsIgnoreCase(codeGenTemplate) || "ruby".equalsIgnoreCase(codeGenTemplate) || "javascript".equalsIgnoreCase(codeGenTemplate));
    }

    protected Map<String, List<TemplateValue>> templateFormToTemplateValues(TemplateForm tf, TemplateQuery template) {
        HashMap<String, List<TemplateValue>> templateValues = new HashMap<String, List<TemplateValue>>();
        for (String node : template.getEditablePaths()) {
            ArrayList<TemplateValue> nodeValues = new ArrayList<TemplateValue>();
            templateValues.put(node, nodeValues);
            for (PathConstraint c : template.getEditableConstraints(node)) {
                String key = Integer.toString(template.getEditableConstraints().indexOf(c) + 1);
                TemplateValue value = null;
                SwitchOffAbility switchOffAbility = template.getSwitchOffAbility(c);
                if (tf.getSwitchOff(key) != null) {
                    switchOffAbility = this.parseSwitchOffAbility(tf.getSwitchOff(key));
                }
                if (tf.getUseBagConstraint(key)) {
                    ConstraintOp constraintOp = ConstraintOp.getOpForIndex((Integer)Integer.valueOf(tf.getBagOp(key)));
                    String constraintValue = (String)tf.getBag(key);
                    value = new TemplateValue(c, constraintOp, constraintValue, TemplateValue.ValueType.BAG_VALUE, switchOffAbility);
                } else if (tf.getSwitchOff(key) != null && tf.getSwitchOff(key).equalsIgnoreCase(SwitchOffAbility.OFF.toString())) {
                    if (c instanceof PathConstraintMultiValue) {
                        String multiValueAttribute = this.constraintStringValue(c);
                        if (multiValueAttribute != null && !"".equals(multiValueAttribute)) {
                            ArrayList<String> multiValues = new ArrayList<String>();
                            multiValues.addAll(Arrays.asList(multiValueAttribute.split(",")));
                            value = new TemplateValue(c, c.getOp(), TemplateValue.ValueType.SIMPLE_VALUE, multiValues, switchOffAbility);
                        }
                    } else {
                        String constraintValue = this.constraintStringValue(c);
                        value = new TemplateValue(c, c.getOp(), constraintValue, TemplateValue.ValueType.SIMPLE_VALUE, switchOffAbility);
                    }
                } else {
                    String[] ops = (String[])tf.getAttributeOps(key);
                    String op = ops[0];
                    if (op == null) {
                        if (c instanceof PathConstraintLookup) {
                            value = new TemplateValue(c, ConstraintOp.LOOKUP, (String)tf.getAttributeValues(key), TemplateValue.ValueType.SIMPLE_VALUE, this.extraValueToString(tf.getExtraValues(key)), switchOffAbility);
                        } else {
                            if (tf.getNullConstraint(key) == null) continue;
                            value = ConstraintOp.IS_NULL.toString().equals(tf.getNullConstraint(key)) ? new TemplateValue(c, ConstraintOp.IS_NULL, ConstraintOp.IS_NULL.toString(), TemplateValue.ValueType.SIMPLE_VALUE, switchOffAbility) : new TemplateValue(c, ConstraintOp.IS_NOT_NULL, ConstraintOp.IS_NOT_NULL.toString(), TemplateValue.ValueType.SIMPLE_VALUE, switchOffAbility);
                        }
                    } else {
                        ConstraintOp constraintOp = ConstraintOp.getOpForIndex((Integer)Integer.valueOf(op));
                        String constraintValue = "";
                        String multiValueAttribute = tf.getMultiValueAttribute(key);
                        if (multiValueAttribute != null && !"".equals(multiValueAttribute)) {
                            constraintValue = tf.getMultiValueAttribute(key);
                            ArrayList<String> multiValues = new ArrayList<String>();
                            multiValues.addAll(Arrays.asList(constraintValue.split(",")));
                            value = new TemplateValue(c, constraintOp, TemplateValue.ValueType.SIMPLE_VALUE, multiValues, switchOffAbility);
                        } else {
                            String[] attributes = (String[])tf.getAttributeValues(key);
                            constraintValue = attributes[0];
                            String[] extraValues = (String[])tf.getExtraValues(key);
                            String extraValue = extraValues == null ? "" : extraValues[0];
                            value = new TemplateValue(c, constraintOp, constraintValue, TemplateValue.ValueType.SIMPLE_VALUE, extraValue, switchOffAbility);
                        }
                    }
                }
                nodeValues.add(value);
            }
        }
        return templateValues;
    }

    private String constraintStringValue(PathConstraint con) {
        if (con instanceof PathConstraintAttribute) {
            return ((PathConstraintAttribute)con).getValue();
        }
        if (con instanceof PathConstraintBag) {
            return ((PathConstraintBag)con).getBag();
        }
        if (con instanceof PathConstraintLookup) {
            return ((PathConstraintLookup)con).getValue();
        }
        if (con instanceof PathConstraintSubclass) {
            return ((PathConstraintSubclass)con).getType();
        }
        if (con instanceof PathConstraintLoop) {
            return ((PathConstraintLoop)con).getLoopPath();
        }
        if (con instanceof PathConstraintNull) {
            return ((PathConstraintNull)con).getOp().toString();
        }
        if (con instanceof PathConstraintMultiValue) {
            Collection multiValuesCollection = ((PathConstraintMultiValue)con).getValues();
            String multiValuesAsString = "";
            if (multiValuesCollection != null) {
                for (String value : multiValuesCollection) {
                    multiValuesAsString = multiValuesAsString + value + ",";
                }
            }
            return multiValuesAsString;
        }
        return null;
    }

    private String extraValueToString(Object extraValue) {
        if (extraValue == null) {
            return null;
        }
        return extraValue.toString();
    }

    private SwitchOffAbility parseSwitchOffAbility(String value) {
        for (SwitchOffAbility switchOffAbility : SwitchOffAbility.values()) {
            if (!switchOffAbility.toString().equalsIgnoreCase(value)) continue;
            return switchOffAbility;
        }
        throw new IllegalArgumentException("Invalid value specified for constraint switchOffAbility '" + value + "', if this happens there is a bug. ");
    }
}

